/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.Range;
import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreEntrySubSet;
import ghidra.util.database.DBCachedObjectStoreKeySubSet;
import ghidra.util.database.DBCachedObjectStoreMap;
import ghidra.util.database.DBCachedObjectStoreValueSubCollection;
import ghidra.util.database.DirectedIterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreSubMap<T extends DBAnnotatedObject>
extends DBCachedObjectStoreMap<T> {
    protected final Range<Long> keyRange;

    public DBCachedObjectStoreSubMap(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction, Range<Long> keyRange) {
        super(store, errHandler, lock, direction);
        this.keyRange = keyRange;
    }

    @Override
    public int size() {
        return this.store.getKeyCount(this.keyRange);
    }

    @Override
    public boolean isEmpty() {
        return !this.store.getKeysExist(this.keyRange);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(key, this.keyRange));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.contains(value, this.keyRange));
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        long kl = (Long)key;
        if (!this.keyRange.contains((Comparable)Long.valueOf(kl))) {
            return null;
        }
        return this.store.getObjectAt(kl);
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        long kl = (Long)key;
        if (!this.keyRange.contains((Comparable)Long.valueOf(kl))) {
            return null;
        }
        return this.store.deleteKey(kl);
    }

    @Override
    public void clear() {
        this.store.deleteKeys(this.keyRange);
    }

    @Override
    public Map.Entry<Long, T> firstEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.first(this.direction, this.keyRange));
    }

    @Override
    public Long firstKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> lastEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.last(this.direction, this.keyRange));
    }

    @Override
    public Long lastKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> lowerEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.lower(this.direction, key, this.keyRange));
    }

    @Override
    public Long lowerKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, key, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> floorEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.floor(this.direction, key, this.keyRange));
    }

    @Override
    public Long floorKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, key, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> ceilingEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.ceiling(this.direction, key, this.keyRange));
    }

    @Override
    public Long ceilingKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, key, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> higherEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.higher(this.direction, key, this.keyRange));
    }

    @Override
    public Long higherKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, key, this.keyRange));
    }

    @Override
    public Map.Entry<Long, T> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Long, T> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBCachedObjectStoreKeySubSet keySet() {
        return this.navigableKeySet();
    }

    @Override
    public DBCachedObjectStoreValueSubCollection<T> values() {
        return new DBCachedObjectStoreValueSubCollection(this.store, this.errHandler, this.lock, this.direction, this.keyRange);
    }

    @Override
    public DBCachedObjectStoreEntrySubSet<T> entrySet() {
        return new DBCachedObjectStoreEntrySubSet(this.store, this.errHandler, this.lock, this.direction, this.keyRange);
    }

    @Override
    public DBCachedObjectStoreSubMap<T> descendingMap() {
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keyRange);
    }

    @Override
    public DBCachedObjectStoreKeySubSet navigableKeySet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, this.direction, this.keyRange);
    }

    @Override
    public DBCachedObjectStoreKeySubSet descendingKeySet() {
        return new DBCachedObjectStoreKeySubSet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction), this.keyRange);
    }

    @Override
    public DBCachedObjectStoreSubMap<T> subMap(Long fromKey, boolean fromInclusive, Long toKey, boolean toInclusive) {
        Range<Long> rng = DBCachedObjectStore.toRange(fromKey, fromInclusive, toKey, toInclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }

    @Override
    public DBCachedObjectStoreSubMap<T> headMap(Long toKey, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeHead(toKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }

    @Override
    public DBCachedObjectStoreSubMap<T> tailMap(Long fromKey, boolean inclusive) {
        Range<Long> rng = DBCachedObjectStore.toRangeTail(fromKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, (Range<Long>)this.keyRange.intersection(rng));
    }
}

