/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OperandValueSolver
extends AbstractExpressionSolver<OperandValue> {
    public OperandValueSolver() {
        super(OperandValue.class);
    }

    protected PatternExpression getDefiningExpression(OperandSymbol sym) {
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp != null) {
            return patexp;
        }
        TripleSymbol defSym = sym.getDefiningSymbol();
        if (defSym == null) {
            return null;
        }
        patexp = defSym.getPatternExpression();
        return patexp;
    }

    @Override
    public AssemblyResolution solve(OperandValue ov, MaskedLong goal, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = this.getDefiningExpression(sym);
        if (patexp == null) {
            if (goal.equals(MaskedLong.ZERO)) {
                return AssemblyResolution.nop(description, null);
            }
            return AssemblyResolution.error("Operand " + sym.getName() + " is undefined and does not agree with child requirements", description, null);
        }
        AssemblyResolution result = this.solver.solve(patexp, goal, vals, res, cur, hints, description);
        if (result.isError()) {
            AssemblyResolvedError err = (AssemblyResolvedError)result;
            return AssemblyResolution.error(err.getError(), "Solution to " + sym.getName() + " := " + goal + " = " + patexp, List.of(result));
        }
        AssemblyResolvedConstructor con = (AssemblyResolvedConstructor)result;
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons, res);
        return con.shift(shamt);
    }

    @Override
    public MaskedLong getValue(OperandValue ov, Map<String, Long> vals, Map<Integer, Object> res, AssemblyResolvedConstructor cur) throws NeedsBackfillException {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = this.getDefiningExpression(sym);
        if (patexp == null) {
            return MaskedLong.ZERO;
        }
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons, res);
        cur = cur == null ? null : cur.truncate(shamt);
        MaskedLong result = this.solver.getValue(patexp, vals, res, cur);
        return result;
    }

    @Override
    public int getInstructionLength(OperandValue ov, Map<Integer, Object> res) {
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null) {
            return 0;
        }
        int length = this.solver.getInstructionLength(patexp, res);
        int shamt = AssemblyTreeResolver.computeOffset(sym, cons, res);
        return length + shamt;
    }

    @Override
    public MaskedLong valueForResolution(OperandValue ov, AssemblyResolvedConstructor rc) {
        TripleSymbol defSym;
        Constructor cons = ov.getConstructor();
        OperandSymbol sym = cons.getOperand(ov.getIndex());
        PatternExpression patexp = sym.getDefiningExpression();
        if (patexp == null && (defSym = sym.getDefiningSymbol()) != null) {
            patexp = defSym.getPatternExpression();
        }
        if (patexp == null) {
            return MaskedLong.ZERO;
        }
        return this.solver.valueForResolution(patexp, rc);
    }
}

