/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slgh_compile.ExprTree;
import ghidra.pcodeCPort.slgh_compile.SectionVector;
import ghidra.pcodeCPort.slgh_compile.StarQuality;
import ghidra.pcodeCPort.slghsymbol.LabelSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.SectionSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SpecificSymbol;
import ghidra.pcodeCPort.slghsymbol.UserOpSymbol;
import ghidra.pcodeCPort.slghsymbol.VarnodeSymbol;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.sleigh.grammar.Location;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PcodeCompile {
    public static final Logger log = LogManager.getLogger(PcodeCompile.class);
    public VectorSTL<String> noplist = new VectorSTL();
    private int local_labelcount;
    private int errors;
    private int warnings;
    private boolean enforceLocalKey = false;

    public void setEnforceLocalKey(boolean val) {
        this.enforceLocalKey = val;
    }

    public abstract AddrSpace getDefaultSpace();

    public abstract AddrSpace getConstantSpace();

    public abstract AddrSpace getUniqueSpace();

    public abstract long allocateTemp();

    public abstract void addSymbol(SleighSymbol var1);

    public abstract SleighSymbol findSymbol(String var1);

    public abstract SectionSymbol newSectionSymbol(Location var1, String var2);

    public abstract VectorSTL<OpTpl> createCrossBuild(Location var1, VarnodeTpl var2, SectionSymbol var3);

    public abstract SectionVector standaloneSection(ConstructTpl var1);

    public abstract SectionVector firstNamedSection(ConstructTpl var1, SectionSymbol var2);

    public abstract SectionVector nextNamedSection(SectionVector var1, ConstructTpl var2, SectionSymbol var3);

    public abstract SectionVector finalNamedSection(SectionVector var1, ConstructTpl var2);

    public abstract VectorSTL<OpTpl> createMacroUse(Location var1, MacroSymbol var2, VectorSTL<ExprTree> var3);

    public abstract void recordNop(Location var1);

    public void reportError(Location location, String msg) {
        PcodeCompile.entry("reportError", location, msg);
        log.error(MessageFormattingUtils.format(location, msg));
        ++this.errors;
    }

    public int getErrors() {
        return this.errors;
    }

    public void reportWarning(Location location, String msg) {
        PcodeCompile.entry("reportWarning", location, msg);
        log.warn(MessageFormattingUtils.format(location, msg));
        ++this.warnings;
    }

    public int getWarnings() {
        return this.warnings;
    }

    public void resetLabelCount() {
        this.local_labelcount = 0;
    }

    private void force_size(VarnodeTpl vt, ConstTpl size, VectorSTL<OpTpl> ops) {
        if (vt.getSize().getType() != ConstTpl.const_type.real || vt.getSize().getReal() != 0L) {
            return;
        }
        vt.setSize(size);
        if (!vt.isLocalTemp()) {
            return;
        }
        for (int i = 0; i < ops.size(); ++i) {
            OpTpl op = (OpTpl)ops.get(i);
            VarnodeTpl vn = op.getOut();
            if (vn != null && vn.isLocalTemp() && vn.getOffset().equals(vt.getOffset())) {
                if (size.getType() == ConstTpl.const_type.real && vn.getSize().getType() == ConstTpl.const_type.real && vn.getSize().getReal() != 0L && vn.getSize().getReal() != size.getReal()) {
                    throw new SleighError(String.format("Localtemp size mismatch: %d vs %d", vn.getSize().getReal(), size.getReal()), op.location);
                }
                vn.setSize(size);
            }
            for (int j = 0; j < op.numInput(); ++j) {
                vn = op.getIn(j);
                if (!vn.isLocalTemp() || !vn.getOffset().equals(vt.getOffset())) continue;
                if (size.getType() == ConstTpl.const_type.real && vn.getSize().getType() == ConstTpl.const_type.real && vn.getSize().getReal() != 0L && vn.getSize().getReal() != size.getReal()) {
                    throw new SleighError(String.format("Input size mismatch: %d vs %d", vn.getSize().getReal(), size.getReal()), op.location);
                }
                vn.setSize(size);
            }
        }
    }

    public VarnodeTpl buildTemporary(Location location) {
        PcodeCompile.entry("buildTemporary", location);
        VarnodeTpl res = new VarnodeTpl(location, new ConstTpl(this.getUniqueSpace()), new ConstTpl(ConstTpl.const_type.real, this.allocateTemp()), new ConstTpl(ConstTpl.const_type.real, 0L));
        res.setUnnamed(true);
        return res;
    }

    public LabelSymbol defineLabel(Location location, String name) {
        PcodeCompile.entry("defineLabel", location, name);
        LabelSymbol labsym = new LabelSymbol(location, name, this.local_labelcount++);
        this.addSymbol(labsym);
        return labsym;
    }

    public VectorSTL<OpTpl> placeLabel(Location location, LabelSymbol labsym) {
        PcodeCompile.entry("placeLabel", location, labsym);
        if (labsym.isPlaced()) {
            this.reportError(labsym.getLocation(), String.format("Label '%s' is placed more than once", labsym.getName()));
        }
        labsym.setPlaced();
        VectorSTL res = new VectorSTL();
        OpTpl op = new OpTpl(location, OpCode.CPUI_PTRADD);
        VarnodeTpl idvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, labsym.getIndex()), new ConstTpl(ConstTpl.const_type.real, 4L));
        op.addInput(idvn);
        res.push_back((Object)op);
        return res;
    }

    public ConstructTpl setResultVarnode(ConstructTpl ct, VarnodeTpl vn) {
        PcodeCompile.entry("setResultVarnode", ct, vn);
        HandleTpl res = new HandleTpl(vn);
        ct.setResult(res);
        return ct;
    }

    public ConstructTpl setResultStarVarnode(ConstructTpl ct, StarQuality star, VarnodeTpl vn) {
        PcodeCompile.entry("setResultStarVarnode", ct, star, vn);
        HandleTpl res = new HandleTpl(star.getId(), new ConstTpl(ConstTpl.const_type.real, star.getSize()), vn, this.getUniqueSpace(), this.allocateTemp());
        ct.setResult(res);
        return ct;
    }

    public void newLocalDefinition(Location location, String varname) {
        PcodeCompile.entry("newLocalDefinition", location, varname);
        this.newLocalDefinition(location, varname, 0);
    }

    public void newLocalDefinition(Location location, String varname, int size) {
        PcodeCompile.entry("newLocalDefinition", location, varname, size);
        VarnodeTpl tmpvn = this.buildTemporary(location);
        if (size != 0) {
            tmpvn.setSize(new ConstTpl(ConstTpl.const_type.real, size));
        }
        VarnodeSymbol sym = new VarnodeSymbol(location, varname, tmpvn.getSpace().getSpace(), tmpvn.getOffset().getReal(), (int)tmpvn.getSize().getReal());
        this.addSymbol(sym);
    }

    public VectorSTL<OpTpl> newOutput(Location location, boolean usesLocalKey, ExprTree rhs, String varname) {
        PcodeCompile.entry("newOutput", location, rhs, varname);
        return this.newOutput(location, usesLocalKey, rhs, varname, 0);
    }

    public VectorSTL<OpTpl> newOutput(Location location, boolean usesLocalKey, ExprTree rhs, String varname, int size) {
        PcodeCompile.entry("newOutput", location, rhs, varname, size);
        VarnodeTpl tmpvn = this.buildTemporary(location);
        if (size != 0) {
            tmpvn.setSize(new ConstTpl(ConstTpl.const_type.real, size));
        } else if (rhs.getSize().getType() == ConstTpl.const_type.real && rhs.getSize().getReal() != 0L) {
            tmpvn.setSize(rhs.getSize());
        }
        rhs.setOutput(location, tmpvn);
        VarnodeSymbol sym = new VarnodeSymbol(location, varname, tmpvn.getSpace().getSpace(), tmpvn.getOffset().getReal(), (int)tmpvn.getSize().getReal());
        this.addSymbol(sym);
        if (!usesLocalKey && this.enforceLocalKey) {
            this.reportError(location, "Must use 'local' keyword to define symbol '" + varname + "'");
        }
        return ExprTree.toVector(rhs);
    }

    public ExprTree createOp(Location location, OpCode opc, ExprTree vn) {
        PcodeCompile.entry("createOp", new Object[]{location, opc, vn});
        VarnodeTpl outvn = this.buildTemporary(location);
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn.outvn);
        op.setOutput(outvn);
        vn.ops.push_back((Object)op);
        vn.outvn = new VarnodeTpl(location, outvn);
        return vn;
    }

    public ExprTree createOp(Location location, OpCode opc, ExprTree vn1, ExprTree vn2) {
        PcodeCompile.entry("createOp", new Object[]{location, opc, vn1, vn2});
        VarnodeTpl outvn = this.buildTemporary(location);
        vn1.ops.appendAll(vn2.ops);
        vn2.ops.clear();
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn1.outvn);
        op.addInput(vn2.outvn);
        vn2.outvn = null;
        op.setOutput(outvn);
        vn1.ops.push_back((Object)op);
        vn1.outvn = new VarnodeTpl(location, outvn);
        return vn1;
    }

    public ExprTree createOpOut(Location location, VarnodeTpl outvn, OpCode opc, ExprTree vn1, ExprTree vn2) {
        PcodeCompile.entry("createOpOut", new Object[]{location, outvn, opc, vn1, vn2});
        vn1.ops.appendAll(vn2.ops);
        vn2.ops.clear();
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn1.outvn);
        op.addInput(vn2.outvn);
        vn2.outvn = null;
        op.setOutput(outvn);
        vn1.ops.push_back((Object)op);
        vn1.outvn = new VarnodeTpl(location, outvn);
        return vn1;
    }

    public ExprTree createOpOutUnary(Location location, VarnodeTpl outvn, OpCode opc, ExprTree vn) {
        PcodeCompile.entry("createOpOutUnary", new Object[]{location, outvn, opc, vn});
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn.outvn);
        op.setOutput(outvn);
        vn.ops.push_back((Object)op);
        vn.outvn = new VarnodeTpl(location, outvn);
        return vn;
    }

    public VectorSTL<OpTpl> createOpNoOut(Location location, OpCode opc, ExprTree vn) {
        PcodeCompile.entry("createOpNoOut", new Object[]{opc, vn});
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn.outvn);
        vn.outvn = null;
        VectorSTL<OpTpl> res = vn.ops;
        vn.ops = null;
        res.push_back((Object)op);
        return res;
    }

    public VectorSTL<OpTpl> createOpNoOut(Location location, OpCode opc, ExprTree vn1, ExprTree vn2) {
        PcodeCompile.entry("createOpNoOut", new Object[]{opc, vn1, vn2});
        VectorSTL<OpTpl> res = vn1.ops;
        vn1.ops = null;
        res.appendAll(vn2.ops);
        vn2.ops.clear();
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn1.outvn);
        vn1.outvn = null;
        op.addInput(vn2.outvn);
        vn2.outvn = null;
        res.push_back((Object)op);
        return res;
    }

    public VectorSTL<OpTpl> createOpConst(Location location, OpCode opc, long val) {
        PcodeCompile.entry("createOpConst", new Object[]{location, opc, val});
        VarnodeTpl vn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, val), new ConstTpl(ConstTpl.const_type.real, 4L));
        VectorSTL res = new VectorSTL();
        OpTpl op = new OpTpl(location, opc);
        op.addInput(vn);
        res.push_back((Object)op);
        return res;
    }

    public ExprTree createLoad(Location location, StarQuality qual, ExprTree ptr) {
        PcodeCompile.entry("createLoad", location, qual, ptr);
        VarnodeTpl outvn = this.buildTemporary(location);
        OpTpl op = new OpTpl(location, OpCode.CPUI_LOAD);
        VarnodeTpl spcvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), qual.getId(), new ConstTpl(ConstTpl.const_type.real, 8L));
        op.addInput(spcvn);
        op.addInput(ptr.outvn);
        op.setOutput(outvn);
        ptr.ops.push_back((Object)op);
        if (qual.getSize() > 0) {
            this.force_size(outvn, new ConstTpl(ConstTpl.const_type.real, qual.getSize()), ptr.ops);
        }
        ptr.outvn = new VarnodeTpl(location, outvn);
        return ptr;
    }

    public VectorSTL<OpTpl> createStore(Location location, StarQuality qual, ExprTree ptr, ExprTree val) {
        PcodeCompile.entry("createStore", location, qual, ptr, val);
        VectorSTL<OpTpl> res = ptr.ops;
        ptr.ops = null;
        res.appendAll(val.ops);
        val.ops.clear();
        OpTpl op = new OpTpl(location, OpCode.CPUI_STORE);
        VarnodeTpl spcvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), qual.getId(), new ConstTpl(ConstTpl.const_type.real, 8L));
        op.addInput(spcvn);
        op.addInput(ptr.outvn);
        op.addInput(val.outvn);
        res.push_back((Object)op);
        this.force_size(val.outvn, new ConstTpl(ConstTpl.const_type.real, qual.getSize()), res);
        ptr.outvn = null;
        val.outvn = null;
        return res;
    }

    public ExprTree createUserOp(UserOpSymbol sym, VectorSTL<ExprTree> param) {
        PcodeCompile.entry("createUserOp", sym, param);
        VarnodeTpl outvn = this.buildTemporary(sym.location);
        ExprTree res = new ExprTree(sym.getLocation());
        res.ops = this.createUserOpNoOut(sym.getLocation(), sym, param);
        ((OpTpl)res.ops.back()).setOutput(outvn);
        res.outvn = new VarnodeTpl(sym.location, outvn);
        return res;
    }

    public VectorSTL<OpTpl> createUserOpNoOut(Location location, UserOpSymbol sym, VectorSTL<ExprTree> param) {
        PcodeCompile.entry("createUserOpNoOut", sym, param);
        OpTpl op = new OpTpl(location, OpCode.CPUI_CALLOTHER);
        VarnodeTpl vn = new VarnodeTpl(sym.location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, sym.getIndex()), new ConstTpl(ConstTpl.const_type.real, 4L));
        op.addInput(vn);
        return ExprTree.appendParams(op, param);
    }

    public ExprTree createVariadic(Location location, OpCode opc, VectorSTL<ExprTree> param) {
        PcodeCompile.entry("createVariadic", new Object[]{location, opc, param});
        VarnodeTpl outvn = this.buildTemporary(location);
        ExprTree res = new ExprTree(location);
        OpTpl op = new OpTpl(location, opc);
        res.ops = ExprTree.appendParams(op, param);
        ((OpTpl)res.ops.back()).setOutput(outvn);
        res.outvn = new VarnodeTpl(location, outvn);
        return res;
    }

    public VarnodeTpl buildTruncatedVarnode(Location loc, VarnodeTpl basevn, int bitoffset, int numbits) {
        ConstTpl specialoff;
        int byteoffset = bitoffset / 8;
        int numbytes = numbits / 8;
        long fullsz = 0L;
        if (basevn.getSize().getType() == ConstTpl.const_type.real) {
            fullsz = basevn.getSize().getReal();
            if (fullsz == 0L) {
                return null;
            }
            if ((long)(byteoffset + numbytes) > fullsz) {
                throw new SleighError(String.format("Requested bit range out of bounds -- %d > %d", byteoffset + numbytes, fullsz), loc);
            }
        }
        if (bitoffset % 8 != 0) {
            return null;
        }
        if (numbits % 8 != 0) {
            return null;
        }
        if (basevn.getSpace().isUniqueSpace()) {
            return null;
        }
        ConstTpl.const_type offset_type = basevn.getOffset().getType();
        if (offset_type != ConstTpl.const_type.real && offset_type != ConstTpl.const_type.handle) {
            return null;
        }
        if (offset_type == ConstTpl.const_type.handle) {
            specialoff = new ConstTpl(ConstTpl.const_type.handle, basevn.getOffset().getHandleIndex(), ConstTpl.v_field.v_offset_plus, byteoffset);
        } else {
            if (basevn.getSize().getType() != ConstTpl.const_type.real) {
                throw new SleighError("Could not construct requested bit range", loc);
            }
            long plus = this.getDefaultSpace().isBigEndian() ? fullsz - (long)(byteoffset + numbytes) : (long)byteoffset;
            specialoff = new ConstTpl(ConstTpl.const_type.real, basevn.getOffset().getReal() + plus);
        }
        VarnodeTpl res = new VarnodeTpl(loc, basevn.getSpace(), specialoff, new ConstTpl(ConstTpl.const_type.real, numbytes));
        return res;
    }

    public void appendOp(Location location, OpCode opc, ExprTree res, long constval, int constsz) {
        PcodeCompile.entry("appendOp", new Object[]{location, opc, res, constval, constsz});
        OpTpl op = new OpTpl(location, opc);
        VarnodeTpl constvn = new VarnodeTpl(location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, constval), new ConstTpl(ConstTpl.const_type.real, constsz));
        VarnodeTpl outvn = this.buildTemporary(location);
        op.addInput(res.outvn);
        op.addInput(constvn);
        op.setOutput(outvn);
        res.ops.push_back((Object)op);
        res.outvn = new VarnodeTpl(location, outvn);
    }

    public VectorSTL<OpTpl> assignBitRange(Location location, VarnodeTpl vn, int bitoffset, int numbits, ExprTree rhs) {
        ExprTree res;
        PcodeCompile.entry("assignBitRange", location, vn, bitoffset, numbits, rhs);
        String errmsg = "";
        if (numbits == 0) {
            errmsg = "Size of bitrange is zero";
        }
        int smallsize = (numbits + 7) / 8;
        boolean shiftneeded = bitoffset != 0;
        boolean zextneeded = true;
        long mask = 2L;
        mask = (mask << numbits - 1) - 1L << bitoffset ^ 0xFFFFFFFFFFFFFFFFL;
        if (vn.getSize().getType() == ConstTpl.const_type.real) {
            int symsize = (int)vn.getSize().getReal();
            if (symsize > 0) {
                boolean bl = zextneeded = symsize > smallsize;
            }
            if (bitoffset >= (symsize *= 8) || bitoffset + numbits > symsize) {
                errmsg = "Assigned bitrange is bad";
            } else if (bitoffset == 0 && numbits == symsize) {
                errmsg = "Assigning to bitrange is superfluous";
            }
        }
        if (errmsg.length() > 0) {
            this.reportError(location, errmsg);
            VectorSTL<OpTpl> resops = rhs.ops;
            rhs.ops = null;
            return resops;
        }
        this.force_size(rhs.outvn, new ConstTpl(ConstTpl.const_type.real, smallsize), rhs.ops);
        VarnodeTpl finalout = this.buildTruncatedVarnode(location, vn, bitoffset, numbits);
        if (finalout != null) {
            res = this.createOpOutUnary(location, finalout, OpCode.CPUI_COPY, rhs);
        } else {
            if (bitoffset + numbits > 64) {
                errmsg = "Assigned bitrange extends past first 64 bits";
            }
            res = new ExprTree(location, vn);
            this.appendOp(location, OpCode.CPUI_INT_AND, res, mask, 0);
            if (zextneeded) {
                this.createOp(location, OpCode.CPUI_INT_ZEXT, rhs);
            }
            if (shiftneeded) {
                this.appendOp(location, OpCode.CPUI_INT_LEFT, rhs, bitoffset, 4);
            }
            finalout = new VarnodeTpl(location, vn);
            res = this.createOpOut(location, finalout, OpCode.CPUI_INT_OR, res, rhs);
        }
        if (errmsg.length() > 0) {
            this.reportError(location, errmsg);
        }
        VectorSTL<OpTpl> resops = res.ops;
        res.ops = null;
        return resops;
    }

    public ExprTree createBitRange(Location location, SpecificSymbol sym, int bitoffset, int numbits) {
        int insize;
        VarnodeTpl truncvn;
        PcodeCompile.entry("createBitRange", location, sym, bitoffset, numbits);
        Object errmsg = "";
        if (numbits == 0) {
            errmsg = "Size of bitrange is zero";
        }
        VarnodeTpl vn = sym.getVarnode();
        int finalsize = (numbits + 7) / 8;
        int truncshift = 0;
        boolean maskneeded = numbits % 8 != 0;
        boolean truncneeded = true;
        if (((String)errmsg).length() == 0 && bitoffset == 0 && !maskneeded && vn.getSpace().getType() == ConstTpl.const_type.handle && vn.isZeroSize()) {
            vn.setSize(new ConstTpl(ConstTpl.const_type.real, finalsize));
            ExprTree res = new ExprTree(sym.getLocation(), vn);
            return res;
        }
        if (((String)errmsg).length() == 0 && (truncvn = this.buildTruncatedVarnode(location, vn, bitoffset, numbits)) != null) {
            ExprTree res = new ExprTree(location, truncvn);
            return res;
        }
        if (vn.getSize().getType() == ConstTpl.const_type.real && (insize = (int)vn.getSize().getReal()) > 0) {
            boolean bl = truncneeded = finalsize < insize;
            if (bitoffset >= (insize *= 8) || bitoffset + numbits > insize) {
                errmsg = "Bitrange is bad";
            }
            if (maskneeded && bitoffset + numbits == insize) {
                maskneeded = false;
            }
        }
        long mask = 2L;
        mask = (mask << numbits - 1) - 1L;
        if (truncneeded && bitoffset % 8 == 0) {
            truncshift = bitoffset / 8;
            bitoffset = 0;
        }
        if (bitoffset == 0 && !truncneeded && !maskneeded) {
            errmsg = "Superfluous bitrange";
        }
        if (maskneeded && finalsize > 8) {
            errmsg = "Illegal masked bitrange producing varnode larger than 64 bits: " + sym.getName();
        }
        ExprTree res = new ExprTree(sym.getLocation(), vn);
        if (((String)errmsg).length() > 0) {
            this.reportError(location, (String)errmsg);
            return res;
        }
        if (bitoffset != 0) {
            this.appendOp(location, OpCode.CPUI_INT_RIGHT, res, bitoffset, 4);
        }
        if (truncneeded) {
            this.appendOp(location, OpCode.CPUI_SUBPIECE, res, truncshift, 4);
        }
        if (maskneeded) {
            this.appendOp(location, OpCode.CPUI_INT_AND, res, mask, finalsize);
        }
        this.force_size(res.outvn, new ConstTpl(ConstTpl.const_type.real, finalsize), res.ops);
        return res;
    }

    public VarnodeTpl addressOf(VarnodeTpl var, int size) {
        VarnodeTpl res;
        PcodeCompile.entry("addressOf", var, size);
        if (size == 0 && var.getSpace().getType() == ConstTpl.const_type.spaceid) {
            AddrSpace spc = var.getSpace().getSpace();
            size = spc.getAddrSize();
        }
        if (var.getOffset().getType() == ConstTpl.const_type.real && var.getSpace().getType() == ConstTpl.const_type.spaceid) {
            AddrSpace spc = var.getSpace().getSpace();
            res = new VarnodeTpl(var.location, new ConstTpl(this.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, var.getOffset().getReal() >> spc.getScale()), new ConstTpl(ConstTpl.const_type.real, size));
        } else {
            res = new VarnodeTpl(var.location, new ConstTpl(this.getConstantSpace()), var.getOffset(), new ConstTpl(ConstTpl.const_type.real, size));
        }
        return res;
    }

    public void matchSize(int j, OpTpl op, boolean inputonly, VectorSTL<OpTpl> ops) {
        VarnodeTpl vt;
        VarnodeTpl match = null;
        VarnodeTpl varnodeTpl = vt = j == -1 ? op.getOut() : op.getIn(j);
        if (!inputonly && op.getOut() != null && !op.getOut().isZeroSize()) {
            match = op.getOut();
        }
        int inputsize = op.numInput();
        for (int i = 0; i < inputsize && match == null; ++i) {
            if (op.getIn(i).isZeroSize()) continue;
            match = op.getIn(i);
        }
        if (match != null) {
            this.force_size(vt, match.getSize(), ops);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void fillinZero(OpTpl op, VectorSTL<OpTpl> ops) {
        switch (1.$SwitchMap$ghidra$pcodeCPort$opcodes$OpCode[op.getOpcode().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (op.getOut() != null && op.getOut().isZeroSize()) {
                    this.matchSize(-1, op, false, ops);
                }
                inputsize = op.numInput();
                for (i = 0; i < inputsize; ++i) {
                    if (!op.getIn(i).isZeroSize()) continue;
                    this.matchSize(i, op, false, ops);
                }
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                if (op.getOut().isZeroSize()) {
                    this.force_size(op.getOut(), new ConstTpl(ConstTpl.const_type.real, 1L), ops);
                }
                inputsize = op.numInput();
                for (i = 0; i < inputsize; ++i) {
                    if (!op.getIn(i).isZeroSize()) continue;
                    this.matchSize(i, op, true, ops);
                }
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                if (!op.getOut().isZeroSize()) ** GOTO lbl25
                if (!op.getIn(0).isZeroSize()) {
                    this.force_size(op.getOut(), op.getIn(0).getSize(), ops);
                }
                ** GOTO lbl27
lbl25:
                // 1 sources

                if (op.getIn(0).isZeroSize()) {
                    this.force_size(op.getIn(0), op.getOut().getSize(), ops);
                }
            }
lbl27:
            // 5 sources

            case 45: {
                if (!op.getIn(1).isZeroSize()) break;
                this.force_size(op.getIn(1), new ConstTpl(ConstTpl.const_type.real, 4L), ops);
                break;
            }
            case 46: {
                if (op.getOut().isZeroSize() && !op.getIn(0).isZeroSize()) {
                    this.force_size(op.getOut(), op.getIn(0).getSize(), ops);
                }
                if (op.getIn(0).isZeroSize() && !op.getOut().isZeroSize()) {
                    this.force_size(op.getIn(0), op.getOut().getSize(), ops);
                }
                for (i = 1; i < op.numInput(); ++i) {
                    this.force_size(op.getIn(i), new ConstTpl(ConstTpl.const_type.real, 8L), ops);
                }
                break;
            }
        }
    }

    public boolean propagateSize(ConstructTpl ct) {
        PcodeCompile.entry("propagateSize", ct);
        VectorSTL zerovec = new VectorSTL();
        VectorSTL zerovec2 = new VectorSTL();
        IteratorSTL iter = ct.getOpvec().begin();
        while (!iter.isEnd()) {
            if (((OpTpl)iter.get()).isZeroSize()) {
                this.fillinZero((OpTpl)iter.get(), ct.getOpvec());
                if (((OpTpl)iter.get()).isZeroSize()) {
                    zerovec.push_back((Object)((OpTpl)iter.get()));
                }
            }
            iter.increment();
        }
        int lastsize = zerovec.size() + 1;
        while (zerovec.size() < lastsize) {
            lastsize = zerovec.size();
            zerovec2 = new VectorSTL();
            iter = zerovec.begin();
            while (!iter.isEnd()) {
                this.fillinZero((OpTpl)iter.get(), ct.getOpvec());
                if (((OpTpl)iter.get()).isZeroSize()) {
                    zerovec2.push_back((Object)((OpTpl)iter.get()));
                }
                iter.increment();
            }
            zerovec = zerovec2;
        }
        return lastsize == 0;
    }

    public static void entry(String name, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("(");
        sb.append(Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", ")));
        sb.append(")");
        log.trace(sb.toString());
    }

    static boolean isLocationIsh(Object o) {
        if (o instanceof Location) {
            return true;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (Object t : l) {
                if (!PcodeCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        if (o instanceof VectorSTL) {
            VectorSTL v = (VectorSTL)o;
            for (Object t : v) {
                if (!PcodeCompile.isLocationIsh(t)) continue;
                return true;
            }
        }
        return false;
    }

    public Object findInternalFunction(Location location, String name, VectorSTL<ExprTree> operands) {
        ExprTree r = null;
        ExprTree s = null;
        if (operands.size() > 0) {
            r = (ExprTree)operands.get(0);
        }
        if (operands.size() > 1) {
            s = (ExprTree)operands.get(1);
        }
        if ("zext".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_INT_ZEXT, r);
        }
        if ("carry".equals(name) && this.hasOperands(2, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_INT_CARRY, r, s);
        }
        if ("sext".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_INT_SEXT, r);
        }
        if ("scarry".equals(name) && this.hasOperands(2, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_INT_SCARRY, r, s);
        }
        if ("sborrow".equals(name) && this.hasOperands(2, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_INT_SBORROW, r, s);
        }
        if ("abs".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_ABS, r);
        }
        if ("nan".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_NAN, r);
        }
        if ("sqrt".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_SQRT, r);
        }
        if ("ceil".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_CEIL, r);
        }
        if ("floor".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_FLOOR, r);
        }
        if ("round".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_ROUND, r);
        }
        if ("int2float".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_INT2FLOAT, r);
        }
        if ("float2float".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_FLOAT2FLOAT, r);
        }
        if ("trunc".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_FLOAT_TRUNC, r);
        }
        if ("delayslot".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOpConst(location, OpCode.CPUI_INDIRECT, r.outvn.getOffset().getReal());
        }
        if ("cpool".equals(name)) {
            if (operands.size() >= 2) {
                return this.createVariadic(location, OpCode.CPUI_CPOOLREF, operands);
            }
            this.reportError(location, name + "() expects at least two arguments");
        }
        if ("newobject".equals(name)) {
            if (operands.size() >= 1) {
                return this.createVariadic(location, OpCode.CPUI_NEW, operands);
            }
            this.reportError(location, name + "() expects at least one argument");
        }
        if ("popcount".equals(name) && this.hasOperands(1, operands, location, name)) {
            return this.createOp(location, OpCode.CPUI_POPCOUNT, r);
        }
        return null;
    }

    private boolean hasOperands(int targetNumOperands, VectorSTL<ExprTree> operands, Location location, String name) {
        if (operands.size() == targetNumOperands) {
            return true;
        }
        this.reportError(location, name + "() expects " + targetNumOperands + " argument" + (targetNumOperands == 1 ? "" : "s") + "; found " + operands.size());
        return false;
    }

    public boolean isInternalFunction(String name) {
        if ("zext".equals(name)) {
            return true;
        }
        if ("carry".equals(name)) {
            return true;
        }
        if ("sext".equals(name)) {
            return true;
        }
        if ("scarry".equals(name)) {
            return true;
        }
        if ("sborrow".equals(name)) {
            return true;
        }
        if ("abs".equals(name)) {
            return true;
        }
        if ("nan".equals(name)) {
            return true;
        }
        if ("sqrt".equals(name)) {
            return true;
        }
        if ("ceil".equals(name)) {
            return true;
        }
        if ("floor".equals(name)) {
            return true;
        }
        if ("round".equals(name)) {
            return true;
        }
        if ("int2float".equals(name)) {
            return true;
        }
        if ("float2float".equals(name)) {
            return true;
        }
        if ("trunc".equals(name)) {
            return true;
        }
        if ("delayslot".equals(name)) {
            return true;
        }
        if ("cpool".equals(name)) {
            return true;
        }
        if ("newobject".equals(name)) {
            return true;
        }
        return "popcount".equals(name);
    }
}

