/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.VectorSTL;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.pcode.utils.MessageFormattingUtils;
import ghidra.pcodeCPort.address.Address;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slgh_compile.ExprTree;
import ghidra.pcodeCPort.slgh_compile.PcodeCompile;
import ghidra.pcodeCPort.slgh_compile.SectionVector;
import ghidra.pcodeCPort.slghsymbol.EndSymbol;
import ghidra.pcodeCPort.slghsymbol.FlowDestSymbol;
import ghidra.pcodeCPort.slghsymbol.FlowRefSymbol;
import ghidra.pcodeCPort.slghsymbol.LabelSymbol;
import ghidra.pcodeCPort.slghsymbol.MacroSymbol;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SectionSymbol;
import ghidra.pcodeCPort.slghsymbol.SleighSymbol;
import ghidra.pcodeCPort.slghsymbol.SpaceSymbol;
import ghidra.pcodeCPort.slghsymbol.StartSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.pcodeCPort.xml.DocumentStorage;
import ghidra.sleigh.grammar.BailoutException;
import ghidra.sleigh.grammar.LineArrayListWriter;
import ghidra.sleigh.grammar.Location;
import ghidra.sleigh.grammar.ParsingEnvironment;
import ghidra.sleigh.grammar.SleighCompiler;
import ghidra.sleigh.grammar.SleighLexer;
import ghidra.sleigh.grammar.SleighParser;
import ghidra.sleigh.grammar.SleighParser_SemanticParser;
import ghidra.util.exception.AssertException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.UnbufferedTokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class PcodeParser
extends PcodeCompile {
    public static final Logger log = LogManager.getLogger(PcodeParser.class);
    private SleighBase sleigh;
    private long tempbase;
    private HashMap<String, SleighSymbol> symbolMap = new HashMap();
    private HashSet<String> currentSymbols = new HashSet();

    protected PcodeParser(SleighBase sleigh) {
        this.sleigh = sleigh;
        this.initializeSymbols();
    }

    public PcodeParser(String sleighSpec) throws JDOMException {
        DocumentStorage store = new DocumentStorage();
        Document doc = null;
        try {
            doc = store.parseDocument(new StringBufferInputStream(sleighSpec));
        }
        catch (IOException e) {
            throw new AssertException();
        }
        store.registerTag(doc.getRootElement());
        PcodeTranslate translate = new PcodeTranslate();
        translate.initialize(store);
        this.sleigh = translate;
        this.initializeSymbols();
    }

    private void initializeSymbols() {
        this.tempbase = this.sleigh.getUniqueBase();
        Location internalLoc = Location.INTERNALLY_DEFINED;
        this.symbolMap.put("inst_start", new StartSymbol(internalLoc, "inst_start", this.getConstantSpace()));
        this.symbolMap.put("inst_next", new EndSymbol(internalLoc, "inst_next", this.getConstantSpace()));
        this.symbolMap.put("inst_ref", new FlowRefSymbol(internalLoc, "inst_ref", this.getConstantSpace()));
        this.symbolMap.put("inst_dest", new FlowDestSymbol(internalLoc, "inst_dest", this.getConstantSpace()));
    }

    public void addOperand(Location loc, String name, int index) {
        OperandSymbol sym = new OperandSymbol(loc, name, index, null);
        this.addSymbol(sym);
    }

    @Override
    public void addSymbol(SleighSymbol sym) {
        SleighSymbol s = this.sleigh.findSymbol(sym.getName());
        if (s == null) {
            s = this.symbolMap.get(sym.getName());
        }
        if (s != null) {
            if (s != sym) {
                throw new SleighError("Duplicate symbol name: " + sym.getName() + " (previously defined at " + s.location + ")", sym.getLocation());
            }
        } else {
            this.symbolMap.put(sym.getName(), sym);
            this.currentSymbols.add(sym.getName());
        }
    }

    public void clearSymbols() {
        for (String symbol : this.currentSymbols) {
            this.symbolMap.remove(symbol);
        }
        this.currentSymbols.clear();
    }

    @Override
    public long allocateTemp() {
        long base = this.tempbase;
        this.tempbase = base + 128L;
        return base;
    }

    @Override
    public VectorSTL<OpTpl> createMacroUse(Location location, MacroSymbol sym, VectorSTL<ExprTree> param) {
        throw new SleighError("Pcode snippet parsing does not support use of macros", location);
    }

    @Override
    public SleighSymbol findSymbol(String nm) {
        SleighSymbol sym = this.symbolMap.get(nm);
        if (sym != null) {
            return sym;
        }
        return this.sleigh.findSymbol(nm);
    }

    @Override
    public AddrSpace getConstantSpace() {
        return this.sleigh.getConstantSpace();
    }

    @Override
    public AddrSpace getDefaultSpace() {
        return this.sleigh.getDefaultSpace();
    }

    @Override
    public AddrSpace getUniqueSpace() {
        return this.sleigh.getUniqueSpace();
    }

    @Override
    public void recordNop(Location location) {
    }

    private String checkLabels() {
        ArrayList<String> errors = new ArrayList<String>();
        for (SleighSymbol sym : this.symbolMap.values()) {
            if (sym.getType() != symbol_type.label_symbol) continue;
            LabelSymbol labsym = (LabelSymbol)sym;
            if (labsym.getRefCount() == 0) {
                errors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was placed but never used", sym.getName())));
                continue;
            }
            if (labsym.isPlaced()) continue;
            errors.add(MessageFormattingUtils.format(labsym.location, String.format("Label <%s> was referenced but never placed", sym.getName())));
        }
        return errors.stream().collect(Collectors.joining("  "));
    }

    private ConstructTpl buildConstructor(ConstructTpl rtl) {
        String errstring = "";
        if (rtl != null) {
            errstring = this.checkLabels();
            if (errstring.length() == 0 && !this.propagateSize(rtl)) {
                errstring = "   Could not resolve at least 1 variable size";
            }
            if (errstring.length() == 0 && rtl.delaySlot() != 0) {
                errstring = "   delayslot not permitted in pcode fragment";
            }
            if (rtl.getResult() != null) {
                errstring = "   export not permitted in pcode fragment";
            }
        }
        if (errstring.length() != 0) {
            throw new SleighException(errstring);
        }
        return rtl;
    }

    public static String stringifyTemplate(ConstructTpl ctl) {
        if (ctl == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ctl.saveXml(new PrintStream(out), -1);
        return out.toString();
    }

    public ConstructTpl compilePcode(String pcodeStatements, String srcFile, int srcLine) throws SleighException {
        ConstructTpl constructTpl;
        LineArrayListWriter writer = null;
        try {
            String line;
            writer = new LineArrayListWriter();
            ParsingEnvironment env = new ParsingEnvironment(writer);
            BufferedReader r = new BufferedReader(new StringReader(pcodeStatements));
            while ((line = r.readLine()) != null) {
                writer.write(line);
                writer.newLine();
            }
            ANTLRStringStream input = new ANTLRStringStream(writer.toString());
            env.getLocator().registerLocation(input.getLine(), new Location(srcFile, srcLine));
            SleighLexer lex = new SleighLexer((CharStream)input);
            lex.setEnv(env);
            UnbufferedTokenStream tokens = new UnbufferedTokenStream((TokenSource)lex);
            SleighParser parser = new SleighParser((TokenStream)tokens);
            parser.setEnv(env);
            parser.setLexer(lex);
            lex.pushMode(2);
            SleighParser_SemanticParser.semantic_return semantic = parser.semantic();
            lex.popMode();
            CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)semantic.getTree());
            nodes.setTokenStream((TokenStream)tokens);
            SleighCompiler walker = new SleighCompiler((TreeNodeStream)nodes);
            SectionVector rtl = walker.semantic(env, null, this, (Tree)semantic.getTree(), false, false);
            if (this.getErrors() != 0) {
                ConstructTpl constructTpl2 = null;
                return constructTpl2;
            }
            ConstructTpl result = null;
            if (rtl != null) {
                result = this.buildConstructor(rtl.getMainSection());
            }
            constructTpl = result;
        }
        catch (IOException e) {
            throw new AssertException();
        }
        catch (RecognitionException e) {
            throw new SleighException("Semantic compilation error: " + e.getMessage(), e);
        }
        catch (BailoutException e) {
            throw new SleighException("Unrecoverable error(s), halting compilation", e);
        }
        catch (NullPointerException e) {
            throw new SleighException("Unrecoverable error(s), halting compilation", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        return constructTpl;
    }

    @Override
    public SectionSymbol newSectionSymbol(Location where, String text) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", where);
    }

    @Override
    public VectorSTL<OpTpl> createCrossBuild(Location where, VarnodeTpl v, SectionSymbol second) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", where);
    }

    @Override
    public SectionVector standaloneSection(ConstructTpl main) {
        SectionVector res = new SectionVector(main, null);
        return res;
    }

    @Override
    public SectionVector firstNamedSection(ConstructTpl main, SectionSymbol sym) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", sym.location);
    }

    @Override
    public SectionVector nextNamedSection(SectionVector vec, ConstructTpl section, SectionSymbol sym) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", sym.location);
    }

    @Override
    public SectionVector finalNamedSection(SectionVector vec, ConstructTpl section) {
        throw new SleighError("Pcode snippet parsing does not support use of sections", null);
    }

    private static class PcodeTranslate
    extends SleighBase {
        private PcodeTranslate() {
        }

        @Override
        public void initialize(DocumentStorage store) {
            Element el = store.getTag("sleigh");
            if (el == null) {
                throw new LowlevelError("Could not find sleigh tag");
            }
            this.target_endian = XmlUtils.decodeBoolean(el.getAttributeValue("bigendian")) ? 1 : 0;
            this.alignment = XmlUtils.decodeUnknownInt(el.getAttributeValue("align"));
            long ubase = XmlUtils.decodeUnknownLong(el.getAttributeValue("uniqbase"));
            this.setUniqueBase(ubase);
            List list = el.getChildren();
            Iterator iter = list.iterator();
            Element child = (Element)iter.next();
            while (child.getName().equals("floatformat")) {
                child = (Element)iter.next();
            }
            this.restoreXmlSpaces(child);
            child = (Element)iter.next();
            while ("truncate_space".equals(child.getName())) {
                child = (Element)iter.next();
            }
            this.symtab.restoreXml(child, this);
            for (int i = 0; i < this.numSpaces(); ++i) {
                AddrSpace space = this.getSpace(i);
                this.symtab.addSymbol(new SpaceSymbol(null, space));
            }
        }

        @Override
        public int instructionLength(Address baseaddr) {
            return 0;
        }

        @Override
        public int printAssembly(PrintStream s, int size, Address baseaddr) {
            return 0;
        }
    }
}

