/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.space;

import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import java.io.PrintStream;

public class OtherSpace
extends AddrSpace {
    public OtherSpace(Translate t, String nm, int ind) {
        super(t, spacetype.IPTR_PROCESSOR, nm, 8, 1, ind, 0, 0);
        this.clearFlags(2);
        this.setFlags(512);
    }

    public OtherSpace(Translate t) {
        super(t, spacetype.IPTR_PROCESSOR);
        this.clearFlags(2);
        this.setFlags(512);
    }

    @Override
    public int printRaw(PrintStream s, long offset) {
        s.append("0x");
        s.append(Long.toHexString(offset));
        return this.getTrans().getDefaultSize();
    }

    @Override
    public void saveXml(PrintStream s) {
        s.print("<space_other");
        this.save_basic_attributes(s);
        s.println("/>");
    }
}

