/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.ConvertedRecordIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.bookmark.BookmarkDBAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;

class BookmarkDBAdapterV1
extends BookmarkDBAdapter {
    static final int VERSION = 1;
    static final int V1_ADDRESS_COL = 0;
    static final int V1_TYPE_ID_COL = 1;
    static final int V1_TYPE_CATEGORY_COL = 2;
    static final int V1_COMMENT_COL = 3;
    protected Table table;
    protected AddressMap addrMap;

    BookmarkDBAdapterV1() {
    }

    BookmarkDBAdapterV1(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.table = dbHandle.getTable("Bookmarks");
        if (this.table == null) {
            throw new VersionException("Missing Table: Bookmarks");
        }
        if (this.table.getSchema().getVersion() != 1) {
            throw new VersionException("Expected version 1 for table Bookmarks but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    AddressSetView getBookmarkAddresses(int typeId) throws IOException {
        AddressSet set = new AddressSet();
        RecordIterator recordIter = this.getRecordsByType(typeId);
        while (recordIter.hasNext()) {
            DBRecord rec = recordIter.next();
            Address addr = this.addrMap.decodeAddress(rec.getLongValue(0));
            set.addRange(addr, addr);
        }
        return set;
    }

    @Override
    String[] getCategories(int typeId) throws IOException {
        HashSet<String> set = new HashSet<String>();
        LongField fv = new LongField((long)typeId);
        RecordIterator recordIter = this.table.indexIterator(1, (Field)fv, (Field)fv, true);
        while (recordIter.hasNext()) {
            DBRecord rec = recordIter.next();
            String cat = BookmarkDBAdapterV1.demangleTypeCategory(rec.getString(2));
            set.add(cat);
        }
        Object[] categories = new String[set.size()];
        set.toArray(categories);
        Arrays.sort(categories);
        return categories;
    }

    @Override
    DBRecord getRecord(long id) throws IOException {
        return BookmarkDBAdapterV1.convertV1Record(this.table.getRecord(id));
    }

    private static DBRecord convertV1Record(DBRecord record) {
        long key = record.getLongValue(1) << 48 | record.getKey() & 0xFFFFFFFFL;
        DBRecord rec = BookmarkDBAdapter.SCHEMA.createRecord(key);
        rec.setLongValue(0, record.getLongValue(0));
        rec.setString(1, BookmarkDBAdapterV1.demangleTypeCategory(record.getString(2)));
        rec.setString(2, record.getString(3));
        return rec;
    }

    @Override
    RecordIterator getRecordsByType(int typeId) throws IOException {
        return new V1ConvertedRecordIterator(this.table.iterator());
    }

    @Override
    RecordIterator getRecordsByTypeAndCategory(int typeId, String category) throws IOException {
        RecordIterator recordIter;
        if (category == null) {
            LongField fv = new LongField((long)typeId);
            recordIter = this.table.indexIterator(1, (Field)fv, (Field)fv, true);
        } else {
            StringField fv = new StringField(BookmarkDBAdapterV1.mangleTypeCategory(typeId, category));
            recordIter = this.table.indexIterator(2, (Field)fv, (Field)fv, true);
        }
        return new V1ConvertedRecordIterator(recordIter);
    }

    @Override
    int getBookmarkCount(int typeId) {
        int cnt = 0;
        try {
            LongField f = new LongField((long)typeId);
            RecordIterator it = this.table.indexIterator(1, (Field)f, (Field)f, true);
            while (it.hasNext()) {
                it.next();
                ++cnt;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cnt;
    }

    @Override
    int getBookmarkCount() {
        return this.table.getRecordCount();
    }

    @Override
    RecordIterator getRecordsByTypeAtAddress(int typeId, long address) throws IOException {
        return this.getRecordsByTypeForAddressRange(typeId, address, address);
    }

    @Override
    RecordIterator getRecordsByTypeStartingAtAddress(int typeID, long startAddress, boolean forward) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getRecordsByTypeForAddressRange(int typeId, long startAddr, long endAddr) throws IOException {
        return new BatchRecordIterator(typeId, startAddr, endAddr);
    }

    private static class V1ConvertedRecordIterator
    extends ConvertedRecordIterator {
        V1ConvertedRecordIterator(RecordIterator originalIterator) {
            super(originalIterator, false);
        }

        protected DBRecord convertRecord(DBRecord record) {
            return BookmarkDBAdapterV1.convertV1Record(record);
        }
    }

    private class BatchRecordIterator
    implements RecordIterator {
        private ListIterator<DBRecord> iter;

        BatchRecordIterator(int typeId, long start, long end) throws IOException {
            ArrayList<DBRecord> list = new ArrayList<DBRecord>();
            LongField sf = new LongField(start);
            LongField ef = new LongField(end);
            RecordIterator recIter = BookmarkDBAdapterV1.this.table.indexIterator(0, (Field)sf, (Field)ef, true);
            while (recIter.hasNext()) {
                list.add(BookmarkDBAdapterV1.convertV1Record(recIter.next()));
            }
            this.iter = list.listIterator();
        }

        public boolean hasNext() throws IOException {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() throws IOException {
            return this.iter.hasPrevious();
        }

        public DBRecord next() throws IOException {
            return this.iter.next();
        }

        public DBRecord previous() throws IOException {
            return this.iter.previous();
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

