/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.VariableStorageDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class VariableStorageManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private Lock lock;
    private VariableStorageDBAdapter adapter;
    private DBObjectCache<MyVariableStorage> cache = new DBObjectCache(256);
    private WeakValueHashMap<Long, MyVariableStorage> cacheMap = new WeakValueHashMap(256);

    public VariableStorageManagerDB(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.adapter = VariableStorageDBAdapter.getAdapter(handle, openMode, addrMap, monitor);
    }

    void invalidateCache(boolean all) {
        this.cache.invalidate();
        this.cacheMap.clear();
    }

    void setProgram(ProgramDB program) {
        this.program = program;
    }

    private MyVariableStorage getMyVariableStorage(Address variableAddr) throws IOException {
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException("Address is not a VariableAddress: " + variableAddr);
        }
        MyVariableStorage varStore = this.cache.get(variableAddr.getOffset());
        if (varStore != null) {
            return varStore;
        }
        DBRecord rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        varStore = new MyVariableStorage(this.cache, rec);
        this.cacheMap.put((Object)varStore.getLongHash(), (Object)varStore);
        return varStore;
    }

    List<Varnode> getStorageVarnodes(Address variableAddr) throws IOException {
        if (!variableAddr.isVariableAddress()) {
            throw new IllegalArgumentException();
        }
        DBRecord rec = this.adapter.getRecord(variableAddr.getOffset());
        if (rec == null) {
            return null;
        }
        try {
            return VariableStorage.getVarnodes(this.program.getAddressFactory(), rec.getString(1));
        }
        catch (InvalidInputException e) {
            Msg.error((Object)this, (Object)("Invalid variable storage: " + e.getMessage()));
            return null;
        }
    }

    VariableStorage getVariableStorage(Address variableAddr) throws IOException {
        MyVariableStorage myStorage = this.getMyVariableStorage(variableAddr);
        if (myStorage != null) {
            return myStorage.getVariableStorage();
        }
        return null;
    }

    public Address getVariableStorageAddress(VariableStorage storage, boolean create) throws IOException {
        long key;
        long hash = storage.getLongHash();
        MyVariableStorage myStorage = (MyVariableStorage)this.cacheMap.get((Object)hash);
        if (myStorage != null) {
            key = myStorage.getKey();
            if (this.cache.get(key) == null) {
                key = -1L;
            }
        } else {
            key = this.adapter.findRecordKey(hash);
        }
        if (key == -1L) {
            if (!create) {
                return null;
            }
            key = this.adapter.getNextStorageID();
            DBRecord rec = VariableStorageDBAdapter.VARIABLE_STORAGE_SCHEMA.createRecord(key);
            rec.setLongValue(0, storage.getLongHash());
            rec.setString(1, storage.getSerializationString());
            this.adapter.updateRecord(rec);
            myStorage = new MyVariableStorage(this.cache, rec);
            this.cacheMap.put((Object)hash, (Object)myStorage);
        }
        return AddressSpace.VARIABLE_SPACE.getAddress(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.adapter.getRecordCount());
        int cnt = 0;
        this.lock.acquire();
        try {
            RecordIterator recIter = this.adapter.getRecords();
            while (recIter.hasNext()) {
                monitor.checkCanceled();
                DBRecord rec = recIter.next();
                String serialization = rec.getString(1);
                try {
                    serialization = VariableStorage.translateSerialization(translator, serialization);
                    rec.setString(1, serialization);
                    this.adapter.updateRecord(rec);
                }
                catch (InvalidInputException e) {
                    continue;
                }
                monitor.setProgress((long)(++cnt));
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.invalidateCache(true);
            this.lock.release();
        }
    }

    private class MyVariableStorage
    extends DatabaseObject {
        private VariableStorage storage;
        private DBRecord record;

        private MyVariableStorage(DBObjectCache<MyVariableStorage> cache, DBRecord record) {
            super(cache, record.getKey());
            this.record = record;
            try {
                this.storage = VariableStorage.deserialize(VariableStorageManagerDB.this.program, record.getString(1));
            }
            catch (InvalidInputException e) {
                this.storage = VariableStorage.BAD_STORAGE;
            }
        }

        VariableStorage getVariableStorage() {
            VariableStorageManagerDB.this.lock.acquire();
            try {
                this.checkIsValid();
                VariableStorage variableStorage = this.storage;
                return variableStorage;
            }
            finally {
                VariableStorageManagerDB.this.lock.release();
            }
        }

        long getLongHash() {
            return this.storage.getLongHash();
        }

        @Override
        protected boolean refresh() {
            block9: {
                VariableStorageManagerDB.this.lock.acquire();
                try {
                    this.storage = VariableStorage.BAD_STORAGE;
                    if (this.record == null) break block9;
                    DBRecord rec = VariableStorageManagerDB.this.adapter.getRecord(this.key);
                    if (rec == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.record = rec;
                    try {
                        this.storage = VariableStorage.deserialize(VariableStorageManagerDB.this.program, this.record.getString(1));
                    }
                    catch (InvalidInputException invalidInputException) {
                        // empty catch block
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException e) {
                    VariableStorageManagerDB.this.program.dbError(e);
                }
                finally {
                    VariableStorageManagerDB.this.lock.release();
                }
            }
            return false;
        }
    }
}

