/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressObjectMap;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockImpl;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.ExtCodeBlockImpl;
import ghidra.program.model.block.MultEntSubIterator;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.block.SubroutineDestReferenceIterator;
import ghidra.program.model.block.SubroutineSourceReferenceIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class MultEntSubModel
implements SubroutineBlockModel {
    public static final String NAME = "Multiple Entry";
    protected Program program;
    protected Listing listing;
    private AddressObjectMap foundMSubs;
    private CodeBlockModel bbModel;
    protected final boolean includeExternals;

    public MultEntSubModel(Program program) {
        this(program, false);
    }

    public MultEntSubModel(Program program, boolean includeExternals) {
        this.program = program;
        this.includeExternals = includeExternals;
        this.listing = program.getListing();
        this.foundMSubs = new AddressObjectMap();
    }

    @Override
    public CodeBlock getCodeBlockAt(Address addr, TaskMonitor monitor) throws CancelledException {
        if (addr == null) {
            return null;
        }
        CodeBlock block = this.getSubFromCache(addr);
        if (block == null) {
            block = this.getAddressSetContaining(addr, monitor);
        }
        if (block != null) {
            Address[] entPts;
            for (Address entPt : entPts = block.getStartAddresses()) {
                if (!entPt.equals(addr)) continue;
                return block;
            }
        }
        return null;
    }

    protected CodeBlock getAddressSetContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        if (addr.isExternalAddress()) {
            if (this.includeExternals) {
                ExtCodeBlockImpl block = new ExtCodeBlockImpl(this, addr);
                this.foundMSubs.addObject(block, addr, addr);
                return block;
            }
            return null;
        }
        AddressSet addrSet = new AddressSet();
        this.bbModel = new SimpleBlockModel(this.program, this.includeExternals);
        ArrayList<Address> entryPtList = new ArrayList<Address>();
        LinkedList<Address> todoList = new LinkedList<Address>();
        LinkedList<CodeBlock> srcList = new LinkedList<CodeBlock>();
        todoList.addFirst(addr);
        while (!todoList.isEmpty() || !srcList.isEmpty()) {
            CodeBlock bblock;
            if (monitor != null && monitor.isCancelled()) {
                throw new CancelledException();
            }
            if (todoList.isEmpty()) {
                while (todoList.isEmpty() && !srcList.isEmpty()) {
                    CodeBlock bblock2 = (CodeBlock)srcList.removeFirst();
                    this.addSources(monitor, entryPtList, todoList, bblock2);
                }
                continue;
            }
            Address a = null;
            a = (Address)todoList.removeFirst();
            if (addrSet.contains(a) || (bblock = this.bbModel.getFirstCodeBlockContaining(a, monitor)) == null || this.listing.getInstructionAt(bblock.getMinAddress()) == null) continue;
            addrSet.add(bblock);
            this.addDestinations(monitor, todoList, bblock);
            srcList.addLast(bblock);
        }
        if (addrSet.isEmpty()) {
            return null;
        }
        if (entryPtList.size() == 0) {
            Msg.warn((Object)this, (Object)("Failed to find entry point for subroutine containing " + addr));
            entryPtList.add(addrSet.getMinAddress());
        }
        Address[] entryPts = new Address[entryPtList.size()];
        entryPtList.toArray(entryPts);
        CodeBlockImpl block = new CodeBlockImpl(this, entryPts, addrSet);
        this.foundMSubs.addObject(block, addrSet);
        return block;
    }

    private void addDestinations(TaskMonitor monitor, LinkedList<Address> todoList, CodeBlock bblock) throws CancelledException {
        CodeBlockReferenceIterator destIter = bblock.getDestinations(monitor);
        while (destIter.hasNext()) {
            CodeBlockReference destRef = destIter.next();
            Address destAddr = destRef.getDestinationAddress();
            if (!destAddr.isMemoryAddress()) continue;
            FlowType refFlowType = destRef.getFlowType();
            if (refFlowType.isJump()) {
                todoList.addLast(destAddr);
                continue;
            }
            if (!refFlowType.isFallthrough()) continue;
            todoList.addFirst(destAddr);
        }
    }

    private void addSources(TaskMonitor monitor, List<Address> entryPtList, LinkedList<Address> todoList, CodeBlock bblock) throws CancelledException {
        CodeBlockReferenceIterator srcIter = bblock.getSources(monitor);
        boolean isSource = true;
        boolean isEntry = false;
        while (srcIter.hasNext()) {
            isSource = false;
            CodeBlockReference srcRef = srcIter.next();
            FlowType refFlowType = srcRef.getFlowType();
            if (refFlowType.isJump() || refFlowType.isFallthrough()) {
                todoList.addLast(srcRef.getSourceAddress());
                continue;
            }
            if (!refFlowType.isCall()) continue;
            isEntry = true;
        }
        if (isSource || isEntry) {
            entryPtList.add(bblock.getMinAddress());
        }
    }

    @Override
    public CodeBlock getFirstCodeBlockContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock block = this.getSubFromCache(addr);
        if (block == null) {
            block = this.getAddressSetContaining(addr, monitor);
        }
        return block;
    }

    @Override
    public CodeBlock[] getCodeBlocksContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock sub = this.getFirstCodeBlockContaining(addr, monitor);
        if (sub == null) {
            return emptyBlockArray;
        }
        CodeBlock[] blocks = new CodeBlock[]{sub};
        return blocks;
    }

    @Override
    public CodeBlockIterator getCodeBlocks(TaskMonitor monitor) throws CancelledException {
        return new MultEntSubIterator(this, monitor);
    }

    @Override
    public CodeBlockIterator getCodeBlocksContaining(AddressSetView addrSet, TaskMonitor monitor) throws CancelledException {
        return new MultEntSubIterator(this, addrSet, monitor);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public Listing getListing() {
        return this.listing;
    }

    @Override
    public String getName(CodeBlock block) {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        Address start = block.getFirstStartAddress();
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(start);
        if (symbol != null) {
            return symbol.getName();
        }
        return "SOURCE_SUB" + start.toString();
    }

    @Override
    public FlowType getFlowType(CodeBlock block) {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return RefType.FLOW;
    }

    @Override
    public CodeBlockReferenceIterator getSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineSourceReferenceIterator(block, monitor);
    }

    @Override
    public int getNumSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineSourceReferenceIterator.getNumSources(block, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineDestReferenceIterator(block, monitor);
    }

    @Override
    public int getNumDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineDestReferenceIterator.getNumDestinations(block, monitor);
    }

    public AddressSetView getAddressSet(CodeBlock block) {
        if (!(block.getModel() instanceof MultEntSubModel)) {
            throw new IllegalArgumentException();
        }
        return new AddressSet(block);
    }

    private CodeBlock getSubFromCache(Address addr) {
        Object[] mapObjs = this.foundMSubs.getObjects(addr);
        return mapObjs.length == 0 ? null : (CodeBlock)mapObjs[0];
    }

    @Override
    public CodeBlockModel getBasicBlockModel() {
        if (this.bbModel == null) {
            this.bbModel = new SimpleBlockModel(this.program);
        }
        return this.bbModel;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SubroutineBlockModel getBaseSubroutineModel() {
        return this;
    }

    @Override
    public boolean allowsBlockOverlap() {
        return false;
    }

    @Override
    public boolean externalsIncluded() {
        return this.includeExternals;
    }
}

