/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitGroup;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EnumValuePartitioner {
    private static void merge(List<BitGroup> list, BitGroup bitGroup) {
        Iterator<BitGroup> iterator = list.iterator();
        while (iterator.hasNext()) {
            BitGroup next = iterator.next();
            if (!bitGroup.intersects(next)) continue;
            bitGroup.merge(next);
            iterator.remove();
        }
        list.add(bitGroup);
    }

    public static List<BitGroup> partition(long[] values, int size) {
        LinkedList<BitGroup> list = new LinkedList<BitGroup>();
        long totalMask = 0L;
        for (long value : values) {
            totalMask |= value;
            BitGroup bitGroup = new BitGroup(value);
            EnumValuePartitioner.merge(list, bitGroup);
        }
        long enumMask = ~(-1 << size * 8);
        list.add(new BitGroup((totalMask ^ 0xFFFFFFFFFFFFFFFFL) & enumMask));
        return list;
    }
}

