/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.UniversalID;
import java.util.ArrayList;

public class FunctionDefinitionDataType
extends GenericDataType
implements FunctionDefinition {
    private DataType returnType = DataType.DEFAULT;
    private ParameterDefinition[] params;
    private String comment;
    private boolean hasVarArgs;
    private GenericCallingConvention genericCallingConvention = GenericCallingConvention.unknown;

    public FunctionDefinitionDataType(String name) {
        this(CategoryPath.ROOT, name, null, null);
    }

    public FunctionDefinitionDataType(String name, DataTypeManager dtm) {
        this(CategoryPath.ROOT, name, null, dtm);
    }

    public FunctionDefinitionDataType(CategoryPath path, String name) {
        this(path, name, null, null);
    }

    public FunctionDefinitionDataType(CategoryPath path, String name, DataTypeManager dtm) {
        this(path, name, null, dtm);
    }

    public FunctionDefinitionDataType(FunctionSignature sig) {
        this(CategoryPath.ROOT, sig.getName(), sig, null);
    }

    public FunctionDefinitionDataType(FunctionSignature sig, DataTypeManager dtm) {
        this(CategoryPath.ROOT, sig.getName(), sig, dtm);
    }

    public FunctionDefinitionDataType(CategoryPath path, String name, FunctionSignature sig) {
        this(path, name, sig, null);
    }

    public FunctionDefinitionDataType(CategoryPath path, String name, FunctionSignature sig, DataTypeManager dtm) {
        super(path, name, dtm);
        this.init(sig);
    }

    public FunctionDefinitionDataType(CategoryPath path, String name, FunctionSignature sig, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.init(sig);
    }

    public FunctionDefinitionDataType(Function function, boolean formalSignature) {
        super(CategoryPath.ROOT, function.getName(), function.getProgram().getDataTypeManager());
        this.comment = function.getComment();
        this.returnType = function.getReturn().getFormalDataType();
        Parameter[] parameters = function.getParameters();
        ArrayList<ParameterDefinition> paramList = new ArrayList<ParameterDefinition>();
        for (Parameter parameter : parameters) {
            if (formalSignature && parameter.isAutoParameter()) continue;
            paramList.add(this.getParameterDefinition(parameter, formalSignature));
        }
        this.params = paramList.toArray(new ParameterDefinition[paramList.size()]);
        this.hasVarArgs = function.hasVarArgs();
        PrototypeModel prototypeModel = function.getCallingConvention();
        this.genericCallingConvention = prototypeModel == null ? GenericCallingConvention.unknown : prototypeModel.getGenericCallingConvention();
    }

    private ParameterDefinition getParameterDefinition(Parameter param, boolean useFormalType) {
        return new ParameterDefinitionImpl(param.getName(), useFormalType ? param.getFormalDataType() : param.getDataType(), param.getComment(), param.getOrdinal());
    }

    private void init(FunctionSignature sig) {
        this.returnType = DataType.DEFAULT;
        this.params = new ParameterDefinition[0];
        if (sig != null) {
            this.copySignature(sig);
        }
    }

    private void copySignature(FunctionSignature sig) {
        this.comment = sig.getComment();
        DataType rtnType = sig.getReturnType();
        this.setReturnType(rtnType.clone(this.getDataTypeManager()));
        this.setArguments(sig.getArguments());
        this.hasVarArgs = sig.hasVarArgs();
        this.genericCallingConvention = sig.getGenericCallingConvention();
    }

    @Override
    public void setArguments(ParameterDefinition[] args) {
        this.params = new ParameterDefinition[args.length];
        for (int i = 0; i < args.length; ++i) {
            DataType dt = args[i].getDataType();
            this.params[i] = new ParameterDefinitionImpl(args[i].getName(), dt.clone(this.getDataTypeManager()), args[i].getComment(), i);
        }
    }

    @Override
    public void setReturnType(DataType type) {
        this.returnType = ParameterDefinitionImpl.validateDataType(type, this.dataMgr, true);
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public void setVarArgs(boolean hasVarArgs) {
        this.hasVarArgs = hasVarArgs;
    }

    @Override
    public void setGenericCallingConvention(GenericCallingConvention genericCallingConvention) {
        this.genericCallingConvention = genericCallingConvention;
    }

    @Override
    public GenericCallingConvention getGenericCallingConvention() {
        return this.genericCallingConvention != null ? this.genericCallingConvention : GenericCallingConvention.unknown;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return new FunctionDefinitionDataType(this.getCategoryPath(), this.getName(), this, dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        return new FunctionDefinitionDataType(this.getCategoryPath(), this.getName(), this, this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.getPrototypeString();
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getDescription() {
        return "Function:     " + this.getMnemonic(null);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.getPrototypeString();
    }

    @Override
    public String getPrototypeString() {
        return this.getPrototypeString(false);
    }

    @Override
    public String getPrototypeString(boolean includeCallingConvention) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnType != null ? this.returnType.getDisplayName() : "void");
        buf.append(" ");
        if (includeCallingConvention && this.genericCallingConvention != GenericCallingConvention.unknown) {
            buf.append(this.genericCallingConvention.name());
            buf.append(" ");
        }
        buf.append(this.name);
        buf.append("(");
        int n = this.params.length;
        for (int i = 0; i < n; ++i) {
            ParameterDefinition param = this.params[i];
            buf.append(param.getDataType().getDisplayName());
            buf.append(" ");
            buf.append(param.getName());
            if (i >= n - 1 && !this.hasVarArgs) continue;
            buf.append(", ");
        }
        if (this.hasVarArgs) {
            buf.append("...");
        } else if (this.params.length == 0) {
            buf.append("void");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public ParameterDefinition[] getArguments() {
        ParameterDefinition[] args = new ParameterDefinition[this.params.length];
        System.arraycopy(this.params, 0, args, 0, args.length);
        return args;
    }

    @Override
    public DataType getReturnType() {
        return this.returnType;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean hasVarArgs() {
        return this.hasVarArgs;
    }

    private boolean compareComment(FunctionSignature sig) {
        if (sig.getComment() == null && this.comment == null) {
            return true;
        }
        if (this.comment == null) {
            return false;
        }
        return this.comment.equals(sig.getComment());
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (!(dt instanceof FunctionDefinition)) {
            return false;
        }
        return this.isEquivalentSignature((FunctionDefinition)dt);
    }

    @Override
    public boolean isEquivalentSignature(FunctionSignature signature) {
        ParameterDefinition[] args;
        if (signature == this) {
            return true;
        }
        if (signature.getName().equals(this.name) && this.compareComment(signature) && DataTypeUtilities.isSameOrEquivalentDataType(signature.getReturnType(), this.returnType) && this.hasVarArgs == signature.hasVarArgs() && this.genericCallingConvention == signature.getGenericCallingConvention() && (args = signature.getArguments()).length == this.params.length) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].isEquivalent(this.params[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        DataType retType;
        if (newDt == this) {
            newDt = DataType.DEFAULT;
        }
        if (oldDt == (retType = this.getReturnType())) {
            try {
                this.setReturnType(newDt);
            }
            catch (IllegalArgumentException e) {
                this.dataTypeDeleted(oldDt);
                return;
            }
        }
        for (ParameterDefinition param : this.params) {
            if (param.getDataType() != oldDt) continue;
            try {
                param.setDataType(newDt);
            }
            catch (IllegalArgumentException e) {
                this.dataTypeDeleted(oldDt);
                return;
            }
        }
    }

    @Override
    public void replaceArgument(int ordinal, String newName, DataType dt, String newComment, SourceType source) {
        if (ordinal >= this.params.length) {
            ParameterDefinition[] newParams = new ParameterDefinition[ordinal + 1];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            for (int i = this.params.length; i < ordinal + 1; ++i) {
                newParams[i] = new ParameterDefinitionImpl("param_" + (i + 1), DataType.DEFAULT, newComment, i);
            }
            this.params = newParams;
        }
        this.params[ordinal] = new ParameterDefinitionImpl(newName, dt, newComment, ordinal);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.returnType == dt) {
            this.returnType = DataType.DEFAULT;
        }
        for (ParameterDefinition param : this.params) {
            if (param.getDataType() != dt) continue;
            param.setDataType(DataType.DEFAULT);
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        return false;
    }

    @Override
    public String toString() {
        return this.getPrototypeString(true);
    }
}

