/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOverride;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public class InstructionPcodeOverride
implements PcodeOverride {
    protected Instruction instr;
    private boolean callOverrideApplied = false;
    private boolean jumpOverrideApplied = false;
    private boolean callOtherCallOverrideApplied = false;
    private boolean callOtherJumpOverrideApplied = false;
    private Address primaryCallAddress = null;
    private List<Reference> primaryOverridingReferences;

    public InstructionPcodeOverride(Instruction instr) {
        this.instr = instr;
        this.primaryOverridingReferences = new ArrayList<Reference>();
        for (Reference ref : instr.getReferencesFrom()) {
            if (!ref.isPrimary() || !ref.getToAddress().isMemoryAddress()) continue;
            RefType type = ref.getReferenceType();
            if (type.isOverride()) {
                this.primaryOverridingReferences.add(ref);
                continue;
            }
            if (!type.isCall() || this.primaryCallAddress != null) continue;
            this.primaryCallAddress = ref.getToAddress();
        }
    }

    @Override
    public Address getFallThroughOverride() {
        Address defaultFallAddr = this.instr.getDefaultFallThrough();
        Address fallAddr = this.instr.getFallThrough();
        if (fallAddr != null && !fallAddr.equals(defaultFallAddr)) {
            return fallAddr;
        }
        return null;
    }

    @Override
    public FlowOverride getFlowOverride() {
        return this.instr.getFlowOverride();
    }

    @Override
    public Address getInstructionStart() {
        return this.instr.getMinAddress();
    }

    @Override
    public Address getOverridingReference(RefType type) {
        if (!type.isOverride()) {
            return null;
        }
        Address overrideAddress = null;
        for (Reference ref : this.primaryOverridingReferences) {
            if (!ref.getReferenceType().equals(type)) continue;
            if (overrideAddress == null) {
                overrideAddress = ref.getToAddress();
                continue;
            }
            return null;
        }
        return overrideAddress;
    }

    @Override
    public Address getPrimaryCallReference() {
        return this.primaryCallAddress;
    }

    @Override
    public boolean hasCallFixup(Address callDestAddr) {
        Program program = this.instr.getProgram();
        Function func = program.getFunctionManager().getFunctionAt(callDestAddr);
        if (func == null) {
            return false;
        }
        return func.getCallFixup() != null;
    }

    @Override
    public InjectPayload getCallFixup(Address callDestAddr) {
        Program program = this.instr.getProgram();
        Function func = program.getFunctionManager().getFunctionAt(callDestAddr);
        if (func == null) {
            return null;
        }
        String fixupName = func.getCallFixup();
        if (fixupName == null) {
            return null;
        }
        InjectPayload fixup = program.getCompilerSpec().getPcodeInjectLibrary().getPayload(1, fixupName);
        if (fixup == null) {
            Msg.warn((Object)this, (Object)("Undefined call-fixup at " + callDestAddr + ": " + fixupName));
        }
        return fixup;
    }

    @Override
    public void setCallOverrideRefApplied() {
        this.callOverrideApplied = true;
    }

    @Override
    public boolean isCallOverrideRefApplied() {
        return this.callOverrideApplied;
    }

    @Override
    public void setJumpOverrideRefApplied() {
        this.jumpOverrideApplied = true;
    }

    @Override
    public boolean isJumpOverrideRefApplied() {
        return this.jumpOverrideApplied;
    }

    @Override
    public void setCallOtherCallOverrideRefApplied() {
        this.callOtherCallOverrideApplied = true;
    }

    @Override
    public boolean isCallOtherCallOverrideRefApplied() {
        return this.callOtherCallOverrideApplied;
    }

    @Override
    public void setCallOtherJumpOverrideRefApplied() {
        this.callOtherJumpOverrideApplied = true;
    }

    @Override
    public boolean isCallOtherJumpOverrideApplied() {
        return this.callOtherJumpOverrideApplied;
    }

    @Override
    public boolean hasPotentialOverride() {
        return !this.primaryOverridingReferences.isEmpty();
    }
}

