/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HighOther
extends HighVariable {
    private Address pcaddr;
    private HighSymbol symbol;

    public HighOther(HighFunction high) {
        super(high);
    }

    public HighOther(DataType type, Varnode vn, Varnode[] inst, Address pc, HighFunction func) {
        super(null, type, vn, inst, func);
        this.pcaddr = pc;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"high"});
        long symref = SpecXmlUtils.decodeLong((String)el.getAttribute("symref"));
        this.offset = -1;
        String attrString = el.getAttribute("offset");
        this.restoreInstances(parser, el);
        this.name = "UNNAMED";
        this.pcaddr = this.function.getPCAddress(this.represent);
        if (symref != 0L) {
            this.offset = -1;
            if (attrString != null) {
                this.offset = SpecXmlUtils.decodeInt((String)attrString);
            }
            this.symbol = this.function.getLocalSymbolMap().getSymbol(symref);
            if (this.symbol != null && this.offset < 0) {
                this.name = this.symbol.getName();
            }
        }
        parser.end(el);
    }
}

