/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.scalar;

import java.math.BigInteger;

public class Scalar
implements Comparable<Scalar> {
    private static final long[] BITMASKS = new long[65];
    private byte bitLength;
    private long value;
    private boolean signed;

    public Scalar(int bitLength, long value, boolean signed) {
        this.signed = signed;
        if (!(bitLength == 0 && value == 0L || bitLength >= 1 && bitLength <= 64)) {
            throw new IllegalArgumentException("Bit length must be >= 1 and <= 64");
        }
        this.bitLength = (byte)bitLength;
        this.value = value & BITMASKS[bitLength];
    }

    public boolean isSigned() {
        return this.signed;
    }

    public Scalar(int bitLength, long value) {
        this(bitLength, value, true);
    }

    public long getSignedValue() {
        if (this.value == 0L) {
            return 0L;
        }
        if (this.testBit(this.bitLength - 1)) {
            return this.value | BITMASKS[this.bitLength] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this.value;
    }

    public long getUnsignedValue() {
        if (this.value == 0L) {
            return 0L;
        }
        return this.value & BITMASKS[this.bitLength];
    }

    public long getValue() {
        return this.signed ? this.getSignedValue() : this.value;
    }

    public BigInteger getBigInteger() {
        int signum = this.signed && this.testBit(this.bitLength - 1) ? -1 : 1;
        int numBytes = (this.bitLength - 1) / 8 + 1;
        long tmpVal = this.getValue();
        if (this.signed && tmpVal < 0L) {
            tmpVal = -tmpVal;
        }
        byte[] data = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            data[i] = (byte)tmpVal;
            tmpVal >>= 8;
        }
        return new BigInteger(signum, data);
    }

    public Scalar newScalar(long newValue) {
        return new Scalar(this.bitLength, newValue, this.signed);
    }

    public byte[] byteArrayValue() {
        int numBytes = (this.bitLength - 1) / 8 + 1;
        long tmpVal = this.getValue();
        byte[] data = new byte[numBytes];
        for (int i = numBytes - 1; i >= 0; --i) {
            data[i] = (byte)tmpVal;
            tmpVal >>= 8;
        }
        return data;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Scalar other = (Scalar)obj;
        long v = this.getValue();
        if (v != other.getValue()) {
            return false;
        }
        if (v < 0L && (this.bitLength == 64 || other.bitLength == 64)) {
            return this.signed == other.signed;
        }
        return true;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int compareTo(Scalar other) {
        if (this.bitLength == 64 || other.bitLength == 64) {
            return this.getBigInteger().compareTo(other.getBigInteger());
        }
        long v = this.getValue() - other.getValue();
        if (v > 0L) {
            return 1;
        }
        if (v < 0L) {
            return -1;
        }
        return 0;
    }

    public Scalar add(long n) {
        return new Scalar(this.bitLength, this.value + n & BITMASKS[this.bitLength]);
    }

    public int bitLength() {
        return this.bitLength;
    }

    public Scalar clearBit(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value & (long)(~(1 << n)));
    }

    public Scalar flipBit(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value ^ (long)(1 << n));
    }

    public Scalar setBit(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value | (long)(1 << n));
    }

    public Scalar shiftLeft(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value << n);
    }

    public Scalar shiftRight(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value >>> n);
    }

    public Scalar shiftRightSign(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return new Scalar(this.bitLength, this.value >> n);
    }

    public Scalar subtract(long n) {
        return this.add(-n);
    }

    public boolean testBit(int n) {
        if (n < 0 || n > this.bitLength - 1) {
            throw new IllegalArgumentException();
        }
        return (this.value & (long)(1 << n)) != 0L;
    }

    public String toString(int radix, boolean zeroPadded, boolean showSign, String pre, String post) {
        String b;
        long val;
        if (!this.signed) {
            showSign = false;
        }
        if (showSign) {
            val = this.getSignedValue();
            int shiftCnt = 64 - this.bitLength;
            val <<= shiftCnt;
            val >>= shiftCnt;
        } else {
            val = this.getUnsignedValue();
        }
        StringBuffer buf = new StringBuffer(32);
        if (this.bitLength == 64 && !this.signed) {
            b = this.getBigInteger().toString(radix);
        } else if (radix == 10) {
            b = Long.toString(val);
        } else {
            if (showSign && val < 0L) {
                val = -val;
                buf.append('-');
            }
            switch (radix) {
                case 2: {
                    b = Long.toBinaryString(val);
                    break;
                }
                case 8: {
                    b = Long.toOctalString(val);
                    break;
                }
                case 16: {
                    b = Long.toHexString(val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid radix");
                }
            }
        }
        buf.append(pre);
        if (zeroPadded) {
            int numDigits = this.getDigits(radix);
            for (int i = 0; i < numDigits - b.length(); ++i) {
                buf.append("0");
            }
        }
        buf.append(b);
        buf.append(post);
        return new String(buf);
    }

    public String toString() {
        return this.toString(16, false, true, "0x", "");
    }

    private int getDigits(int radix) {
        switch (radix) {
            case 2: {
                return this.bitLength;
            }
            case 8: {
                return (this.bitLength - 1) / 3 + 1;
            }
            case 16: {
                return (this.bitLength - 1) / 4 + 1;
            }
        }
        return 0;
    }

    static {
        long value = 1L;
        for (int i = 1; i < 65; ++i) {
            Scalar.BITMASKS[i] = value;
            value = (value << 1) + 1L;
        }
    }
}

