/*
 * Decompiled with CFR 0.152.
 */
package ghidra.sleigh.grammar;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;

public class LexerMultiplexer
implements TokenSource {
    protected final TokenSource[] modes;
    private final Deque<Integer> stack;
    private final Set<Integer> channels;

    public LexerMultiplexer(TokenSource ... modes) {
        this.modes = modes;
        this.stack = new LinkedList<Integer>();
        this.stack.push(0);
        this.channels = new HashSet<Integer>();
        this.channels.add(0);
    }

    public String getSourceName() {
        StringBuilder sb = new StringBuilder();
        sb.append("Mux[");
        for (int i = 0; i < this.modes.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(i);
            sb.append(":");
            sb.append(this.modes[i].getSourceName());
        }
        sb.append("]");
        return sb.toString();
    }

    public Token nextToken() {
        Token t;
        Integer mode = this.stack.peekFirst();
        TokenSource src = this.modes[mode];
        while (!this.channels.contains((t = src.nextToken()).getChannel())) {
        }
        return t;
    }

    public int popMode() {
        return this.stack.pop();
    }

    public void pushMode(int mode) {
        this.stack.push(mode);
    }

    public void setMode(int mode) {
        this.popMode();
        this.pushMode(mode);
    }

    public void channelOn(int channel) {
        this.channels.add(channel);
    }

    public void channelOff(int channel) {
        this.channels.remove(channel);
    }
}

