/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.model.impl;

import agent.gdb.manager.impl.cmd.GdbConsoleExecCommand;
import agent.gdb.model.impl.GdbModelImpl;
import agent.gdb.model.impl.GdbModelTargetInferior;
import ghidra.async.AsyncFence;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.DefaultTargetObject;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Environment", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Void.class)})
public class GdbModelTargetEnvironment
extends DefaultTargetObject<TargetObject, GdbModelTargetInferior>
implements TargetEnvironment {
    public static final String NAME = "Environment";
    public static final String VISIBLE_ARCH_ATTRIBUTE_NAME = "arch";
    public static final String VISIBLE_OS_ATTRIBUTE_NAME = "os";
    public static final String VISIBLE_ENDIAN_ATTRIBUTE_NAME = "endian";
    protected final GdbModelImpl impl;
    protected String arch = "(unknown)";
    protected String os = "(unknown)";
    protected String endian = "(unknown)";

    public GdbModelTargetEnvironment(GdbModelTargetInferior inferior) {
        super((AbstractDebuggerObjectModel)inferior.impl, (TargetObject)inferior, NAME, NAME);
        this.impl = inferior.impl;
        this.changeAttributes(List.of(), Map.of("_debugger", this.impl.session.debugger, "_arch", this.arch, "_os", this.os, "_endian", this.endian, VISIBLE_ARCH_ATTRIBUTE_NAME, this.arch, VISIBLE_OS_ATTRIBUTE_NAME, this.os, VISIBLE_ENDIAN_ATTRIBUTE_NAME, this.endian), "Initialized");
        this.refreshInternal();
    }

    protected CompletableFuture<Void> refreshArchitecture() {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> null).thenCompose(__ -> this.impl.gdb.consoleCapture("show architecture", GdbConsoleExecCommand.CompletesWithRunning.CANNOT))).thenAccept(out -> {
            String[] tokens = out.split("\\s+");
            String arch = tokens[tokens.length - 1].trim();
            while (arch.endsWith(".") || arch.endsWith(")") || arch.endsWith("\"")) {
                arch = arch.substring(0, arch.length() - 1);
            }
            while (arch.startsWith("\"")) {
                arch = arch.substring(1);
            }
            this.arch = arch;
        })).exceptionally(e -> {
            this.model.reportError((Object)this, "Could not get target architecture", e);
            return null;
        });
    }

    protected CompletableFuture<Void> refreshOS() {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> null).thenCompose(__ -> this.impl.gdb.consoleCapture("show os", GdbConsoleExecCommand.CompletesWithRunning.CANNOT))).thenAccept(out -> {
            String[] tokens = out.split("\n")[0].split("\\s+");
            String os = tokens[tokens.length - 1].trim();
            if (os.endsWith(".")) {
                os = os.substring(0, os.length() - 1);
            }
            if (os.endsWith(")")) {
                os = os.substring(0, os.length() - 1);
            }
            if (os.startsWith("\"") && os.endsWith("\"")) {
                os = os.substring(1, os.length() - 1);
            }
            this.os = os;
        })).exceptionally(e -> {
            this.model.reportError((Object)this, "Could not get target os", e);
            return null;
        });
    }

    protected CompletableFuture<Void> refreshEndian() {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> null).thenCompose(__ -> this.impl.gdb.consoleCapture("show endian", GdbConsoleExecCommand.CompletesWithRunning.CANNOT))).thenAccept(out -> {
            this.endian = out.toLowerCase().contains("little endian") ? "little" : (out.toLowerCase().contains("big endian") ? "big" : "(unknown)");
        })).exceptionally(e -> {
            this.model.reportError((Object)this, "Could not get target endian", e);
            return null;
        });
    }

    protected CompletableFuture<Void> refreshInternal() {
        AsyncFence fence = new AsyncFence();
        fence.include(this.refreshArchitecture());
        fence.include(this.refreshOS());
        fence.include(this.refreshEndian());
        return fence.ready().thenAccept(__ -> this.changeAttributes(List.of(), Map.of("_arch", this.arch, "_os", this.os, "_endian", this.endian, VISIBLE_ARCH_ATTRIBUTE_NAME, this.arch, VISIBLE_OS_ATTRIBUTE_NAME, this.os, VISIBLE_ENDIAN_ATTRIBUTE_NAME, this.endian), "Refreshed"));
    }

    @TargetAttributeType(name="arch")
    public String getVisibleArch() {
        return this.arch;
    }

    @TargetAttributeType(name="os")
    public String getVisibleOs() {
        return this.os;
    }

    @TargetAttributeType(name="endian")
    public String getVisibleEndian() {
        return this.endian;
    }

    public String getDebugger() {
        return this.impl.session.debugger;
    }

    public String getArchitecture() {
        return this.arch;
    }

    public String getOperatingSystem() {
        return this.os;
    }

    public String getEndian() {
        return this.endian;
    }
}

