/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;

public class FdOutputStream
extends OutputStream {
    private static final POSIX LIB_POSIX = POSIXFactory.getNativePOSIX();
    private final int fd;
    private boolean closed = false;

    FdOutputStream(int fd) {
        this.fd = fd;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int ret;
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        int total = 0;
        do {
            if ((ret = LIB_POSIX.write(this.fd, buf, len - total)) >= 0) continue;
            throw new IOException(LIB_POSIX.strerror(LIB_POSIX.errno()));
        } while ((total += ret) < len);
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }
}

