/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.linux;

import agent.gdb.pty.PtyChild;
import agent.gdb.pty.PtySession;
import agent.gdb.pty.linux.LinuxPtyEndpoint;
import agent.gdb.pty.linux.LinuxPtySessionLeader;
import agent.gdb.pty.local.LocalProcessPtySession;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class LinuxPtyChild
extends LinuxPtyEndpoint
implements PtyChild {
    private final String name;

    LinuxPtyChild(int fd, String name) {
        super(fd);
        this.name = name;
    }

    @Override
    public String nullSession() {
        return this.name;
    }

    @Override
    public PtySession session(String[] args, Map<String, String> env) throws IOException {
        return this.sessionUsingJavaLeader(args, env);
    }

    protected PtySession sessionUsingJavaLeader(String[] args, Map<String, String> env) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>();
        String javaCommand = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        argsList.add(javaCommand);
        argsList.add("-cp");
        argsList.add(System.getProperty("java.class.path"));
        argsList.add(LinuxPtySessionLeader.class.getCanonicalName());
        argsList.add(this.name);
        argsList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argsList);
        if (env != null) {
            builder.environment().putAll(env);
        }
        builder.inheritIO();
        try {
            return new LocalProcessPtySession(builder.start());
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Could not start process with args " + args), (Throwable)e);
            throw e;
        }
    }

    protected PtySession sessionUsingPythonLeader(String[] args, Map<String, String> env) throws IOException {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("python");
        argsList.add("-m");
        argsList.add("session");
        argsList.add(this.name);
        argsList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argsList);
        if (env != null) {
            builder.environment().putAll(env);
        }
        String sourceLoc = LinuxPtyChild.getSourceLocationForResource("session.py").getAbsolutePath();
        builder.environment().put("PYTHONPATH", sourceLoc);
        builder.inheritIO();
        return new LocalProcessPtySession(builder.start());
    }

    public static File getSourceLocationForResource(String name) {
        URL url = LinuxPtyChild.class.getClassLoader().getResource(name);
        String urlFile = url.getFile();
        try {
            urlFile = URLDecoder.decode(urlFile, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if ("file".equals(url.getProtocol())) {
            int packageLevel = Paths.get(name, new String[0]).getNameCount();
            File file = new File(urlFile);
            for (int i = 0; i < packageLevel; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
        if ("jar".equals(url.getProtocol())) {
            String jarPath = urlFile;
            if (!jarPath.startsWith("file:")) {
                return null;
            }
            jarPath = jarPath.substring(5, jarPath.indexOf(33));
            return new File(jarPath);
        }
        return null;
    }
}

