/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Dimension;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.DefaultVisualizationModel;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public interface VisualizationModel<V, E>
extends ViewChange.Listener,
ViewChange.Producer,
ModelChange.Listener,
ModelChange.Producer,
LayoutSizeChange.Listener<V>,
LayoutSizeChange.Producer<V> {
    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public static <V, E> Builder<V, E, ?, ?> builder(Graph<V, E> graph) {
        return new Builder(graph);
    }

    public static <V, E> Builder<V, E, ?, ?> builder(LayoutModel<V> layoutModel) {
        return new Builder(layoutModel);
    }

    public Dimension getLayoutSize();

    public void setLayoutAlgorithm(LayoutAlgorithm<V> var1);

    public LayoutAlgorithm<V> getLayoutAlgorithm();

    public LayoutModel<V> getLayoutModel();

    public void setLayoutModel(LayoutModel<V> var1);

    public Graph<V, E> getGraph();

    public void setGraph(Graph<V, E> var1);

    public void setGraph(Graph<V, E> var1, boolean var2);

    public Function<Graph<V, ?>, Pair<Integer>> getInitialDimensionFunction();

    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> var1);

    default public LayoutSizeChange.Listener<V> getLayoutSizeChangeListener() {
        return this;
    }

    public static enum SpatialSupport {
        RTREE,
        QUADTREE,
        GRID,
        NONE;

    }

    public static class Builder<V, E, T extends VisualizationModel, B extends Builder<V, E, T, B>> {
        protected Graph<V, E> graph = GraphTypeBuilder.directed().buildGraph();
        protected LayoutAlgorithm<V> layoutAlgorithm;
        protected LayoutModel<V> layoutModel;
        protected Dimension layoutSize = new Dimension(600, 600);
        protected Function<V, Point> initializer;
        protected Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction;

        protected B self() {
            return (B)this;
        }

        protected Builder() {
        }

        protected Builder(Graph<V, E> graph) {
            this.graph = graph;
        }

        protected Builder(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
        }

        public B layoutAlgorithm(LayoutAlgorithm<V> layoutAlgorithm) {
            this.layoutAlgorithm = layoutAlgorithm;
            return this.self();
        }

        public B layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            return this.self();
        }

        public B initialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
            this.initialDimensionFunction = initialDimensionFunction;
            return this.self();
        }

        public B layoutSize(Dimension layoutSize) {
            this.layoutSize = layoutSize;
            return this.self();
        }

        public B initializer(Function<V, Point> initializer) {
            this.initializer = initializer;
            return this.self();
        }

        public T build() {
            return (T)new DefaultVisualizationModel(this);
        }
    }
}

