/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.util.function.BiFunction;
import org.jgrapht.Graph;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.AbstractEdgeRenderer;
import org.jungrapht.visualization.renderers.EdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;

public class LightweightEdgeRenderer<V, E>
extends AbstractEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    @Override
    protected Shape getEdgeShape(BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction, E edge, Graph<V, E> graph) {
        if (edgeShapeFunction instanceof EdgeShape.ArticulatedLine) {
            return edgeShapeFunction.apply(graph, edge);
        }
        return EdgeShape.line().apply(graph, edge);
    }

    @Override
    protected void drawSimpleEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Paint draw_paint;
        Graphics2D g2d = renderContext.getGraphicsContext().getDelegate();
        BasicStroke savedStroke = (BasicStroke)g2d.getStroke();
        float savedStrokeWidth = renderContext.getEdgeWidth();
        float wider = Math.max(savedStrokeWidth, (float)((int)(1.0 / g2d.getTransform().getScaleX())));
        if (savedStroke instanceof BasicStroke) {
            BasicStroke basicStroke = savedStroke;
            BasicStroke widerStroke = new BasicStroke(wider, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            g2d.setStroke(widerStroke);
        } else {
            g2d.setStroke(new BasicStroke(wider));
        }
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.prepareFinalEdgeShape(renderContext, layoutModel, e, coords, loop);
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Paint fill_paint = renderContext.getEdgeFillPaintFunction().apply(e);
        if (fill_paint != null) {
            g.setPaint(fill_paint);
            g.fill(edgeShape);
        }
        if ((draw_paint = renderContext.getEdgeDrawPaintFunction().apply(e)) != null) {
            g.setPaint(draw_paint);
            g.draw(edgeShape);
        }
        g.setPaint(oldPaint);
        g2d.setStroke(savedStroke);
    }

    @Override
    public EdgeArrowRenderingSupport<V, E> getEdgeArrowRenderingSupport() {
        return null;
    }

    @Override
    public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<V, E> edgeArrowRenderingSupport) {
    }
}

