/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotFoundException;

public class ARM_MachoRelocationHandler
extends MachoRelocationHandler {
    public boolean canRelocate(MachHeader header) {
        return header.getCpuType() == 12;
    }

    public boolean isPairedRelocation(RelocationInfo relocation) {
        return relocation.getType() == 2 || relocation.getType() == 3 || relocation.getType() == 8 || relocation.getType() == 9;
    }

    public void relocate(MachoRelocation relocation) throws MemoryAccessException, NotFoundException {
        if (!relocation.requiresRelocation()) {
            return;
        }
        RelocationInfo relocationInfo = relocation.getRelocationInfo();
        Address targetAddr = relocation.getTargetAddress();
        long orig = ARM_MachoRelocationHandler.read((MachoRelocation)relocation);
        switch (relocationInfo.getType()) {
            case 0: {
                if (!relocationInfo.isPcRelocated()) {
                    ARM_MachoRelocationHandler.write((MachoRelocation)relocation, (long)targetAddr.getOffset());
                    break;
                }
                throw new NotFoundException("Unimplemented relocation");
            }
            case 6: {
                boolean blx = (orig & 0xFFFFFFFFD000F800L) == -1073680384L;
                long s = orig >> 10 & 1L;
                long j1 = orig >> 29 & 1L;
                long j2 = orig >> 27 & 1L;
                long i1 = (j1 ^ s ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                long i2 = (j2 ^ s ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                long imm10 = orig & 0x3FFL;
                long imm11 = orig >> 16 & 0x7FFL;
                long addend = s << 24 | i1 << 23 | i2 << 22 | imm10 << 12 | imm11 << 1;
                addend |= s == 1L ? -33554432L : 0L;
                long value = targetAddr.getOffset() + (addend &= blx ? -4L : -1L);
                s = value >> 24 & 1L;
                i1 = value >> 23 & 1L;
                i2 = value >> 22 & 1L;
                j1 = (i1 ^ s ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                j2 = (i2 ^ s ^ 0xFFFFFFFFFFFFFFFFL) & 1L;
                imm10 = value >> 12 & 0x3FFL;
                imm11 = value >> 1 & 0x7FFL;
                long instr = orig & (long)(blx ? -1073678336 : -805242880);
                ARM_MachoRelocationHandler.write((MachoRelocation)relocation, (long)(instr |= j1 << 29 | j2 << 27 | imm11 << 16 | s << 10 | imm10));
                break;
            }
            default: {
                throw new NotFoundException("Unimplemented relocation");
            }
        }
    }
}

