/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;

public class AsyncPairingQueue<T> {
    private final Deque<CompletableFuture<? extends T>> givers = new LinkedList<CompletableFuture<? extends T>>();
    private final Deque<CompletableFuture<T>> takers = new LinkedList<CompletableFuture<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void give(CompletableFuture<? extends T> giver) {
        CompletableFuture<T> taker;
        Deque<CompletableFuture<? extends T>> deque = this.givers;
        synchronized (deque) {
            if (this.takers.isEmpty()) {
                this.givers.add(giver);
                return;
            }
            taker = this.takers.poll();
        }
        this.pair(giver, taker);
    }

    public CompletableFuture<T> give() {
        CompletableFuture giver = new CompletableFuture();
        this.give(giver);
        return giver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> take() {
        CompletableFuture<? extends T> giver;
        CompletableFuture taker = new CompletableFuture();
        Deque<CompletableFuture<? extends T>> deque = this.givers;
        synchronized (deque) {
            if (this.givers.isEmpty()) {
                this.takers.add(taker);
                return taker;
            }
            giver = this.givers.poll();
        }
        this.pair(giver, taker);
        return taker;
    }

    private void pair(CompletableFuture<? extends T> giver, CompletableFuture<T> taker) {
        giver.handle((val, exc) -> {
            if (exc != null) {
                taker.completeExceptionally((Throwable)exc);
            } else {
                taker.complete(val);
            }
            return null;
        });
    }
}

