/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;

public interface TypeSpec<U> {
    public static final TypeSpec RAW = new TypeSpec(){};
    public static final TypeSpec<Object> OBJECT = TypeSpec.auto();
    public static final TypeSpec<Boolean> BOOLEAN = TypeSpec.auto();
    public static final TypeSpec<Byte> BYTE = TypeSpec.auto();
    public static final TypeSpec<Character> CHAR = TypeSpec.auto();
    public static final TypeSpec<Short> SHORT = TypeSpec.auto();
    public static final TypeSpec<Integer> INT = TypeSpec.auto();
    public static final TypeSpec<Long> LONG = TypeSpec.auto();
    public static final TypeSpec<String> STRING = TypeSpec.auto();
    public static final TypeSpec<Void> VOID = TypeSpec.auto();
    public static final TypeSpec<byte[]> BYTE_ARRAY = TypeSpec.auto();

    public static <T> TypeSpec<T> auto() {
        return RAW;
    }

    public static <T> TypeSpec<T> from(Future<T> future) {
        return TypeSpec.auto();
    }

    public static <U> TypeSpec<U> cls(Class<U> cls) {
        return TypeSpec.auto();
    }

    public static <U> TypeSpec<U> obj(U example) {
        return TypeSpec.auto();
    }

    default public <C extends Collection<U>> TypeSpec<C> col() {
        return TypeSpec.auto();
    }

    default public <C extends Collection<U>> TypeSpec<C> col(Class<? super C> cls) {
        return TypeSpec.auto();
    }

    default public <C extends Set<U>> TypeSpec<C> set() {
        return TypeSpec.auto();
    }

    default public <C extends List<U>> TypeSpec<C> list() {
        return TypeSpec.auto();
    }

    default public TypeSpec<? extends U> ext() {
        return TypeSpec.auto();
    }

    default public <K> TypeSpec<Map<K, U>> mappedBy(TypeSpec<K> keyType) {
        return TypeSpec.auto();
    }

    default public <K> TypeSpec<Map<K, U>> mappedBy(Class<K> keyCls) {
        return TypeSpec.auto();
    }

    public static <K, V> TypeSpec<Map<K, V>> map(Class<K> keyCls, Class<V> valCls) {
        return TypeSpec.auto();
    }

    public static <L, R> TypeSpec<Pair<L, R>> pair(TypeSpec<L> lSpec, TypeSpec<R> rSpec) {
        return TypeSpec.auto();
    }

    public static <U> TypeSpec<U> future(FuncArity0<? extends Future<U>> func) {
        return TypeSpec.auto();
    }

    public static <U, P0> TypeSpec<U> future(FuncArity1<? extends Future<U>, P0> func) {
        return TypeSpec.auto();
    }

    public static <U, P0, P1> TypeSpec<U> future(FuncArity2<? extends Future<U>, P0, P1> func) {
        return TypeSpec.auto();
    }

    public static <U, P0, P1, P2> TypeSpec<U> future(FuncArity3<? extends Future<U>, P0, P1, P2> func) {
        return TypeSpec.auto();
    }

    public static <U, P0, P1, P2, P3> TypeSpec<U> future(FuncArity4<? extends Future<U>, P0, P1, P2, P3> func) {
        return TypeSpec.auto();
    }

    public static interface FuncArity4<R, P0, P1, P2, P3> {
        public R func(P0 var1, P1 var2, P2 var3, P3 var4);
    }

    public static interface FuncArity3<R, P0, P1, P2> {
        public R func(P0 var1, P1 var2, P2 var3);
    }

    public static interface FuncArity2<R, P0, P1> {
        public R func(P0 var1, P1 var2);
    }

    public static interface FuncArity1<R, P0> {
        public R func(P0 var1);
    }

    public static interface FuncArity0<R> {
        public R func();
    }
}

