/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import ghidra.GhidraOptions;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerPanel;
import ghidra.app.plugin.core.byteviewer.DataModelInfo;
import ghidra.app.plugin.core.byteviewer.OptionsAction;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.byteviewer.ToggleEditAction;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteBlockSet;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.app.services.MarkerService;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import resources.ResourceManager;

public abstract class ByteViewerComponentProvider
extends ComponentProviderAdapter
implements OptionsChangeListener {
    protected static final String BLOCK_NUM = "Block Num";
    protected static final String BLOCK_OFFSET = "Block Offset";
    protected static final String BLOCK_COLUMN = "Block Column";
    protected static final String INDEX = "Index";
    protected static final String X_OFFSET = "X Offset";
    protected static final String Y_OFFSET = "Y Offset";
    private static final String VIEW_NAMES = "View Names";
    private static final String HEX_VIEW_GROUPSIZE = "Hex view groupsize";
    private static final String BYTES_PER_LINE_NAME = "Bytes Per Line";
    private static final String OFFSET_NAME = "Offset";
    static final int DEFAULT_NUMBER_OF_CHARS = 8;
    static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    static final int DEFAULT_BYTES_PER_LINE = 16;
    static final Color DEFAULT_MISSING_VALUE_COLOR = Color.blue;
    static final Color DEFAULT_EDIT_COLOR = Color.red;
    static final Color DEFAULT_CURRENT_CURSOR_COLOR = Color.magenta.brighter();
    static final Color DEFAULT_CURSOR_COLOR = Color.black;
    static final Color DEFAULT_NONFOCUS_CURSOR_COLOR = Color.darkGray;
    private static final Color DEFAULT_CURSOR_LINE_COLOR = GhidraOptions.DEFAULT_CURSOR_LINE_COLOR;
    static final String DEFAULT_INDEX_NAME = "Addresses";
    static final String OPTION_EDIT_COLOR = "Edit Cursor Color";
    static final String OPTION_SEPARATOR_COLOR = "Block Separator Color";
    static final String OPTION_CURRENT_VIEW_CURSOR_COLOR = "Current View Cursor Color";
    static final String OPTION_CURSOR_COLOR = "Cursor Color";
    static final String OPTION_FONT = "Font";
    static final String OPTION_NONFOCUS_CURSOR_COLOR = "Non-Focus Cursor Color";
    private static final String DEFAULT_VIEW = "Hex";
    private static final String OPTION_CURRENT_LINE_COLOR = "Highlight Cursor Line Color";
    private static final String OPTION_HIGHLIGHT_CURSOR_LINE = "Highlight Cursor Line";
    protected ByteViewerPanel panel;
    private Color editColor;
    private Color currentCursorColor;
    private Color defaultCursorColor;
    private int bytesPerLine;
    private int offset;
    private int hexGroupSize = 1;
    protected Map<String, ByteViewerComponent> viewMap = new HashMap<String, ByteViewerComponent>();
    protected ToggleEditAction editModeAction;
    protected OptionsAction setOptionsAction;
    protected ProgramByteBlockSet blockSet;
    protected final AbstractByteViewerPlugin<?> plugin;
    protected SwingUpdateManager updateManager;
    private Map<String, Class<? extends DataFormatModel>> dataFormatModelClassMap;

    protected ByteViewerComponentProvider(PluginTool tool, AbstractByteViewerPlugin<?> plugin, String name, Class<?> contextType) {
        super(tool, name, plugin.getName(), contextType);
        this.plugin = plugin;
        this.initializedDataFormatModelClassMap();
        this.panel = this.newByteViewerPanel();
        this.bytesPerLine = 16;
        this.setIcon(ResourceManager.loadImage((String)"images/binaryData.gif"));
        this.setOptions();
        this.createActions();
        this.updateManager = new SwingUpdateManager(1000, 3000, () -> this.refreshView());
        this.addView(DEFAULT_VIEW);
        this.setWindowMenuGroup("Byte Viewer");
    }

    protected ByteViewerPanel newByteViewerPanel() {
        return new ByteViewerPanel(this);
    }

    private void initializedDataFormatModelClassMap() {
        this.dataFormatModelClassMap = new HashMap<String, Class<? extends DataFormatModel>>();
        Set<DataFormatModel> models = this.getDataFormatModels();
        for (DataFormatModel model : models) {
            this.dataFormatModelClassMap.put(model.getName(), model.getClass());
        }
    }

    private void createActions() {
        this.editModeAction = new ToggleEditAction(this, this.plugin);
        this.setOptionsAction = new OptionsAction(this, this.plugin);
        this.addLocalAction((DockingActionIf)this.editModeAction);
        this.addLocalAction((DockingActionIf)this.setOptionsAction);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "ByteViewerPlugin");
    }

    protected ByteBlock[] getByteBlocks() {
        return this.blockSet == null ? null : this.blockSet.getBlocks();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (options.getName().equals("ByteViewer")) {
            if (optionName.equals(OPTION_CURRENT_VIEW_CURSOR_COLOR)) {
                this.panel.setCurrentCursorColor((Color)newValue);
            } else if (optionName.equals(OPTION_CURSOR_COLOR)) {
                this.panel.setCursorColor((Color)newValue);
            } else if (optionName.equals(OPTION_CURRENT_LINE_COLOR)) {
                this.panel.setCurrentCursorLineColor((Color)newValue);
            } else if (optionName.equals(OPTION_EDIT_COLOR)) {
                this.panel.setEditColor((Color)newValue);
            } else if (optionName.equals(OPTION_SEPARATOR_COLOR)) {
                this.panel.setSeparatorColor((Color)newValue);
            } else if (optionName.equals(OPTION_NONFOCUS_CURSOR_COLOR)) {
                this.panel.setNonFocusCursorColor((Color)newValue);
            } else if (optionName.equals(OPTION_FONT)) {
                this.setFont(SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue)));
            }
        } else if (options.getName().equals("Listing Fields")) {
            if (optionName.equals("Cursor Text Highlight.Mouse Button To Activate")) {
                GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)newValue;
                this.panel.setHighlightButton(mouseButton.getMouseEventID());
            } else if (optionName.equals("Cursor Text Highlight.Highlight Color")) {
                this.panel.setMouseButtonHighlightColor((Color)newValue);
            }
        }
    }

    private void setFont(Font font) {
        FontMetrics fm = this.panel.getFontMetrics(font);
        this.panel.setFontMetrics(fm);
        this.tool.setConfigChanged(true);
    }

    private void setOptions() {
        ToolOptions opt = this.tool.getOptions("ByteViewer");
        HelpLocation help = new HelpLocation("ByteViewerPlugin", "Option");
        opt.setOptionsHelpLocation(help);
        opt.registerOption(OPTION_SEPARATOR_COLOR, (Object)DEFAULT_MISSING_VALUE_COLOR, help, "Color used for separator shown between memory blocks.");
        opt.registerOption(OPTION_SEPARATOR_COLOR, (Object)DEFAULT_MISSING_VALUE_COLOR, help, "Color used for separator shown between memory blocks.");
        opt.registerOption(OPTION_EDIT_COLOR, (Object)DEFAULT_EDIT_COLOR, new HelpLocation("ByteViewerPlugin", "EditColor"), "Color of cursor when the current view is in edit mode and can support editing.");
        opt.registerOption(OPTION_CURRENT_VIEW_CURSOR_COLOR, (Object)DEFAULT_CURRENT_CURSOR_COLOR, help, "Color of cursor when it is in the current view.");
        opt.registerOption(OPTION_NONFOCUS_CURSOR_COLOR, (Object)DEFAULT_NONFOCUS_CURSOR_COLOR, help, "Color of cursor when it is not the current view.");
        opt.registerOption(OPTION_CURSOR_COLOR, (Object)DEFAULT_CURSOR_COLOR, help, "Color of cursor for other views other than the current view.");
        opt.registerOption(OPTION_FONT, (Object)DEFAULT_FONT, help, "Font used in the views.");
        opt.registerOption(OPTION_CURRENT_LINE_COLOR, (Object)DEFAULT_CURSOR_LINE_COLOR, help, "Color of the line containing the cursor");
        opt.registerOption(OPTION_HIGHLIGHT_CURSOR_LINE, (Object)true, help, "Toggles highlighting background color of line containing the cursor");
        Color missingValueColor = opt.getColor(OPTION_SEPARATOR_COLOR, DEFAULT_MISSING_VALUE_COLOR);
        this.panel.setSeparatorColor(missingValueColor);
        this.editColor = opt.getColor(OPTION_EDIT_COLOR, DEFAULT_EDIT_COLOR);
        this.currentCursorColor = opt.getColor(OPTION_CURRENT_VIEW_CURSOR_COLOR, DEFAULT_CURRENT_CURSOR_COLOR);
        this.panel.setCurrentCursorColor(this.currentCursorColor);
        Color nonFocusCursorColor = opt.getColor(OPTION_NONFOCUS_CURSOR_COLOR, DEFAULT_NONFOCUS_CURSOR_COLOR);
        this.panel.setNonFocusCursorColor(nonFocusCursorColor);
        this.defaultCursorColor = opt.getColor(OPTION_CURSOR_COLOR, DEFAULT_CURSOR_COLOR);
        this.panel.setCursorColor(this.defaultCursorColor);
        Color cursorLineColor = opt.getColor(OPTION_CURRENT_LINE_COLOR, DEFAULT_CURSOR_LINE_COLOR);
        this.panel.setCurrentCursorLineColor(cursorLineColor);
        Font font = SystemUtilities.adjustForFontSizeOverride((Font)opt.getFont(OPTION_FONT, DEFAULT_FONT));
        FontMetrics fm = this.panel.getFontMetrics(font);
        this.panel.restoreConfigState(fm, this.editColor);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        opt = this.tool.getOptions("Listing Fields");
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)opt.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.panel.setHighlightButton(mouseButton.getMouseEventID());
        this.panel.setMouseButtonHighlightColor(opt.getColor("Cursor Text Highlight.Highlight Color", Color.YELLOW));
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    void setBlockOffset(int blockOffset) {
        if (blockOffset == this.offset) {
            return;
        }
        int newOffset = blockOffset;
        if (newOffset > this.bytesPerLine) {
            newOffset %= this.bytesPerLine;
        }
        this.offset = newOffset;
        this.panel.setOffset(newOffset);
        this.tool.setConfigChanged(true);
    }

    ByteBlockInfo getCursorLocation() {
        return this.panel.getCursorLocation();
    }

    ByteBlockSelection getBlockSelection() {
        return this.panel.getViewerSelection();
    }

    void setBlockSelection(ByteBlockSelection selection) {
        this.panel.setViewerSelection(selection);
    }

    ByteBlockSet getByteBlockSet() {
        return this.blockSet;
    }

    int getBytesPerLine() {
        return this.bytesPerLine;
    }

    int getOffset() {
        return this.offset;
    }

    Color getCursorColor() {
        return this.defaultCursorColor;
    }

    int getGroupSize() {
        return this.hexGroupSize;
    }

    void setGroupSize(int groupSize) {
        if (groupSize == this.hexGroupSize) {
            return;
        }
        this.hexGroupSize = groupSize;
        ByteViewerComponent component = this.viewMap.get(DEFAULT_VIEW);
        if (component != null) {
            component.setGroupSize(groupSize);
            component.invalidate();
            this.panel.repaint();
        }
        this.tool.setConfigChanged(true);
    }

    void setBytesPerLine(int bytesPerLine) {
        if (this.bytesPerLine != bytesPerLine) {
            this.bytesPerLine = bytesPerLine;
            this.panel.setBytesPerLine(bytesPerLine);
            this.tool.setConfigChanged(true);
        }
    }

    protected void writeConfigState(SaveState saveState) {
        DataModelInfo info = this.panel.getDataModelInfo();
        saveState.putStrings(VIEW_NAMES, info.getNames());
        saveState.putInt(HEX_VIEW_GROUPSIZE, this.hexGroupSize);
        saveState.putInt(BYTES_PER_LINE_NAME, this.bytesPerLine);
        saveState.putInt(OFFSET_NAME, this.offset);
    }

    protected void readConfigState(SaveState saveState) {
        String[] names = saveState.getStrings(VIEW_NAMES, new String[0]);
        this.hexGroupSize = saveState.getInt(HEX_VIEW_GROUPSIZE, 1);
        this.restoreViews(names, false);
        this.bytesPerLine = saveState.getInt(BYTES_PER_LINE_NAME, 16);
        this.offset = saveState.getInt(OFFSET_NAME, 0);
        this.panel.restoreConfigState(this.bytesPerLine, this.offset);
    }

    private void restoreViews(String[] viewNames, boolean updateViewPosition) {
        for (String viewName : this.viewMap.keySet()) {
            this.removeView(viewName, false);
        }
        for (String viewName : viewNames) {
            DataFormatModel dataFormatModel = this.getDataFormatModel(viewName);
            if (dataFormatModel == null) continue;
            this.addView(dataFormatModel, false, updateViewPosition);
        }
        if (this.viewMap.isEmpty()) {
            this.addView(DEFAULT_VIEW);
        }
    }

    void addView(String modelName) {
        DataFormatModel dataFormatModel = this.getDataFormatModel(modelName);
        if (dataFormatModel != null) {
            this.addView(dataFormatModel, false, true);
        }
    }

    private ByteViewerComponent addView(DataFormatModel model, boolean configChanged, boolean updateViewPosition) {
        if (model.getName().equals(DEFAULT_VIEW)) {
            model.setGroupSize(this.hexGroupSize);
        }
        String viewName = model.getName();
        ByteViewerComponent bvc = this.panel.addView(viewName, model, this.editModeAction.isSelected(), updateViewPosition);
        this.viewMap.put(viewName, bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
        return bvc;
    }

    void removeView(String viewName, boolean configChanged) {
        ByteViewerComponent bvc = this.viewMap.remove(viewName);
        if (bvc == null) {
            return;
        }
        this.panel.removeView(bvc);
        if (configChanged) {
            this.tool.setConfigChanged(true);
        }
    }

    protected abstract void updateLocation(ByteBlock var1, BigInteger var2, int var3, boolean var4);

    protected abstract void updateSelection(ByteBlockSelection var1);

    void dispose() {
        this.updateManager.dispose();
        this.updateManager = null;
        if (this.blockSet != null) {
            this.blockSet.dispose();
        }
        this.blockSet = null;
    }

    public Set<String> getCurrentViews() {
        DataModelInfo info = this.panel.getDataModelInfo();
        HashSet<String> currentViewNames = new HashSet<String>(Arrays.asList(info.getNames()));
        return currentViewNames;
    }

    private void refreshView() {
        if (this.tool == null) {
            return;
        }
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.panel.refreshView();
        }
    }

    protected ByteViewerPanel getByteViewerPanel() {
        return this.panel;
    }

    void setStatusMessage(String message) {
        this.plugin.setStatusMessage(message);
    }

    void setEditMode(boolean isEditable) {
        this.panel.setEditMode(isEditable);
    }

    protected Set<DataFormatModel> getDataFormatModels() {
        HashSet<DataFormatModel> set = new HashSet<DataFormatModel>();
        set.addAll(ClassSearcher.getInstances(UniversalDataFormatModel.class));
        return set;
    }

    public List<String> getDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>(this.dataFormatModelClassMap.keySet());
        Collections.sort(names);
        return names;
    }

    public DataFormatModel getDataFormatModel(String formatName) {
        Class<? extends DataFormatModel> classy = this.dataFormatModelClassMap.get(formatName);
        if (classy == null) {
            return null;
        }
        try {
            return classy.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error loading ByteViewer model formats", (Throwable)e);
            return null;
        }
    }

    public MarkerService getMarkerService() {
        return (MarkerService)this.tool.getService(MarkerService.class);
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.panel.addDisplayListener(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.panel.removeDisplayListener(listener);
    }
}

