/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PcodeOpEmitter {
    static final String RAM = "ram";
    private HashMap<String, Varnode> nameToReg = new HashMap();
    private ArrayList<PcodeOp> opList = new ArrayList();
    private SleighLanguage language;
    private AddressSpace defSpace;
    private AddressSpace constSpace;
    private AddressSpace uniqueSpace;
    private Varnode spVarnode;
    private Varnode defSpaceId;
    private long uniqueBase;
    private Address opAddress;
    private int seqnum;

    private Varnode convertRegisterToVarnode(Register reg) {
        Varnode vn = new Varnode(reg.getAddress(), reg.getBitLength() / 8);
        return vn;
    }

    private String findTempName(Address addr) {
        if (addr.getAddressSpace() != this.uniqueSpace) {
            return null;
        }
        for (Map.Entry<String, Varnode> entry : this.nameToReg.entrySet()) {
            if (!entry.getValue().getAddress().equals((Object)addr)) continue;
            return entry.getKey();
        }
        return null;
    }

    private Varnode findRegister(String name) {
        Varnode vn = this.nameToReg.get(name);
        if (vn != null) {
            return vn;
        }
        Register reg = this.language.getRegister(name);
        if (reg == null) {
            throw new IllegalArgumentException("Register must already exist: " + name);
        }
        vn = this.convertRegisterToVarnode(reg);
        this.nameToReg.put(name, vn);
        return vn;
    }

    private Varnode findVarnode(String name, int size) {
        Varnode vn = this.nameToReg.get(name);
        if (vn != null) {
            if (vn.getSize() != size) {
                throw new IllegalArgumentException("Cannot find varnode: " + name);
            }
            return vn;
        }
        Register reg = this.language.getRegister(name);
        if (reg != null && reg.getBitLength() == size * 8) {
            vn = this.convertRegisterToVarnode(reg);
            this.nameToReg.put(name, vn);
            return vn;
        }
        vn = new Varnode(this.uniqueSpace.getAddress(this.uniqueBase), size);
        this.uniqueBase += 16L;
        this.nameToReg.put(name, vn);
        return vn;
    }

    private Varnode constantOrRegister(String name) {
        if (name.charAt(0) <= '9') {
            long val = Long.decode(name);
            return this.getConstant(val, 8);
        }
        return this.findRegister(name);
    }

    private Varnode getConstant(long val, int size) {
        return new Varnode(this.constSpace.getAddress(val), size);
    }

    private int findOpCode(String name) {
        if (name.equals("cpool")) {
            return 68;
        }
        return 1;
    }

    public PcodeOpEmitter(SleighLanguage language, Address opAddr, long uniqBase) {
        this.language = language;
        this.constSpace = language.getAddressFactory().getConstantSpace();
        this.defSpace = language.getDefaultSpace();
        this.uniqueSpace = language.getAddressFactory().getUniqueSpace();
        this.uniqueBase = uniqBase;
        this.opAddress = opAddr;
        this.seqnum = 0;
        this.spVarnode = this.findRegister("SP");
        this.defSpaceId = this.getConstant(this.defSpace.getSpaceID(), 4);
    }

    public PcodeOp[] getPcodeOps() {
        PcodeOp[] res = new PcodeOp[this.opList.size()];
        this.opList.toArray(res);
        return res;
    }

    public void defineTemp(String name, int size) {
        Varnode vn = this.findVarnode(name, size);
        if (!vn.isUnique() || vn.getSize() != size) {
            throw new IllegalArgumentException("Name is already assigned: " + name);
        }
    }

    public void emitPushCat1Value(String valueName) {
        Varnode[] in = new Varnode[]{this.spVarnode, this.getConstant(4L, this.spVarnode.getSize())};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 20, in, this.spVarnode);
        this.opList.add(op);
        in = new Varnode[]{this.defSpaceId, this.spVarnode, this.findRegister(valueName)};
        op = new PcodeOp(this.opAddress, this.seqnum++, 3, in);
        this.opList.add(op);
    }

    public void emitPushCat2Value(String valueName) {
        Varnode[] in = new Varnode[]{this.spVarnode, this.getConstant(8L, this.spVarnode.getSize())};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 20, in, this.spVarnode);
        this.opList.add(op);
        in = new Varnode[]{this.defSpaceId, this.spVarnode, this.findRegister(valueName)};
        op = new PcodeOp(this.opAddress, this.seqnum++, 3, in);
        this.opList.add(op);
    }

    public void emitPopCat2Value(String destName) {
        Varnode out = this.findVarnode(destName, 8);
        Varnode[] in = new Varnode[]{this.defSpaceId, this.spVarnode};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 2, in, out);
        this.opList.add(op);
        in = new Varnode[]{this.spVarnode, this.getConstant(8L, this.spVarnode.getSize())};
        op = new PcodeOp(this.opAddress, this.seqnum++, 19, in, this.spVarnode);
        this.opList.add(op);
    }

    public void emitPopCat1Value(String destName) {
        Varnode out = this.findVarnode(destName, 4);
        Varnode[] in = new Varnode[]{this.defSpaceId, this.spVarnode};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 2, in, out);
        this.opList.add(op);
        in = new Varnode[]{this.spVarnode, this.getConstant(4L, this.spVarnode.getSize())};
        op = new PcodeOp(this.opAddress, this.seqnum++, 19, in, this.spVarnode);
        this.opList.add(op);
    }

    public void emitAssignVarnodeFromPcodeOpCall(String varnodeName, int size, String pcodeop, String ... args) {
        int opcode;
        int i;
        Varnode[] in;
        Symbol useropSym = this.language.getSymbolTable().findGlobalSymbol(pcodeop);
        Varnode out = this.findVarnode(varnodeName, size);
        if (useropSym instanceof UseropSymbol) {
            in = new Varnode[args.length + 1];
            in[0] = this.getConstant(((UseropSymbol)useropSym).getIndex(), 4);
            for (i = 0; i < args.length; ++i) {
                in[i + 1] = this.constantOrRegister(args[i]);
            }
            opcode = 9;
        } else {
            in = new Varnode[args.length];
            for (i = 0; i < args.length; ++i) {
                in[i] = this.constantOrRegister(args[i]);
            }
            opcode = this.findOpCode(pcodeop);
        }
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, opcode, in, out);
        this.opList.add(op);
    }

    public void emitVoidPcodeOpCall(String pcodeop, String ... args) {
        Symbol useropSym = this.language.getSymbolTable().findGlobalSymbol(pcodeop);
        Varnode[] in = new Varnode[args.length + 1];
        in[0] = this.getConstant(((UseropSymbol)useropSym).getIndex(), 4);
        for (int i = 0; i < args.length; ++i) {
            in[i + 1] = this.constantOrRegister(args[i]);
        }
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 9, in);
        this.opList.add(op);
    }

    public void emitAssignConstantToRegister(String register, int constant) {
        Varnode out = this.findRegister(register);
        Varnode[] in = new Varnode[]{this.getConstant(constant, out.getSize())};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 1, in, out);
        this.opList.add(op);
    }

    public void emitAssignRegisterFromPcodeOpCall(String register, String pcodeop, String ... args) {
        int opcode;
        int i;
        Varnode[] in;
        Symbol useropSym = this.language.getSymbolTable().findGlobalSymbol(pcodeop);
        Varnode out = this.findRegister(register);
        if (useropSym instanceof UseropSymbol) {
            in = new Varnode[args.length + 1];
            in[0] = this.getConstant(((UseropSymbol)useropSym).getIndex(), 4);
            for (i = 0; i < args.length; ++i) {
                in[i + 1] = this.constantOrRegister(args[i]);
            }
            opcode = 9;
        } else {
            in = new Varnode[args.length];
            for (i = 0; i < args.length; ++i) {
                in[i] = this.constantOrRegister(args[i]);
            }
            opcode = this.findOpCode(pcodeop);
        }
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, opcode, in, out);
        this.opList.add(op);
    }

    public void emitWriteToMemory(String space, int size, String offset, String value) {
        Varnode[] in = new Varnode[3];
        AddressSpace spc = this.language.getAddressFactory().getAddressSpace(space);
        in[0] = this.getConstant(spc.getSpaceID(), 4);
        if (offset.charAt(0) <= '9') {
            String[] piece = offset.split(":");
            int sz = Integer.parseInt(piece[1]);
            long val = Long.decode(piece[0]);
            in[1] = this.getConstant(val, sz);
        } else {
            in[1] = this.findRegister(offset);
        }
        in[2] = this.findVarnode(value, size);
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 3, in);
        this.opList.add(op);
    }

    public void emitIndirectCall(String target) {
        Varnode[] in = new Varnode[]{this.findRegister(target)};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 8, in);
        this.opList.add(op);
    }

    public void emitSignExtension(String dest, int size, String src) {
        Varnode out = this.findVarnode(dest, size);
        Varnode[] in = new Varnode[]{this.findRegister(src)};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 18, in, out);
        this.opList.add(op);
    }

    public void emitZeroExtension(String dest, int size, String src) {
        Varnode out = this.findVarnode(dest, size);
        Varnode[] in = new Varnode[]{this.findRegister(src)};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 17, in, out);
        this.opList.add(op);
    }

    public void emitTruncate(String dest, int size, String src) {
        Varnode out = this.findVarnode(dest, size);
        Varnode[] in = new Varnode[]{this.findRegister(src), this.getConstant(0L, 4)};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 63, in, out);
        this.opList.add(op);
    }

    public void emitAssignVarnodeFromDereference(String lhs, int size, String rhs) {
        Varnode out = this.findVarnode(lhs, size);
        Varnode[] in = new Varnode[]{this.defSpaceId, this.findRegister(rhs)};
        PcodeOp op = new PcodeOp(this.opAddress, this.seqnum++, 2, in, out);
        this.opList.add(op);
    }

    private boolean compareVarnode(Varnode vn1, Varnode vn2, PcodeOpEmitter op2) {
        long offset2;
        AddressSpace spc2;
        if (vn1 == null) {
            return vn2 == null;
        }
        if (vn2 == null) {
            return false;
        }
        if (vn1.getSize() != vn2.getSize()) {
            return false;
        }
        AddressSpace spc1 = vn1.getAddress().getAddressSpace();
        if (spc1 != (spc2 = vn2.getAddress().getAddressSpace())) {
            return false;
        }
        long offset1 = vn1.getOffset();
        if (offset1 == (offset2 = vn2.getOffset())) {
            return true;
        }
        String name1 = this.findTempName(vn1.getAddress());
        if (name1 == null) {
            return false;
        }
        String name2 = op2.findTempName(vn2.getAddress());
        if (name2 == null) {
            return false;
        }
        return name1.equals(name2);
    }

    public boolean equals(Object obj) {
        PcodeOpEmitter op2 = (PcodeOpEmitter)obj;
        if (this.opList.size() != op2.opList.size()) {
            return false;
        }
        for (int i = 0; i < this.opList.size(); ++i) {
            PcodeOp aop = this.opList.get(i);
            PcodeOp bop = op2.opList.get(i);
            if (aop.getOpcode() != bop.getOpcode()) {
                return false;
            }
            if (aop.getNumInputs() != bop.getNumInputs()) {
                return false;
            }
            if (!this.compareVarnode(aop.getOutput(), bop.getOutput(), op2)) {
                return false;
            }
            for (int j = 0; j < aop.getNumInputs(); ++j) {
                if (this.compareVarnode(aop.getInput(j), bop.getInput(j), op2)) continue;
                return false;
            }
        }
        return true;
    }
}

