/*-
 * Copyright (C) 2007 Erik Larsson
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.types.hfs;

import org.catacombae.hfsexplorer.Util;
import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.csjc.structelements.DictionaryBuilder;

/** This class was generated by CStructToJavaClass. */
public class ExtDescriptor implements StructElements {
    /*
     * struct ExtDescriptor
     * size: 4 bytes
     * description: 
     * 
     * BP  Size  Type    Identifier   Description                
     * ----------------------------------------------------------
     * 0   2     UInt16  xdrStABN     first allocation block     
     * 2   2     UInt16  xdrNumABlks  number of allocation blocks
     */

    public static final int STRUCTSIZE = 4;

    private final byte[] xdrStABN = new byte[2];
    private final byte[] xdrNumABlks = new byte[2];

    public ExtDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, xdrStABN, 0, 2);
        System.arraycopy(data, offset + 2, xdrNumABlks, 0, 2);
    }

    public ExtDescriptor(short xdrStABN, short xdrNumABlks) {
        System.arraycopy(Util.toByteArrayBE(xdrStABN), 0, this.xdrStABN, 0, 2);
        System.arraycopy(Util.toByteArrayBE(xdrNumABlks), 0, this.xdrNumABlks, 0, 2);

    }

    public static int length() { return STRUCTSIZE; }
    
    /** first allocation block */
    public short getXdrStABN() { return Util.readShortBE(xdrStABN); }
    /** number of allocation blocks */
    public short getXdrNumABlks() { return Util.readShortBE(xdrNumABlks); }
    
    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " xdrStABN: " + Util.unsign(getXdrStABN()));
        ps.println(prefix + " xdrNumABlks: " + Util.unsign(getXdrNumABlks()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ExtDescriptor:");
        printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[STRUCTSIZE];
        byte[] tempData;
        int offset = 0;
        System.arraycopy(xdrStABN, 0, result, offset, xdrStABN.length); offset += xdrStABN.length;
        System.arraycopy(xdrNumABlks, 0, result, offset, xdrNumABlks.length); offset += xdrNumABlks.length;
        return result;
    }

    public Dictionary getStructElements() {
        DictionaryBuilder db = new DictionaryBuilder(ExtDescriptor.class.getName());

        db.addUIntBE("xdrStABN", xdrStABN, "Start block");
        db.addUIntBE("xdrNumABlks", xdrNumABlks, "Number of blocks");

        return db.getResult();
    }
}
