/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.orthogonal;

import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jungrapht.visualization.layout.algorithms.util.DimensionSummaryStatistics;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;

public class OrthogonalLayoutSupport<V, E> {
    Graph<V, E> graph;
    Function<V, Rectangle> vertexDimensionFunction;
    int delta;
    LayoutModel<V> layoutModel;
    double TMin = 0.2;
    Function<V, Point> upperLeftCornerFunction = v -> ((Point)this.layoutModel.apply(v)).add(-this.vertexDimensionFunction.apply(v).width / 2.0, -this.vertexDimensionFunction.apply(v).height / 2.0);

    DimensionSummaryStatistics prepare() {
        DimensionSummaryStatistics dss = new DimensionSummaryStatistics();
        this.graph.vertexSet().forEach(v -> {
            Dimension dimensionPlusDelta = Dimension.of((int)this.vertexDimensionFunction.apply(v).width + this.delta, (int)this.vertexDimensionFunction.apply(v).height + this.delta);
            dss.accept(dimensionPlusDelta);
        });
        return dss;
    }

    int computeElMin(DimensionSummaryStatistics dss) {
        Dimension min = dss.getMin();
        return Math.min(min.width, min.height);
    }

    int computeElMax(DimensionSummaryStatistics dss) {
        Dimension max = dss.getMax();
        return Math.max(max.width, max.height);
    }

    int computeGridCell() {
        int elMin;
        DimensionSummaryStatistics dss = this.prepare();
        int elMax = this.computeElMax(dss);
        if (elMax < 3 * (elMin = this.computeElMin(dss))) {
            return elMax;
        }
        if (elMax <= 15 * elMin) {
            return 3 * elMin / 2;
        }
        return elMax / 30;
    }

    int widthInGrid(V v, int c) {
        return (int)Math.ceil((this.vertexDimensionFunction.apply(v).width + (double)this.delta) / (double)c);
    }

    int heightInGrid(V v, int c) {
        return (int)Math.ceil((this.vertexDimensionFunction.apply(v).height + (double)this.delta) / (double)c);
    }

    int euclideanDistance(V v1, V v2) {
        double w1 = this.vertexDimensionFunction.apply(v1).width;
        double w2 = this.vertexDimensionFunction.apply(v2).width;
        double h1 = this.vertexDimensionFunction.apply(v1).height;
        double h2 = this.vertexDimensionFunction.apply(v2).height;
        Point p1 = ((Point)this.layoutModel.apply(v1)).add(-w1 / 2.0, -h1 / 2.0);
        Point p2 = ((Point)this.layoutModel.apply(v2)).add(-w2 / 2.0, -h2 / 2.0);
        Rectangle r1 = Rectangle.of(p1.x, p1.y, w1, h1);
        Rectangle r2 = Rectangle.of(p2.x, p2.y, w2, h2);
        return this.euclideanDistance(r1, r2);
    }

    int euclideanDistance(Rectangle r1, Rectangle r2) {
        double y2;
        double h;
        double y1;
        double x2;
        double w;
        double x1;
        if (r1.x > r2.x) {
            x1 = r2.x;
            w = r2.width;
            x2 = r1.x;
        } else {
            x1 = r1.x;
            w = r1.width;
            x2 = r2.x;
        }
        if (r1.y > r2.y) {
            y1 = r2.y;
            h = r2.height;
            y2 = r1.y;
        } else {
            y1 = r1.y;
            h = r1.height;
            y2 = r2.y;
        }
        double a = Math.max(0.0, x2 - x1 - w);
        double b = Math.max(0.0, y2 - y1 - h);
        return (int)Math.sqrt(a * a + b * b);
    }

    int xci(V v) {
        return (int)((Point)this.layoutModel.apply(v)).x;
    }

    int yci(V v) {
        return (int)((Point)this.layoutModel.apply(v)).y;
    }

    int distance(V vi, V vj) {
        int c = this.computeGridCell();
        double lhn = Math.abs(this.xci(vi) - this.xci(vj));
        double rhn = Math.abs(this.yci(vi) - this.yci(vj));
        double lhd = this.widthInGrid(vi, c) + this.widthInGrid(vj, c);
        double rhd = this.heightInGrid(vi, c) + this.heightInGrid(vj, c);
        double distance = (double)this.euclideanDistance(vi, vj) + Math.min(lhn / lhd, rhn / rhd) / 20.0;
        return (int)distance;
    }

    int initialGridSize() {
        int vertexCount = this.graph.vertexSet().size();
        return (int)(5.0 * Math.sqrt(vertexCount));
    }

    int iterationCount() {
        int vertexCount = this.graph.vertexSet().size();
        return (int)(90.0 * Math.sqrt(vertexCount));
    }

    double startingTemperature() {
        return 2.0 * Math.sqrt(this.graph.vertexSet().size());
    }

    double k() {
        double T = this.startingTemperature();
        return Math.pow(0.2 / T, 1.0 / (double)this.iterationCount());
    }

    Point neighborsMedianXY(V v) {
        List points = Graphs.neighborSetOf(this.graph, v).stream().map(this.layoutModel::apply).collect(Collectors.toList());
        int count = points.size();
        int medianIndex = (count - 1) / 2;
        points.sort(Comparator.comparingDouble(p -> p.x));
        int xMedian = (int)((Point)points.get((int)medianIndex)).x;
        points.sort(Comparator.comparingDouble(p -> p.y));
        int yMedian = (int)((Point)points.get((int)medianIndex)).y;
        return Point.of(xMedian, yMedian);
    }
}

