/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ViewChange {

    public static interface Listener {
        public void viewChanged();
    }

    public static class SupportImpl
    implements Support {
        private static final Logger log = LoggerFactory.getLogger(SupportImpl.class);
        protected boolean fireEvents = true;
        protected List<Listener> viewChangeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            this.fireEvents = fireEvents;
            if (fireEvents) {
                log.trace("fireViewChanged");
                this.fireViewChanged();
            }
        }

        @Override
        public void addViewChangeListener(Listener l) {
            this.viewChangeListeners.add(l);
        }

        @Override
        public void removeViewChangeListener(Listener l) {
            this.viewChangeListeners.remove(l);
        }

        @Override
        public List<Listener> getViewChangeListeners() {
            return this.viewChangeListeners;
        }

        @Override
        public void fireViewChanged() {
            if (this.fireEvents) {
                for (int i = this.viewChangeListeners.size() - 1; i >= 0; --i) {
                    this.viewChangeListeners.get(i).viewChanged();
                }
            }
        }
    }

    public static interface Support {
        public static Support create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addViewChangeListener(Listener var1);

        public void removeViewChangeListener(Listener var1);

        public List<Listener> getViewChangeListeners();

        public void fireViewChanged();
    }

    public static interface Producer {
        public Support getViewChangeSupport();
    }
}

