/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.grammars.AbstractAssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AbstractAssemblyProduction;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.generic.util.datastruct.TreeSetValuedTreeMap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.MultiValuedMap;

public class AssemblyFirstFollow {
    private final AbstractAssemblyGrammar<?, ?> grammar;
    private final Set<AssemblyNonTerminal> nullable = new TreeSet<AssemblyNonTerminal>();
    private final MultiValuedMap<AssemblyNonTerminal, AssemblyTerminal> first = new TreeSetValuedTreeMap();
    private final MultiValuedMap<AssemblyNonTerminal, AssemblyTerminal> follow = new TreeSetValuedTreeMap();

    public AssemblyFirstFollow(AbstractAssemblyGrammar<?, ?> grammar) {
        this.grammar = grammar;
        this.computeNullable();
        this.computeFirsts();
        this.computeFollows();
    }

    protected void computeNullable() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (AbstractAssemblyProduction prod : this.grammar) {
                if (!this.nullable.containsAll(prod.getRHS().getSymbols())) continue;
                changed |= this.nullable.add((AssemblyNonTerminal)prod.getLHS());
            }
        }
    }

    protected void computeFirsts() {
        boolean changed = true;
        while (changed) {
            changed = false;
            block1: for (AbstractAssemblyProduction prod : this.grammar) {
                for (AssemblySymbol sym : prod.getRHS()) {
                    if (sym instanceof AssemblyNonTerminal) {
                        AssemblyNonTerminal nt = (AssemblyNonTerminal)sym;
                        changed |= this.first.putAll(prod.getLHS(), (Iterable)this.first.get((Object)nt));
                        if (this.nullable.contains(sym)) continue;
                        continue block1;
                    }
                    if (!(sym instanceof AssemblyTerminal)) continue;
                    AssemblyTerminal t = (AssemblyTerminal)sym;
                    changed |= this.first.put(prod.getLHS(), (Object)t);
                    continue block1;
                }
            }
        }
    }

    protected void computeFollows() {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (AbstractAssemblyProduction prod : this.grammar) {
                block2: for (int i = 0; i < prod.getRHS().size(); ++i) {
                    AssemblySymbol px = prod.getRHS().getSymbol(i);
                    if (!(px instanceof AssemblyNonTerminal)) continue;
                    AssemblyNonTerminal X = (AssemblyNonTerminal)px;
                    for (int j = i + 1; j < prod.getRHS().size(); ++j) {
                        AssemblySymbol B = prod.getRHS().getSymbol(j);
                        if (B instanceof AssemblyNonTerminal) {
                            AssemblyNonTerminal nt = (AssemblyNonTerminal)B;
                            changed |= this.follow.putAll((Object)X, (Iterable)this.first.get((Object)nt));
                            if (this.nullable.contains(B)) continue;
                            continue block2;
                        }
                        if (!(B instanceof AssemblyTerminal)) continue;
                        AssemblyTerminal t = (AssemblyTerminal)B;
                        changed |= this.follow.put((Object)X, (Object)t);
                        continue block2;
                    }
                    changed |= this.follow.putAll((Object)X, (Iterable)this.follow.get(prod.getLHS()));
                }
            }
        }
    }

    public Collection<AssemblyNonTerminal> getNullable() {
        return Collections.unmodifiableSet(this.nullable);
    }

    public Collection<AssemblyTerminal> getFirst(AssemblyNonTerminal nt) {
        return Collections.unmodifiableCollection(this.first.get((Object)nt));
    }

    public Collection<AssemblyTerminal> getFollow(AssemblyNonTerminal nt) {
        return Collections.unmodifiableCollection(this.follow.get((Object)nt));
    }

    public void print(PrintStream out) {
        out.print("Nullable: ");
        for (AssemblyNonTerminal nt : this.nullable) {
            out.print(nt + " ");
        }
        out.println();
        out.println("Firsts:");
        for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
            out.print(nt + "\t");
            for (AssemblyTerminal f : this.first.get((Object)nt)) {
                out.print(f + " ");
            }
            out.println();
        }
        out.println("Follows:");
        for (AssemblyNonTerminal nt : this.grammar.nonTerminals()) {
            out.print(nt + "\t");
            for (AssemblyTerminal f : this.follow.get((Object)nt)) {
                out.print(f + " ");
            }
            out.println();
        }
    }
}

