/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SymbolPathParser {
    public static List<String> parse(String name) {
        return SymbolPathParser.parse(name, true);
    }

    public static List<String> parse(String name, boolean ignoreLeaderParens) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Symbol list must contain at least one symbol name!");
        }
        if (SymbolPathParser.skipParsing(name, ignoreLeaderParens)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(name);
            return list;
        }
        return SymbolPathParser.naiveParse(name);
    }

    private static boolean skipParsing(String name, boolean ignoreLeaderParens) {
        if (ignoreLeaderParens && name.startsWith("(")) {
            return true;
        }
        return !name.contains("::");
    }

    private static List<String> naiveParse(String name) {
        int endIndex;
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int templateLevel = 0;
        int parenthesesLevel = 0;
        int startIndex = 0;
        for (i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ':' && i != name.length() - 1 && name.charAt(i + 1) == ':') {
                if (templateLevel != 0 || parenthesesLevel != 0 || (endIndex = i) <= startIndex) continue;
                list.add(name.substring(startIndex, endIndex));
                startIndex = i + 2;
                ++i;
                continue;
            }
            if (name.charAt(i) == '<') {
                ++templateLevel;
                continue;
            }
            if (name.charAt(i) == '>') {
                --templateLevel;
                continue;
            }
            if (name.charAt(i) == '(') {
                ++parenthesesLevel;
                continue;
            }
            if (name.charAt(i) != ')') continue;
            --parenthesesLevel;
        }
        if (templateLevel != 0 || parenthesesLevel != 0) {
            startIndex = 0;
            list = new ArrayList();
            for (i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != ':' || i == name.length() - 1 || name.charAt(i + 1) != ':' || (endIndex = i) <= startIndex) continue;
                list.add(name.substring(startIndex, endIndex));
                startIndex = i + 2;
                ++i;
            }
        }
        list.add(name.substring(startIndex, name.length()));
        return list;
    }
}

