/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.FunctionDefinitionDBAdapterNoTable;
import ghidra.program.database.data.FunctionDefinitionDBAdapterV0;
import ghidra.program.database.data.FunctionDefinitionDBAdapterV1;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionDefinitionDBAdapter {
    static final String FUNCTION_DEF_TABLE_NAME = "Function Definitions";
    static final Schema FUN_DEF_SCHEMA = FunctionDefinitionDBAdapterV1.V1_FUN_DEF_SCHEMA;
    static final int FUNCTION_DEF_NAME_COL = 0;
    static final int FUNCTION_DEF_COMMENT_COL = 1;
    static final int FUNCTION_DEF_CAT_ID_COL = 2;
    static final int FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int FUNCTION_DEF_FLAGS_COL = 4;
    static final int FUNCTION_DEF_SOURCE_ARCHIVE_ID_COL = 5;
    static final int FUNCTION_DEF_SOURCE_DT_ID_COL = 6;
    static final int FUNCTION_DEF_SOURCE_SYNC_TIME_COL = 7;
    static final int FUNCTION_DEF_LAST_CHANGE_TIME_COL = 8;
    static final byte FUNCTION_DEF_VARARG_FLAG = 1;
    static final int GENERIC_CALLING_CONVENTION_FLAG_MASK = 15;
    static final int GENERIC_CALLING_CONVENTION_FLAG_SHIFT = 1;

    FunctionDefinitionDBAdapter() {
    }

    static FunctionDefinitionDBAdapter getAdapter(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        if (openMode == 0) {
            return new FunctionDefinitionDBAdapterV1(handle, true);
        }
        try {
            return new FunctionDefinitionDBAdapterV1(handle, false);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            FunctionDefinitionDBAdapter adapter = FunctionDefinitionDBAdapter.findReadOnlyAdapter(handle);
            if (openMode == 3) {
                adapter = FunctionDefinitionDBAdapter.upgrade(handle, adapter);
            }
            return adapter;
        }
    }

    static FunctionDefinitionDBAdapter findReadOnlyAdapter(DBHandle handle) throws VersionException {
        try {
            return new FunctionDefinitionDBAdapterV0(handle);
        }
        catch (VersionException e) {
            if (!e.isUpgradable()) {
                throw e;
            }
            return new FunctionDefinitionDBAdapterNoTable(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FunctionDefinitionDBAdapter upgrade(DBHandle handle, FunctionDefinitionDBAdapter oldAdapter) throws VersionException, IOException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        FunctionDefinitionDBAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new FunctionDefinitionDBAdapterV1(tmpHandle, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                ((FunctionDefinitionDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            FunctionDefinitionDBAdapterV1 newAdapter = new FunctionDefinitionDBAdapterV1(handle, true);
            it = ((FunctionDefinitionDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                newAdapter.updateRecord(rec, false);
            }
            FunctionDefinitionDBAdapterV1 functionDefinitionDBAdapterV1 = newAdapter;
            return functionDefinitionDBAdapterV1;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract DBRecord createRecord(String var1, String var2, long var3, long var5, boolean var7, GenericCallingConvention var8, long var9, long var11, long var13) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1, boolean var2) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    abstract Field[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract DBRecord getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;
}

