/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.ByteField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.function.CallingConventionDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CallingConventionDBAdapterV0
extends CallingConventionDBAdapter {
    static final String CALLING_CONVENTION_TABLE_NAME = "Calling Conventions";
    static final int V0_CALLING_CONVENTION_NAME_COL = 0;
    static final Schema V0_CALLING_CONVENTION_SCHEMA = new Schema(0, (Field)ByteField.INSTANCE, "ID", new Field[]{StringField.INSTANCE}, new String[]{"Name"});
    private Table callingConventionTable;

    public CallingConventionDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.callingConventionTable = handle.createTable(CALLING_CONVENTION_TABLE_NAME, V0_CALLING_CONVENTION_SCHEMA, new int[0]);
        } else {
            this.callingConventionTable = handle.getTable(CALLING_CONVENTION_TABLE_NAME);
            if (this.callingConventionTable == null) {
                throw new VersionException(true);
            }
            if (this.callingConventionTable.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    public DBRecord createCallingConventionRecord(String name) throws IOException {
        byte key = this.getFirstAvailableKey();
        DBRecord record = V0_CALLING_CONVENTION_SCHEMA.createRecord((Field)new ByteField(key));
        record.setString(0, name);
        this.callingConventionTable.putRecord(record);
        return record;
    }

    private byte getFirstAvailableKey() throws IOException {
        byte key;
        for (key = 2; key < 256; key = (byte)(key + 1)) {
            DBRecord record = this.getCallingConventionRecord(key);
            if (record != null) continue;
            return key;
        }
        if (key >= 256) {
            throw new IOException("No more keys available for calling conventions.");
        }
        return key;
    }

    @Override
    public DBRecord getCallingConventionRecord(byte callingConventionID) throws IOException {
        return this.callingConventionTable.getRecord((Field)new ByteField(callingConventionID));
    }

    @Override
    public DBRecord getCallingConventionRecord(String name) throws IOException {
        for (DBRecord record : this.callingConventionTable) {
            String callingConventionName = record.getString(0);
            if (!callingConventionName.equals(name)) continue;
            return record;
        }
        return null;
    }
}

