/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.program.database.module.ModuleDBAdapterV0;
import ghidra.program.database.module.ModuleDBAdapterV1;
import ghidra.program.database.module.ModuleManager;
import ghidra.program.database.module.ParentChildDBAdapter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class ModuleDBAdapter {
    private static final String MODULE_TABLE_NAME = "Module Table";
    static final int MODULE_NAME_COL = 0;
    static final int MODULE_COMMENTS_COL = 1;
    static final int MODULE_CHILD_COUNT_COL = 2;

    ModuleDBAdapter() {
    }

    static ModuleDBAdapter getAdapter(ModuleManager moduleMgr, int openMode, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        long treeID = moduleMgr.getTreeID();
        DBHandle handle = moduleMgr.getDatabaseHandle();
        try {
            return new ModuleDBAdapterV1(handle, openMode == 0, treeID);
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode != 3) {
                throw e;
            }
            ModuleDBAdapter adapter = ModuleDBAdapter.findReadOnlyAdapter(moduleMgr);
            return ModuleDBAdapter.upgrade(moduleMgr, adapter, monitor);
        }
    }

    private static ModuleDBAdapter upgrade(ModuleManager moduleMgr, ModuleDBAdapter oldAdapter, TaskMonitor monitor) throws IOException, CancelledException {
        long treeID = moduleMgr.getTreeID();
        DBHandle handle = moduleMgr.getDatabaseHandle();
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        ModuleDBAdapterV1 tmpAdapter = null;
        try {
            tmpAdapter = new ModuleDBAdapterV1(tmpHandle, true, treeID);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCanceled();
                DBRecord rec = it.next();
                ((ModuleDBAdapter)tmpAdapter).updateModuleRecord(rec);
            }
            handle.deleteTable(ModuleDBAdapter.getTableName(treeID));
            ModuleDBAdapterV1 newAdapter = new ModuleDBAdapterV1(handle, true, treeID);
            it = ((ModuleDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCanceled();
                DBRecord rec = it.next();
                ((ModuleDBAdapter)newAdapter).updateModuleRecord(rec);
            }
            ModuleDBAdapterV1 moduleDBAdapterV1 = newAdapter;
            return moduleDBAdapterV1;
        }
        catch (VersionException e) {
            throw new RuntimeException(e);
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    private static ModuleDBAdapter findReadOnlyAdapter(ModuleManager moduleMgr) throws VersionException, IOException {
        long treeID = moduleMgr.getTreeID();
        DBHandle handle = moduleMgr.getDatabaseHandle();
        ParentChildDBAdapter parentChildAdapter = moduleMgr.getParentChildAdapter();
        return new ModuleDBAdapterV0(handle, treeID, parentChildAdapter);
    }

    static final String getTableName(long treeID) {
        return MODULE_TABLE_NAME + treeID;
    }

    abstract DBRecord createModuleRecord(long var1, String var3) throws IOException;

    abstract DBRecord getModuleRecord(long var1) throws IOException;

    abstract DBRecord getModuleRecord(String var1) throws IOException;

    abstract RecordIterator getRecords() throws IOException;

    abstract void updateModuleRecord(DBRecord var1) throws IOException;

    abstract boolean removeModuleRecord(long var1) throws IOException;
}

