/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.ByteField;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.database.util.RecordFilter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

class SymbolDatabaseAdapterV3
extends SymbolDatabaseAdapter {
    static final int SYMBOL_VERSION = 3;
    private static final long MIN_ADDRESS_OFFSET = 0L;
    private static final long MAX_ADDRESS_OFFSET = -1L;
    static final Schema V3_SYMBOL_SCHEMA = new Schema(3, "Key", new Field[]{StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE, StringField.INSTANCE, ByteField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE}, new String[]{"Name", "Address", "Namespace", "Symbol Type", "String Data", "Flags", "Locator Hash", "Primary", "Datatype", "Variable Offset"}, new int[]{6, 7, 8, 9});
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV3(DBHandle handle, AddressMap addrMap, boolean create) throws VersionException, IOException {
        this.addrMap = addrMap;
        if (create) {
            this.symbolTable = handle.createTable("Symbols", SYMBOL_SCHEMA, new int[]{1, 0, 2, 6, 7});
        } else {
            this.symbolTable = handle.getTable("Symbols");
            if (this.symbolTable == null) {
                throw new VersionException("Missing Table: Symbols");
            }
            if (this.symbolTable.getSchema().getVersion() != 3) {
                int version = this.symbolTable.getSchema().getVersion();
                if (version < 3) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    DBRecord createSymbol(String name, Address address, long namespaceID, SymbolType symbolType, String stringData, Long dataTypeId, Integer varOffset, SourceType source, boolean isPrimary) throws IOException {
        long nextID = this.symbolTable.getKey();
        if (nextID == 0L) {
            ++nextID;
        }
        return this.createSymbol(nextID, name, address, namespaceID, symbolType, stringData, (byte)source.ordinal(), dataTypeId, varOffset, isPrimary);
    }

    private DBRecord createSymbol(long id, String name, Address address, long namespaceID, SymbolType symbolType, String stringData, byte flags, Long dataTypeId, Integer varOffset, boolean isPrimary) throws IOException {
        long addressKey = this.addrMap.getKey(address, true);
        DBRecord rec = this.symbolTable.getSchema().createRecord(id);
        rec.setString(0, name);
        rec.setLongValue(1, addressKey);
        rec.setLongValue(2, namespaceID);
        rec.setByteValue(3, symbolType.getID());
        rec.setString(4, stringData);
        rec.setByteValue(5, flags);
        rec.setField(6, (Field)SymbolDatabaseAdapterV3.computeLocatorHash(name, namespaceID, addressKey));
        if (isPrimary) {
            rec.setLongValue(7, addressKey);
        }
        if (dataTypeId != null) {
            rec.setLongValue(8, dataTypeId.longValue());
        }
        if (varOffset != null) {
            rec.setIntValue(9, varOffset.intValue());
        }
        this.symbolTable.putRecord(rec);
        return rec;
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        this.symbolTable.deleteRecord(symbolID);
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return false;
        }
        return this.symbolTable.hasRecord((Field)new LongField(key), 1);
    }

    @Override
    Field[] getSymbolIDs(Address addr) throws IOException {
        long key = this.addrMap.getKey(addr, false);
        if (key == -1L && !addr.equals(Address.NO_ADDRESS)) {
            return Field.EMPTY_ARRAY;
        }
        return this.symbolTable.findRecords((Field)new LongField(key), 1);
    }

    @Override
    DBRecord getSymbolRecord(long symbolID) throws IOException {
        return this.symbolTable.getRecord(symbolID);
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, forward));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, startAddr, forward));
    }

    @Override
    void updateSymbolRecord(DBRecord record) throws IOException {
        String name = record.getString(0);
        long namespaceId = record.getLongValue(2);
        long addressKey = record.getLongValue(1);
        record.setField(6, (Field)SymbolDatabaseAdapterV3.computeLocatorHash(name, namespaceId, addressKey));
        this.symbolTable.putRecord(record);
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return this.symbolTable.iterator();
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, start, end, forward));
    }

    @Override
    RecordIterator getSymbols(AddressSetView set, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
    }

    @Override
    protected RecordIterator getPrimarySymbols(AddressSetView set, boolean forward) throws IOException {
        return new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 7, this.addrMap, set, forward));
    }

    @Override
    protected DBRecord getPrimarySymbol(Address address) throws IOException {
        AddressIndexPrimaryKeyIterator it = new AddressIndexPrimaryKeyIterator(this.symbolTable, 7, this.addrMap, address, address, true);
        if (it.hasNext()) {
            return this.symbolTable.getRecord(it.next());
        }
        return null;
    }

    void deleteExternalEntries(Address start, Address end) throws IOException {
        AddressRecordDeleter.deleteRecords(this.symbolTable, 1, this.addrMap, start, end, null);
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        Field[] keys;
        LongField oldKey = new LongField(this.addrMap.getKey(oldAddr, false));
        long newKey = this.addrMap.getKey(newAddr, true);
        for (Field key : keys = this.symbolTable.findRecords((Field)oldKey, 1)) {
            DBRecord rec = this.symbolTable.getRecord(key);
            rec.setLongValue(1, newKey);
            this.symbolTable.putRecord(rec);
        }
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        AnchoredSymbolRecordFilter filter = new AnchoredSymbolRecordFilter();
        AddressRecordDeleter.deleteRecords(this.symbolTable, 1, this.addrMap, startAddr, endAddr, filter);
        return filter.getAddressesForSkippedRecords();
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        LongField field = new LongField(id);
        return this.symbolTable.indexIterator(2, (Field)field, (Field)field, true);
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField field = new StringField(name);
        return this.symbolTable.indexIterator(0, (Field)field, (Field)field, true);
    }

    @Override
    RecordIterator getSymbolsByNameAndNamespace(String name, long id) throws IOException {
        LongField start = SymbolDatabaseAdapterV3.computeLocatorHash(name, id, 0L);
        if (start == null) {
            return EmptyRecordIterator.INSTANCE;
        }
        LongField end = SymbolDatabaseAdapterV3.computeLocatorHash(name, id, -1L);
        RecordIterator it = this.symbolTable.indexIterator(6, (Field)start, (Field)end, true);
        return SymbolDatabaseAdapterV3.getNameAndNamespaceFilterIterator(name, id, it);
    }

    @Override
    DBRecord getSymbolRecord(Address address, String name, long namespaceId) throws IOException {
        long addressKey = this.addrMap.getKey(address, false);
        LongField search = SymbolDatabaseAdapterV3.computeLocatorHash(name, namespaceId, addressKey);
        if (search == null) {
            return null;
        }
        RecordIterator it = this.symbolTable.indexIterator(6, (Field)search, (Field)search, true);
        RecordIterator filtered = SymbolDatabaseAdapterV3.getNameNamespaceAddressFilterIterator(name, namespaceId, addressKey, it);
        if (filtered.hasNext()) {
            return filtered.next();
        }
        return null;
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        if (space.isMemorySpace()) {
            AddressIndexKeyIterator addressKeyIterator = new AddressIndexKeyIterator(this.symbolTable, 1, this.addrMap, space.getMinAddress(), space.getMaxAddress(), false);
            if (addressKeyIterator.hasNext()) {
                return this.addrMap.decodeAddress(addressKeyIterator.next());
            }
        } else {
            LongField val;
            Address addr;
            LongField max = new LongField(this.addrMap.getKey(space.getMaxAddress(), false));
            DBFieldIterator iterator = this.symbolTable.indexFieldIterator(null, (Field)max, false, 1);
            if (iterator.hasPrevious() && space.equals((addr = this.addrMap.decodeAddress((val = (LongField)iterator.previous()).getLongValue())).getAddressSpace())) {
                return addr;
            }
        }
        return null;
    }

    @Override
    Table getTable() {
        return this.symbolTable;
    }

    private class AnchoredSymbolRecordFilter
    implements RecordFilter {
        private Set<Address> set = new HashSet<Address>();

        private AnchoredSymbolRecordFilter() {
        }

        @Override
        public boolean matches(DBRecord record) {
            boolean pinned;
            Address addr = SymbolDatabaseAdapterV3.this.addrMap.decodeAddress(record.getLongValue(1));
            byte flags = record.getByteValue(5);
            boolean bl = pinned = (flags & 4) != 0;
            if (!pinned) {
                return true;
            }
            this.set.add(addr);
            return false;
        }

        Set<Address> getAddressesForSkippedRecords() {
            return this.set;
        }
    }
}

