/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import generic.jar.ResourceFile;
import generic.stl.Pair;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighLanguageValidator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.ContextSetting;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.InjectPayloadSegment;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.PrototypeModelMerged;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BasicCompilerSpec
implements CompilerSpec {
    private final CompilerSpecDescription description;
    private String sourceName;
    private final SleighLanguage language;
    private DataOrganizationImpl dataOrganization;
    private List<ContextSetting> ctxsetting = new ArrayList<ContextSetting>();
    protected PrototypeModel defaultModel;
    protected PrototypeModel evalCurrentModel;
    protected PrototypeModel evalCalledModel;
    protected PrototypeModel[] allmodels;
    protected PrototypeModel[] models;
    private Register stackPointer;
    private AddressSpace stackSpace;
    private AddressSpace stackBaseSpace;
    private AddressSpace joinSpace;
    private boolean stackGrowsNegative = true;
    private boolean reverseJustifyStack = false;
    private Map<String, Pair<AddressSpace, String>> spaceBases;
    private List<Pair<String, Pair<Long, Long>>> extraRanges;
    protected PcodeInjectLibrary pcodeInject;
    private AddressSet globalSet;
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    private Map<String, PrototypeModel> callingConventionMap = null;
    private boolean aggressiveTrim;
    private List<Varnode> preferSplit;
    private AddressSet noHighPtr;
    private AddressSet readOnlySet;
    private Varnode returnAddress;
    private int funcPtrAlign;
    private List<Pair<AddressSpace, Integer>> deadCodeDelay;
    private List<AddressRange> inferPtrBounds;

    public BasicCompilerSpec(CompilerSpecDescription description, SleighLanguage language, InputStream stream) throws XmlParseException, SAXException, IOException, DuplicateNameException {
        this.description = description;
        this.language = language;
        this.buildInjectLibrary();
        this.dataOrganization = DataOrganizationImpl.getDefaultOrganization(language);
        ErrorHandler errHandler = BasicCompilerSpec.getErrorHandler("test");
        XmlPullParser parser = XmlPullParserFactory.create((InputStream)stream, (String)"testpath", (ErrorHandler)errHandler, (boolean)false);
        this.initialize("testpath", parser);
    }

    public BasicCompilerSpec(CompilerSpecDescription description, SleighLanguage language, ResourceFile cspecFile) throws CompilerSpecNotFoundException {
        this.description = description;
        this.language = language;
        this.buildInjectLibrary();
        this.dataOrganization = DataOrganizationImpl.getDefaultOrganization(language);
        Throwable parseException = null;
        ErrorHandler errHandler = BasicCompilerSpec.getErrorHandler(cspecFile.toString());
        try {
            SleighLanguageValidator.validateCspecFile(cspecFile);
            InputStream stream = cspecFile.getInputStream();
            XmlPullParser parser = XmlPullParserFactory.create((InputStream)stream, (String)cspecFile.getAbsolutePath(), (ErrorHandler)errHandler, (boolean)false);
            this.initialize(cspecFile.getAbsolutePath(), parser);
            stream.close();
            if (this.models == null || this.models.length == 0) {
                throw new SAXException("No prototype models defined");
            }
        }
        catch (SleighException e) {
            parseException = e;
            Throwable cause = e.getCause();
            if (cause != null && (cause instanceof SAXException || cause instanceof IOException)) {
                parseException = (Exception)cause;
            }
        }
        catch (DuplicateNameException | XmlParseException | IOException | SAXException e) {
            parseException = e;
        }
        if (parseException != null) {
            throw new CompilerSpecNotFoundException(language.getLanguageID(), description.getCompilerSpecID(), cspecFile.getName(), parseException);
        }
    }

    public BasicCompilerSpec(BasicCompilerSpec op2) {
        this.language = op2.language;
        this.description = op2.description;
        this.callingConventionMap = op2.callingConventionMap;
        this.ctxsetting = op2.ctxsetting;
        this.dataOrganization = op2.dataOrganization;
        this.evalCurrentModel = op2.evalCurrentModel;
        this.evalCalledModel = op2.evalCalledModel;
        this.defaultModel = op2.defaultModel;
        this.allmodels = op2.allmodels;
        this.globalSet = op2.globalSet;
        this.joinSpace = op2.joinSpace;
        this.models = op2.models;
        this.pcodeInject = op2.pcodeInject.clone();
        this.properties = op2.properties;
        this.reverseJustifyStack = op2.reverseJustifyStack;
        this.sourceName = op2.sourceName;
        this.spaceBases = op2.spaceBases;
        this.extraRanges = op2.extraRanges;
        this.stackBaseSpace = op2.stackBaseSpace;
        this.stackGrowsNegative = op2.stackGrowsNegative;
        this.stackPointer = op2.stackPointer;
        this.stackSpace = op2.stackSpace;
        this.aggressiveTrim = op2.aggressiveTrim;
        this.preferSplit = op2.preferSplit;
        this.noHighPtr = op2.noHighPtr;
        this.readOnlySet = op2.readOnlySet;
        this.returnAddress = op2.returnAddress;
        this.funcPtrAlign = op2.funcPtrAlign;
        this.deadCodeDelay = op2.deadCodeDelay;
        this.inferPtrBounds = op2.inferPtrBounds;
    }

    protected static ErrorHandler getErrorHandler(final String docTitle) {
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)this, (Object)("Warning parsing '" + docTitle + "'"), (Throwable)exception);
            }
        };
        return errHandler;
    }

    private void initialize(String srcName, XmlPullParser parser) throws XmlParseException, DuplicateNameException {
        this.sourceName = srcName;
        this.spaceBases = null;
        this.extraRanges = null;
        this.globalSet = new AddressSet();
        this.preferSplit = null;
        this.noHighPtr = null;
        this.readOnlySet = null;
        this.defaultModel = null;
        this.allmodels = null;
        this.models = null;
        this.stackPointer = null;
        this.aggressiveTrim = false;
        this.returnAddress = null;
        this.funcPtrAlign = 0;
        this.deadCodeDelay = null;
        this.inferPtrBounds = null;
        this.restoreXml(parser);
    }

    private void buildInjectLibrary() {
        String classname = this.language.getProperty("pcodeInjectLibraryClass");
        if (classname == null) {
            this.pcodeInject = new PcodeInjectLibrary(this.language);
        } else {
            try {
                Class<?> c = Class.forName(classname);
                if (!PcodeInjectLibrary.class.isAssignableFrom(c)) {
                    Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid pcodeInjectLibraryClass"));
                    throw new RuntimeException(classname + " does not implement interface " + PcodeInjectLibrary.class.getName());
                }
                Class<?> injectLibraryClass = c;
                Constructor<?> constructor = injectLibraryClass.getConstructor(SleighLanguage.class);
                this.pcodeInject = (PcodeInjectLibrary)constructor.newInstance(this.language);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid pcodeInjectLibraryClass"));
                throw new RuntimeException("Failed to instantiate " + classname + " for language " + this.language.getLanguageID(), e);
            }
        }
        List<InjectPayloadSleigh> additionalInject = this.language.getAdditionalInject();
        if (additionalInject != null) {
            for (InjectPayloadSleigh payload : additionalInject) {
                this.pcodeInject.registerInject(payload);
            }
        }
    }

    @Override
    public void applyContextSettings(DefaultProgramContext programContext) {
        for (ContextSetting cs : this.ctxsetting) {
            RegisterValue registerValue = new RegisterValue(cs.getRegister(), cs.getValue());
            programContext.setDefaultValue(registerValue, cs.getStartAddress(), cs.getEndAddress());
        }
    }

    @Override
    public CompilerSpecID getCompilerSpecID() {
        return this.description.getCompilerSpecID();
    }

    @Override
    public boolean doesCDataTypeConversions() {
        return true;
    }

    void addContextSetting(Register reg, BigInteger value, Address begad, Address endad) {
        this.ctxsetting.add(new ContextSetting(reg, value, begad, endad));
    }

    @Override
    public PrototypeModel[] getCallingConventions() {
        return this.models;
    }

    @Override
    public PrototypeModel getCallingConvention(String name) {
        return this.callingConventionMap.get(name);
    }

    @Override
    public PrototypeModel[] getAllModels() {
        return this.allmodels;
    }

    @Override
    public PrototypeModel getDefaultCallingConvention() {
        return this.defaultModel;
    }

    @Override
    public DecompilerLanguage getDecompilerOutputLanguage() {
        return DecompilerLanguage.C_LANGUAGE;
    }

    @Override
    public PrototypeModel getPrototypeEvaluationModel(CompilerSpec.EvaluationModelType modelType) {
        switch (modelType) {
            case EVAL_CURRENT: {
                return this.evalCurrentModel;
            }
            case EVAL_CALLED: {
                return this.evalCalledModel;
            }
        }
        return this.defaultModel;
    }

    @Override
    public Register getStackPointer() {
        return this.stackPointer;
    }

    @Override
    public boolean isStackRightJustified() {
        return this.language.isBigEndian() && !this.reverseJustifyStack || !this.language.isBigEndian() && this.reverseJustifyStack;
    }

    @Override
    public AddressSpace getStackSpace() {
        return this.stackSpace;
    }

    @Override
    public AddressSpace getStackBaseSpace() {
        return this.stackBaseSpace;
    }

    @Override
    public boolean stackGrowsNegative() {
        return this.stackGrowsNegative;
    }

    @Override
    public boolean isGlobal(Address addr) {
        AddressSpace space = addr.getAddressSpace();
        if (space.isOverlaySpace()) {
            addr = ((OverlayAddressSpace)space).translateAddress(addr, true);
        }
        return this.globalSet.contains(addr);
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public CompilerSpecDescription getCompilerSpecDescription() {
        return this.description;
    }

    @Override
    public AddressSpace getAddressSpace(String spaceName) {
        AddressSpace space;
        if ("stack".equals(spaceName)) {
            space = this.stackSpace;
        } else if ("join".equals(spaceName)) {
            if (this.joinSpace == null) {
                this.joinSpace = new GenericAddressSpace("join", 64, 6, 10);
            }
            space = this.joinSpace;
        } else {
            space = this.language.getAddressFactory().getAddressSpace(spaceName);
        }
        if (spaceName.equals("OTHER")) {
            space = AddressSpace.OTHER_SPACE;
        }
        if (space == null) {
            throw new SleighException("Unknown address space: " + spaceName);
        }
        return space;
    }

    private void buildModelArrays(List<PrototypeModel> modelList, String putativeDefaultName) throws XmlParseException {
        if (putativeDefaultName == null) {
            throw new XmlParseException("Compiler Spec " + this.description.getCompilerSpecName() + " does not provide a default prototype");
        }
        int fullcount = 0;
        int resolvecount = 0;
        boolean foundDefault = false;
        for (PrototypeModel model : modelList) {
            ++fullcount;
            if (model.isMerged()) {
                ++resolvecount;
                continue;
            }
            if (!putativeDefaultName.equals(model.getName())) continue;
            foundDefault = true;
        }
        if (!foundDefault) {
            throw new XmlParseException("Could not find default model " + putativeDefaultName + "for Compiler Spec " + this.description.getCompilerSpecName());
        }
        this.models = new PrototypeModel[fullcount - resolvecount];
        this.allmodels = new PrototypeModel[fullcount];
        int i = 0;
        int j = 0;
        for (PrototypeModel model : modelList) {
            if (model.isMerged()) {
                this.allmodels[fullcount - resolvecount + j] = model;
                ++j;
                continue;
            }
            this.models[i] = model;
            this.allmodels[i] = model;
            ++i;
        }
    }

    protected String modelXrefs(List<PrototypeModel> modelList, String defaultName, String evalCurrent, String evalCalled) throws XmlParseException {
        String foundDuplicate = null;
        this.buildModelArrays(modelList, defaultName);
        this.callingConventionMap = new HashMap<String, PrototypeModel>();
        for (PrototypeModel model : this.models) {
            PrototypeModel previous;
            String name = model.getName();
            if (name == null || (previous = this.callingConventionMap.put(name, model)) == null) continue;
            foundDuplicate = name;
        }
        this.evalCurrentModel = this.defaultModel = this.callingConventionMap.get(defaultName);
        this.evalCalledModel = this.defaultModel;
        for (PrototypeModel evalmodel : this.allmodels) {
            if (evalCurrent != null && evalmodel.getName().equals(evalCurrent)) {
                this.evalCurrentModel = evalmodel;
            }
            if (evalCalled == null || !evalmodel.getName().equals(evalCalled)) continue;
            this.evalCalledModel = evalmodel;
        }
        return foundDuplicate;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_COMPILER_SPEC);
        this.encodeProperties(encoder);
        this.dataOrganization.encode(encoder);
        ContextSetting.encodeContextData(encoder, this.ctxsetting);
        if (this.aggressiveTrim) {
            encoder.openElement(ElementId.ELEM_AGGRESSIVETRIM);
            encoder.writeBool(AttributeId.ATTRIB_SIGNEXT, this.aggressiveTrim);
            encoder.closeElement(ElementId.ELEM_AGGRESSIVETRIM);
        }
        if (this.stackPointer != null) {
            encoder.openElement(ElementId.ELEM_STACKPOINTER);
            encoder.writeString(AttributeId.ATTRIB_REGISTER, this.stackPointer.getName());
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, this.stackBaseSpace);
            if (this.reverseJustifyStack) {
                encoder.writeBool(AttributeId.ATTRIB_REVERSEJUSTIFY, this.reverseJustifyStack);
            }
            if (!this.stackGrowsNegative) {
                encoder.writeString(AttributeId.ATTRIB_GROWTH, "positive");
            }
            encoder.closeElement(ElementId.ELEM_STACKPOINTER);
        }
        this.encodeSpaceBases(encoder);
        this.encodeMemoryTags(encoder, ElementId.ELEM_GLOBAL, this.globalSet);
        this.encodeReturnAddress(encoder);
        this.pcodeInject.encodeCompilerSpec(encoder);
        if (this.defaultModel != null) {
            encoder.openElement(ElementId.ELEM_DEFAULT_PROTO);
            this.defaultModel.encode(encoder, this.pcodeInject);
            encoder.closeElement(ElementId.ELEM_DEFAULT_PROTO);
        }
        for (PrototypeModel model : this.allmodels) {
            if (model == this.defaultModel) continue;
            model.encode(encoder, this.pcodeInject);
        }
        if (this.evalCurrentModel != null && this.evalCurrentModel != this.defaultModel) {
            encoder.openElement(ElementId.ELEM_EVAL_CURRENT_PROTOTYPE);
            encoder.writeString(AttributeId.ATTRIB_NAME, this.evalCurrentModel.name);
            encoder.closeElement(ElementId.ELEM_EVAL_CURRENT_PROTOTYPE);
        }
        if (this.evalCalledModel != null && this.evalCalledModel != this.defaultModel) {
            encoder.openElement(ElementId.ELEM_EVAL_CALLED_PROTOTYPE);
            encoder.writeString(AttributeId.ATTRIB_NAME, this.evalCalledModel.name);
            encoder.closeElement(ElementId.ELEM_EVAL_CALLED_PROTOTYPE);
        }
        this.encodePreferSplit(encoder);
        this.encodeMemoryTags(encoder, ElementId.ELEM_NOHIGHPTR, this.noHighPtr);
        this.encodeMemoryTags(encoder, ElementId.ELEM_READONLY, this.readOnlySet);
        if (this.funcPtrAlign != 0) {
            encoder.openElement(ElementId.ELEM_FUNCPTR);
            encoder.writeSignedInteger(AttributeId.ATTRIB_ALIGN, this.funcPtrAlign);
            encoder.closeElement(ElementId.ELEM_FUNCPTR);
        }
        this.encodeDeadCodeDelay(encoder);
        this.encodeInferPtrBounds(encoder);
        encoder.closeElement(ElementId.ELEM_COMPILER_SPEC);
    }

    private void restoreXml(XmlPullParser parser) throws XmlParseException, DuplicateNameException {
        String dupName;
        ArrayList<PrototypeModel> modelList = new ArrayList<PrototypeModel>();
        boolean seenDefault = false;
        boolean seenThisCall = false;
        String defaultName = null;
        String evalCurrentPrototype = null;
        String evalCalledPrototype = null;
        parser.start(new String[]{"compiler_spec"});
        while (parser.peek().isStart()) {
            XmlElement el;
            PrototypeModel model;
            String nm;
            String name = parser.peek().getName();
            if (name.equals("properties")) {
                this.restoreProperties(parser);
                continue;
            }
            if (name.equals("data_organization")) {
                this.dataOrganization.restoreXml(parser);
                continue;
            }
            if (name.equals("callfixup")) {
                nm = parser.peek().getAttribute("name");
                this.pcodeInject.restoreXmlInject(this.sourceName, nm, 1, parser);
                continue;
            }
            if (name.equals("callotherfixup")) {
                nm = parser.peek().getAttribute("targetop");
                this.pcodeInject.restoreXmlInject(this.sourceName, nm, 2, parser);
                continue;
            }
            if (name.equals("context_data")) {
                ContextSetting.parseContextData(this.ctxsetting, parser, this);
                continue;
            }
            if (name.equals("stackpointer")) {
                this.setStackPointer(parser);
                continue;
            }
            if (name.equals("spacebase")) {
                this.restoreSpaceBase(parser);
                continue;
            }
            if (name.equals("global")) {
                this.restoreMemoryTags("global", parser, this.globalSet);
                continue;
            }
            if (name.equals("default_proto")) {
                parser.start(new String[0]);
                model = this.addPrototypeModel(modelList, parser);
                parser.end();
                if (!seenDefault) {
                    defaultName = model.name;
                    seenDefault = true;
                }
                if (!model.getName().equals("__thiscall")) continue;
                seenThisCall = true;
                continue;
            }
            if (name.equals("prototype")) {
                model = this.addPrototypeModel(modelList, parser);
                if (defaultName == null) {
                    defaultName = model.name;
                }
                if (!model.getName().equals("__thiscall")) continue;
                seenThisCall = true;
                continue;
            }
            if (name.equals("modelalias")) {
                el = parser.start(new String[0]);
                String aliasName = el.getAttribute("name");
                String parentName = el.getAttribute("parent");
                parser.end(el);
                this.createModelAlias(aliasName, parentName, modelList);
                if (!aliasName.equals("__thiscall")) continue;
                seenThisCall = true;
                continue;
            }
            if (name.equals("resolveprototype")) {
                this.addPrototypeModel(modelList, parser);
                continue;
            }
            if (name.equals("eval_current_prototype")) {
                evalCurrentPrototype = parser.start(new String[0]).getAttribute("name");
                parser.end();
                continue;
            }
            if (name.equals("eval_called_prototype")) {
                evalCalledPrototype = parser.start(new String[0]).getAttribute("name");
                parser.end();
                continue;
            }
            if (name.equals("segmentop")) {
                String source = "cspec: " + this.language.getLanguageID().getIdAsString();
                InjectPayloadSegment payload = new InjectPayloadSegment(source);
                ((InjectPayloadSleigh)payload).restoreXml(parser, this.language);
                this.pcodeInject.registerInject(payload);
                continue;
            }
            if (name.equals("aggressivetrim")) {
                el = parser.start(new String[0]);
                this.aggressiveTrim = SpecXmlUtils.decodeBoolean((String)el.getAttribute("signext"));
                parser.end(el);
                continue;
            }
            if (name.equals("prefersplit")) {
                this.restorePreferSplit(parser);
                continue;
            }
            if (name.equals("nohighptr")) {
                this.noHighPtr = new AddressSet();
                this.restoreMemoryTags("nohighptr", parser, this.noHighPtr);
                continue;
            }
            if (name.equals("readonly")) {
                this.readOnlySet = new AddressSet();
                this.restoreMemoryTags("readonly", parser, this.readOnlySet);
                continue;
            }
            if (name.equals("returnaddress")) {
                this.restoreReturnAddress(parser);
                continue;
            }
            if (name.equals("funcptr")) {
                XmlElement subel = parser.start(new String[0]);
                this.funcPtrAlign = SpecXmlUtils.decodeInt((String)subel.getAttribute("align"));
                parser.end(subel);
                continue;
            }
            if (name.equals("deadcodedelay")) {
                this.restoreDeadCodeDelay(parser);
                continue;
            }
            if (name.equals("inferptrbounds")) {
                this.restoreInferPtrBounds(parser);
                continue;
            }
            el = parser.start(new String[0]);
            parser.discardSubTree(el);
        }
        parser.end();
        if (this.stackPointer == null) {
            this.stackSpace = new GenericAddressSpace("stack", this.language.getDefaultSpace().getSize(), this.language.getDefaultSpace().getAddressableUnitSize(), 5, 0);
        }
        if (!seenThisCall) {
            this.createModelAlias("__thiscall", defaultName, modelList);
        }
        if ((dupName = this.modelXrefs(modelList, defaultName, evalCurrentPrototype, evalCalledPrototype)) != null) {
            throw new DuplicateNameException("Multiple prototype models with the name: " + dupName);
        }
    }

    private void encodeProperties(Encoder encoder) throws IOException {
        if (this.properties.isEmpty()) {
            return;
        }
        encoder.openElement(ElementId.ELEM_PROPERTIES);
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            encoder.openElement(ElementId.ELEM_PROPERTY);
            encoder.writeString(AttributeId.ATTRIB_KEY, property.getKey());
            encoder.writeString(AttributeId.ATTRIB_VALUE, property.getValue());
            encoder.closeElement(ElementId.ELEM_PROPERTY);
        }
        encoder.closeElement(ElementId.ELEM_PROPERTIES);
    }

    private void restoreProperties(XmlPullParser parser) {
        parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement el = parser.start(new String[0]);
            if (el.getName().equals("property")) {
                String key = el.getAttribute("key");
                String value = el.getAttribute("value");
                this.properties.put(key, value);
                parser.end(el);
                continue;
            }
            parser.discardSubTree(el);
        }
        parser.end();
    }

    private void encodeSpaceBases(Encoder encoder) throws IOException {
        if (this.spaceBases == null) {
            return;
        }
        for (Map.Entry<String, Pair<AddressSpace, String>> entry : this.spaceBases.entrySet()) {
            encoder.openElement(ElementId.ELEM_SPACEBASE);
            encoder.writeString(AttributeId.ATTRIB_NAME, entry.getKey());
            encoder.writeString(AttributeId.ATTRIB_REGISTER, (String)entry.getValue().second);
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, (AddressSpace)entry.getValue().first);
            encoder.closeElement(ElementId.ELEM_SPACEBASE);
        }
    }

    private void restoreSpaceBase(XmlPullParser parser) {
        if (this.spaceBases == null) {
            this.spaceBases = new TreeMap<String, Pair<AddressSpace, String>>();
        }
        XmlElement el = parser.start(new String[0]);
        String name = el.getAttribute("name");
        Register reg = this.language.getRegister(el.getAttribute("register"));
        if (reg == null) {
            throw new SleighException("Unknown register: " + name);
        }
        String spaceName = el.getAttribute("space");
        if (this.language.getAddressFactory().getAddressSpace(name) != null || this.spaceBases.containsKey(name)) {
            throw new SleighException("Duplicate space name: " + name);
        }
        AddressSpace space = this.getAddressSpace(spaceName);
        this.spaceBases.put(name, (Pair<AddressSpace, String>)new Pair((Object)space, (Object)reg.getName()));
        parser.end(el);
    }

    private void encodeReturnAddress(Encoder encoder) throws IOException {
        if (this.returnAddress == null) {
            return;
        }
        encoder.openElement(ElementId.ELEM_RETURNADDRESS);
        encoder.openElement(ElementId.ELEM_VARNODE);
        AddressXML.encodeAttributes(encoder, this.returnAddress.getAddress(), this.returnAddress.getSize());
        encoder.closeElement(ElementId.ELEM_VARNODE);
        encoder.closeElement(ElementId.ELEM_RETURNADDRESS);
    }

    private void restoreReturnAddress(XmlPullParser parser) throws XmlParseException {
        XmlElement el = parser.start(new String[0]);
        XmlElement subel = parser.start(new String[0]);
        AddressXML addrSized = AddressXML.restoreXml(subel, this);
        this.returnAddress = addrSized.getVarnode();
        parser.end(subel);
        parser.end(el);
    }

    private void readExtraRange(XmlElement el, String spcName, String tagName) {
        AddressSpace addressSpace = (AddressSpace)this.spaceBases.get((Object)spcName).first;
        long first = 0L;
        long last = -1L;
        boolean seenLast = false;
        String attrvalue = el.getAttribute("first");
        if (attrvalue != null) {
            first = SpecXmlUtils.decodeLong((String)attrvalue);
        }
        if ((attrvalue = el.getAttribute("last")) != null) {
            last = SpecXmlUtils.decodeLong((String)attrvalue);
            seenLast = true;
        }
        if (!seenLast) {
            last = addressSpace.getMaxAddress().getUnsignedOffset();
        }
        if (this.extraRanges == null) {
            this.extraRanges = new ArrayList<Pair<String, Pair<Long, Long>>>();
        }
        this.extraRanges.add((Pair<String, Pair<Long, Long>>)new Pair((Object)(tagName + "_" + spcName), (Object)new Pair((Object)first, (Object)last)));
    }

    private void encodeExtraRanges(Encoder encoder, ElementId tag) throws IOException {
        if (this.extraRanges == null) {
            return;
        }
        for (Pair<String, Pair<Long, Long>> entry : this.extraRanges) {
            if (!((String)entry.first).startsWith(tag.name())) continue;
            String spcName = ((String)entry.first).substring(((String)entry.first).indexOf(95) + 1);
            long first = (Long)((Pair)entry.second).first;
            long last = (Long)((Pair)entry.second).second;
            boolean useFirst = first != 0L;
            boolean useLast = last != -1L;
            encoder.openElement(ElementId.ELEM_RANGE);
            encoder.writeString(AttributeId.ATTRIB_SPACE, spcName);
            if (useFirst) {
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_FIRST, first);
            }
            if (useLast) {
                encoder.writeUnsignedInteger(AttributeId.ATTRIB_LAST, last);
            }
            encoder.closeElement(ElementId.ELEM_RANGE);
        }
    }

    private void encodeMemoryTags(Encoder encoder, ElementId tag, AddressSet addrSet) throws IOException {
        if (addrSet == null) {
            return;
        }
        encoder.openElement(tag);
        AddressRangeIterator iter = addrSet.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            encoder.openElement(ElementId.ELEM_RANGE);
            AddressXML.encodeAttributes(encoder, range.getMinAddress(), range.getMaxAddress());
            encoder.closeElement(ElementId.ELEM_RANGE);
        }
        this.encodeExtraRanges(encoder, tag);
        encoder.closeElement(tag);
    }

    private void restoreMemoryTags(String tagName, XmlPullParser parser, AddressSet addrSet) throws XmlParseException {
        parser.start(new String[]{tagName});
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            String name = subel.getName();
            if (name.equals("range") || name.equals("register")) {
                String spcName = subel.getAttribute("space");
                if (spcName != null && this.spaceBases != null && this.spaceBases.containsKey(spcName)) {
                    this.readExtraRange(subel, spcName, tagName);
                } else {
                    AddressXML range = AddressXML.restoreRangeXml(subel, this);
                    Address firstAddress = range.getFirstAddress();
                    Address lastAddress = range.getLastAddress();
                    AddressRangeImpl addrRange = new AddressRangeImpl(firstAddress, lastAddress);
                    addrSet.add(addrRange);
                }
            } else {
                throw new XmlParseException("Unexpected <" + tagName + "> sub-tag: " + name);
            }
            parser.end(subel);
        }
        parser.end();
    }

    private void restorePreferSplit(XmlPullParser parser) throws XmlParseException {
        XmlElement el = parser.start(new String[0]);
        String styleString = el.getAttribute("style");
        if (styleString == null || !styleString.equals("inhalf")) {
            throw new XmlParseException("Unknown prefersplit strategy");
        }
        this.preferSplit = new ArrayList<Varnode>();
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            AddressXML addrSized = AddressXML.restoreXml(subel, this);
            parser.end(subel);
            this.preferSplit.add(addrSized.getVarnode());
        }
        parser.end(el);
    }

    private void encodePreferSplit(Encoder encoder) throws IOException {
        if (this.preferSplit == null || this.preferSplit.isEmpty()) {
            return;
        }
        encoder.openElement(ElementId.ELEM_PREFERSPLIT);
        encoder.writeString(AttributeId.ATTRIB_STYLE, "inhalf");
        for (Varnode varnode : this.preferSplit) {
            encoder.openElement(ElementId.ELEM_VARNODE);
            AddressXML.encodeAttributes(encoder, varnode.getAddress(), varnode.getSize());
            encoder.closeElement(ElementId.ELEM_VARNODE);
        }
        encoder.closeElement(ElementId.ELEM_PREFERSPLIT);
    }

    private void restoreDeadCodeDelay(XmlPullParser parser) {
        if (this.deadCodeDelay == null) {
            this.deadCodeDelay = new ArrayList<Pair<AddressSpace, Integer>>();
        }
        XmlElement el = parser.start(new String[0]);
        AddressSpace space = this.getAddressSpace(el.getAttribute("space"));
        int delay = SpecXmlUtils.decodeInt((String)el.getAttribute("delay"));
        this.deadCodeDelay.add((Pair<AddressSpace, Integer>)new Pair((Object)space, (Object)delay));
        parser.end(el);
    }

    private void encodeDeadCodeDelay(Encoder encoder) throws IOException {
        if (this.deadCodeDelay == null) {
            return;
        }
        for (Pair<AddressSpace, Integer> pair : this.deadCodeDelay) {
            encoder.openElement(ElementId.ELEM_DEADCODEDELAY);
            encoder.writeSpace(AttributeId.ATTRIB_SPACE, (AddressSpace)pair.first);
            encoder.writeSignedInteger(AttributeId.ATTRIB_DELAY, ((Integer)pair.second).intValue());
            encoder.closeElement(ElementId.ELEM_DEADCODEDELAY);
        }
    }

    private void restoreInferPtrBounds(XmlPullParser parser) throws XmlParseException {
        if (this.inferPtrBounds == null) {
            this.inferPtrBounds = new ArrayList<AddressRange>();
        }
        XmlElement el = parser.start(new String[0]);
        while (parser.peek().isStart()) {
            XmlElement subel = parser.start(new String[0]);
            AddressXML addrSized = AddressXML.restoreRangeXml(subel, this);
            AddressRangeImpl addrRange = new AddressRangeImpl(addrSized.getFirstAddress(), addrSized.getLastAddress());
            this.inferPtrBounds.add(addrRange);
            parser.end(subel);
        }
        parser.end(el);
    }

    private void encodeInferPtrBounds(Encoder encoder) throws IOException {
        if (this.inferPtrBounds == null) {
            return;
        }
        encoder.openElement(ElementId.ELEM_INFERPTRBOUNDS);
        for (AddressRange addrRange : this.inferPtrBounds) {
            encoder.openElement(ElementId.ELEM_RANGE);
            AddressXML.encodeAttributes(encoder, addrRange.getMinAddress(), addrRange.getMaxAddress());
            encoder.closeElement(ElementId.ELEM_RANGE);
        }
        encoder.closeElement(ElementId.ELEM_INFERPTRBOUNDS);
    }

    private void setStackPointer(XmlPullParser parser) {
        String growth;
        XmlElement el = parser.start(new String[0]);
        String regName = el.getAttribute("register");
        this.stackPointer = this.language.getRegister(regName);
        if (this.stackPointer == null) {
            throw new SleighException("Unknown register: " + regName);
        }
        String baseSpaceName = el.getAttribute("space");
        this.stackBaseSpace = this.getAddressSpace(baseSpaceName);
        if (this.stackBaseSpace == null) {
            throw new SleighException("Undefined base stack space: " + baseSpaceName);
        }
        int stackSpaceSize = Math.min(this.stackPointer.getBitLength(), this.stackBaseSpace.getSize());
        this.stackSpace = new GenericAddressSpace("stack", stackSpaceSize, this.stackBaseSpace.getAddressableUnitSize(), 5, 0);
        String reverseJustifyStr = el.getAttribute("reversejustify");
        if (reverseJustifyStr != null) {
            this.reverseJustifyStack = this.getBooleanValue(reverseJustifyStr);
        }
        if ((growth = el.getAttribute("growth")) == null || growth.equals("negative")) {
            this.stackGrowsNegative = true;
        } else if (growth.equals("positive")) {
            this.stackGrowsNegative = false;
        } else {
            throw new SleighException("Bad stack growth " + growth + " should be 'positive' or 'negative'");
        }
        parser.end(el);
    }

    private boolean getBooleanValue(String booleanStr) {
        return "1".equals(booleanStr) || "true".equalsIgnoreCase(booleanStr);
    }

    private void createModelAlias(String aliasName, String parentName, List<PrototypeModel> modelList) throws XmlParseException {
        PrototypeModel parentModel = null;
        for (PrototypeModel model : modelList) {
            if (!parentName.equals(model.getName())) continue;
            parentModel = model;
            break;
        }
        if (parentModel == null) {
            throw new XmlParseException("Parent for model alias does not exist: " + parentName);
        }
        if (parentModel.isMerged()) {
            throw new XmlParseException("Cannot make alias of merged model: " + parentName);
        }
        if (parentModel.getAliasParent() != null) {
            throw new XmlParseException("Cannot make alias of an alias: " + parentName);
        }
        PrototypeModel newModel = new PrototypeModel(aliasName, parentModel);
        modelList.add(newModel);
    }

    private PrototypeModel addPrototypeModel(List<PrototypeModel> modelList, XmlPullParser parser) throws XmlParseException {
        PrototypeModel model;
        if (parser.peek().getName().equals("resolveprototype")) {
            PrototypeModelMerged mergemodel = new PrototypeModelMerged();
            mergemodel.restoreXml(parser, modelList);
            model = mergemodel;
        } else {
            model = new PrototypeModel();
            model.restoreXml(parser, this);
        }
        modelList.add(model);
        return model;
    }

    @Override
    public DataOrganization getDataOrganization() {
        return this.dataOrganization;
    }

    @Override
    public PrototypeModel matchConvention(GenericCallingConvention genericCallingConvention) {
        if (genericCallingConvention == GenericCallingConvention.unknown) {
            return this.defaultModel;
        }
        for (PrototypeModel model : this.models) {
            if (model.getGenericCallingConvention() != genericCallingConvention) continue;
            return model;
        }
        return this.defaultModel;
    }

    @Override
    public PrototypeModel findBestCallingConvention(Parameter[] params) {
        if (!this.evalCurrentModel.isMerged()) {
            return this.evalCurrentModel;
        }
        return ((PrototypeModelMerged)this.evalCurrentModel).selectModel(params);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String getProperty(String key, String defaultString) {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return defaultString;
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultBoolean) {
        if (this.properties.containsKey(key)) {
            return Boolean.parseBoolean(this.properties.get(key));
        }
        return defaultBoolean;
    }

    @Override
    public int getPropertyAsInt(String key, int defaultInt) {
        if (this.properties.containsKey(key)) {
            return Integer.parseInt(this.properties.get(key));
        }
        return defaultInt;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public PcodeInjectLibrary getPcodeInjectLibrary() {
        return this.pcodeInject;
    }

    protected void removeProgramMechanismPayloads(Collection<PrototypeModel> modelList) {
        for (PrototypeModel model : modelList) {
            if (!model.hasInjection()) continue;
            this.pcodeInject.removeMechanismPayload(model.getInjectName());
        }
    }

    protected void registerProgramInject(List<InjectPayloadSleigh> injectExtensions) {
        this.pcodeInject.registerProgramInject(injectExtensions);
    }

    protected static void markPrototypeAsExtension(PrototypeModel model) {
        model.isExtension = true;
    }

    @Override
    public boolean isEquivalent(CompilerSpec obj) {
        int i;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicCompilerSpec other = (BasicCompilerSpec)obj;
        if (this.aggressiveTrim != other.aggressiveTrim) {
            return false;
        }
        if (!this.dataOrganization.isEquivalent(other.dataOrganization)) {
            return false;
        }
        if (this.ctxsetting.size() != other.ctxsetting.size()) {
            return false;
        }
        for (i = 0; i < this.ctxsetting.size(); ++i) {
            if (this.ctxsetting.get(i).isEquivalent(other.ctxsetting.get(i))) continue;
            return false;
        }
        if (!SystemUtilities.isEqual(this.deadCodeDelay, other.deadCodeDelay)) {
            return false;
        }
        if (this.defaultModel != null) {
            if (other.defaultModel == null) {
                return false;
            }
            if (!this.defaultModel.name.equals(other.defaultModel.name)) {
                return false;
            }
        } else if (other.defaultModel != null) {
            return false;
        }
        if (this.evalCalledModel != null) {
            if (other.evalCalledModel == null) {
                return false;
            }
            if (!this.evalCalledModel.name.equals(other.evalCalledModel.name)) {
                return false;
            }
        } else if (other.evalCalledModel != null) {
            return false;
        }
        if (this.evalCurrentModel != null) {
            if (other.evalCurrentModel == null) {
                return false;
            }
            if (!this.evalCurrentModel.name.equals(other.evalCurrentModel.name)) {
                return false;
            }
        } else if (other.evalCurrentModel != null) {
            return false;
        }
        if (this.allmodels.length != other.allmodels.length) {
            return false;
        }
        for (i = 0; i < this.allmodels.length; ++i) {
            if (this.allmodels[i].isEquivalent(other.allmodels[i])) continue;
            return false;
        }
        if (!SystemUtilities.isEqual(this.extraRanges, other.extraRanges)) {
            return false;
        }
        if (this.funcPtrAlign != other.funcPtrAlign) {
            return false;
        }
        if (!this.globalSet.equals(other.globalSet)) {
            return false;
        }
        if (!SystemUtilities.isEqual(this.inferPtrBounds, other.inferPtrBounds)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.noHighPtr, (Object)other.noHighPtr)) {
            return false;
        }
        if (!this.pcodeInject.isEquivalent(other.pcodeInject)) {
            return false;
        }
        if (!SystemUtilities.isEqual(this.preferSplit, other.preferSplit)) {
            return false;
        }
        if (!this.properties.equals(other.properties)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.readOnlySet, (Object)other.readOnlySet)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.returnAddress, (Object)other.returnAddress)) {
            return false;
        }
        if (this.reverseJustifyStack != other.reverseJustifyStack) {
            return false;
        }
        if (!SystemUtilities.isEqual(this.spaceBases, other.spaceBases)) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.stackBaseSpace, (Object)other.stackBaseSpace)) {
            return false;
        }
        if (this.stackGrowsNegative != other.stackGrowsNegative) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.stackPointer, (Object)other.stackPointer);
    }
}

