/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.framework.store.LockException;
import ghidra.program.database.IntRangeMap;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.Date;

public interface Program
extends DataTypeManagerDomainObject {
    public static final String ANALYSIS_PROPERTIES = "Analyzers";
    public static final String DISASSEMBLER_PROPERTIES = "Disassembler";
    public static final String PROGRAM_INFO = "Program Information";
    public static final String PROGRAM_SETTINGS = "Program Settings";
    public static final String ANALYZED = "Analyzed";
    public static final String DATE_CREATED = "Date Created";
    public static final String CREATED_WITH_GHIDRA_VERSION = "Created With Ghidra Version";
    public static final String PREFERRED_ROOT_NAMESPACE_CATEGORY_PROPERTY = "Preferred Root Namespace Category";
    public static final String ANALYSIS_START_DATE = "2007-Jan-01";
    public static final String ANALYSIS_START_DATE_FORMAT = "yyyy-MMM-dd";
    public static final Date JANUARY_1_1970 = new Date(0L);
    public static final int MAX_OPERANDS = 16;

    public Listing getListing();

    public AddressMap getAddressMap();

    @Override
    public ProgramBasedDataTypeManager getDataTypeManager();

    public FunctionManager getFunctionManager();

    public ProgramUserData getProgramUserData();

    public SymbolTable getSymbolTable();

    public ExternalManager getExternalManager();

    public EquateTable getEquateTable();

    public Memory getMemory();

    public ReferenceManager getReferenceManager();

    public BookmarkManager getBookmarkManager();

    public int getDefaultPointerSize();

    public String getCompiler();

    public void setCompiler(String var1);

    public CategoryPath getPreferredRootNamespaceCategoryPath();

    public void setPreferredRootNamespaceCategoryPath(String var1);

    public String getExecutablePath();

    public void setExecutablePath(String var1);

    public String getExecutableFormat();

    public void setExecutableFormat(String var1);

    public String getExecutableMD5();

    public void setExecutableMD5(String var1);

    public void setExecutableSHA256(String var1);

    public String getExecutableSHA256();

    public Date getCreationDate();

    public RelocationTable getRelocationTable();

    public Language getLanguage();

    public CompilerSpec getCompilerSpec();

    public LanguageID getLanguageID();

    public PropertyMapManager getUsrPropertyManager();

    public ProgramContext getProgramContext();

    public Address getMinAddress();

    public Address getMaxAddress();

    public ProgramChangeSet getChanges();

    public AddressFactory getAddressFactory();

    public Address[] parseAddress(String var1);

    public Address[] parseAddress(String var1, boolean var2);

    public void invalidate();

    public Register getRegister(String var1);

    public Register getRegister(Address var1);

    public Register[] getRegisters(Address var1);

    public Register getRegister(Address var1, int var2);

    public Register getRegister(Varnode var1);

    public Address getImageBase();

    public void setImageBase(Address var1, boolean var2) throws AddressOverflowException, LockException, IllegalStateException;

    public void restoreImageBase();

    public void setLanguage(Language var1, CompilerSpecID var2, boolean var3, TaskMonitor var4) throws IllegalStateException, IncompatibleLanguageException, LockException;

    public Namespace getGlobalNamespace();

    public AddressSetPropertyMap createAddressSetPropertyMap(String var1) throws DuplicateNameException;

    public IntRangeMap createIntRangeMap(String var1) throws DuplicateNameException;

    public AddressSetPropertyMap getAddressSetPropertyMap(String var1);

    public IntRangeMap getIntRangeMap(String var1);

    public void deleteAddressSetPropertyMap(String var1);

    public void deleteIntRangeMap(String var1);

    public long getUniqueProgramID();
}

