/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.breakpoint;

import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.impl.dbgeng.breakpoint.DebugBreakpointInternal;
import agent.dbgeng.impl.dbgeng.client.DebugClientInternal;
import agent.dbgeng.impl.dbgeng.control.DebugControlInternal;
import agent.dbgeng.jna.dbgeng.WinNTExtra;
import agent.dbgeng.jna.dbgeng.breakpoint.IDebugBreakpoint;
import agent.dbgeng.jna.dbgeng.client.WrapIDebugClient;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.comm.util.BitmaskSet;

public class DebugBreakpointImpl1
implements DebugBreakpointInternal {
    private final DbgEng.OpaqueCleanable cleanable;
    private IDebugBreakpoint jnaBreakpoint;
    private DebugControlInternal control;

    public DebugBreakpointImpl1(IDebugBreakpoint jnaBreakpoint) {
        this.cleanable = DbgEng.releaseWhenPhantom((Object)this, jnaBreakpoint);
        this.jnaBreakpoint = jnaBreakpoint;
    }

    @Override
    public void setControl(DebugControlInternal control) {
        this.control = control;
    }

    @Override
    public void remove() {
        this.control.removeBreakpoint(this.jnaBreakpoint);
        this.jnaBreakpoint = null;
    }

    @Override
    public int getId() {
        WinDef.ULONGByReference pulId = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetId(pulId));
        return pulId.getValue().intValue();
    }

    @Override
    public DebugBreakpoint.BreakFullType getType() {
        WinDef.ULONGByReference pulBreakType = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulProcType = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetType(pulBreakType, pulProcType));
        DebugBreakpoint.BreakType breakType = DebugBreakpoint.BreakType.values()[pulBreakType.getValue().intValue()];
        WinNTExtra.Machine procType = WinNTExtra.Machine.getByNumber(pulProcType.getValue().intValue());
        return new DebugBreakpoint.BreakFullType(breakType, procType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugClient getAdder() {
        PointerByReference pClient = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetAdder(pClient.getPointer()));
        WrapIDebugClient wrap = new WrapIDebugClient(pClient.getValue());
        try {
            DebugClientInternal debugClientInternal = DebugClientInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((WrapIDebugClient)wrap).QueryInterface(arg_0, arg_1));
            return debugClientInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public BitmaskSet<DebugBreakpoint.BreakFlags> getFlags() {
        WinDef.ULONGByReference pulFlags = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetFlags(pulFlags));
        return new BitmaskSet(DebugBreakpoint.BreakFlags.class, pulFlags.getValue().longValue());
    }

    @Override
    public void addFlags(BitmaskSet<DebugBreakpoint.BreakFlags> flags) {
        WinDef.ULONG ulFlags = new WinDef.ULONG(flags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.AddFlags(ulFlags));
    }

    @Override
    public void addFlags(DebugBreakpoint.BreakFlags ... flags) {
        this.addFlags((BitmaskSet<DebugBreakpoint.BreakFlags>)BitmaskSet.of((Enum[])flags));
    }

    @Override
    public void removeFlags(BitmaskSet<DebugBreakpoint.BreakFlags> flags) {
        WinDef.ULONG ulFlags = new WinDef.ULONG(flags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.RemoveFlags(ulFlags));
    }

    @Override
    public void removeFlags(DebugBreakpoint.BreakFlags ... flags) {
        this.removeFlags((BitmaskSet<DebugBreakpoint.BreakFlags>)BitmaskSet.of((Enum[])flags));
    }

    @Override
    public void setFlags(BitmaskSet<DebugBreakpoint.BreakFlags> flags) {
        WinDef.ULONG ulFlags = new WinDef.ULONG(flags.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.SetFlags(ulFlags));
    }

    @Override
    public void setFlags(DebugBreakpoint.BreakFlags ... flags) {
        this.setFlags((BitmaskSet<DebugBreakpoint.BreakFlags>)BitmaskSet.of((Enum[])flags));
    }

    @Override
    public Long getOffset() {
        WinDef.ULONGLONGByReference pullOffset = new WinDef.ULONGLONGByReference();
        WinNT.HRESULT getOffset = this.jnaBreakpoint.GetOffset(pullOffset);
        if (getOffset.longValue() == -2147467262L) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)getOffset);
        return pullOffset.getValue().longValue();
    }

    @Override
    public void setOffset(long offset) {
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.SetOffset(ullOffset));
    }

    @Override
    public String getOffsetExpression() {
        WinDef.ULONGByReference pulExpressionSize = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetOffsetExpression(null, new WinDef.ULONG(0L), pulExpressionSize));
        byte[] buffer = new byte[pulExpressionSize.getValue().intValue()];
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetOffsetExpression(buffer, pulExpressionSize.getValue(), null));
        return Native.toString((byte[])buffer);
    }

    @Override
    public void setOffsetExpression(String expression) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.SetOffsetExpression(expression));
    }

    @Override
    public DebugBreakpoint.BreakDataParameters getDataParameters() {
        WinDef.ULONGByReference pulSize = new WinDef.ULONGByReference();
        WinDef.ULONGByReference pulAccessType = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.GetDataParameters(pulSize, pulAccessType));
        return new DebugBreakpoint.BreakDataParameters(pulSize.getValue().intValue(), (BitmaskSet<DebugBreakpoint.BreakAccess>)new BitmaskSet(DebugBreakpoint.BreakAccess.class, (long)pulAccessType.getValue().intValue()));
    }

    @Override
    public void setDataParameters(DebugBreakpoint.BreakDataParameters params) {
        this.setDataParameters(params.size, params.access);
    }

    @Override
    public void setDataParameters(int size, BitmaskSet<DebugBreakpoint.BreakAccess> access) {
        WinDef.ULONG ulSize = new WinDef.ULONG((long)size);
        WinDef.ULONG ulAccessType = new WinDef.ULONG(access.getBitmask());
        COMUtils.checkRC((WinNT.HRESULT)this.jnaBreakpoint.SetDataParameters(ulSize, ulAccessType));
    }

    @Override
    public void setDataParameters(int size, DebugBreakpoint.BreakAccess ... access) {
        this.setDataParameters(size, (BitmaskSet<DebugBreakpoint.BreakAccess>)BitmaskSet.of((Enum[])access));
    }
}

