/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugRegisters;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.manager.impl.DbgThreadImpl;
import com.sun.jna.platform.win32.COM.COMException;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;

public class DbgWriteRegistersCommand
extends AbstractDbgCommand<Void> {
    private final DbgThreadImpl thread;
    private final Map<DbgRegister, BigInteger> regVals;

    public DbgWriteRegistersCommand(DbgManagerImpl manager, DbgThreadImpl thread, Integer frameId, Map<DbgRegister, BigInteger> regVals) {
        super(manager);
        this.thread = thread;
        this.regVals = regVals;
    }

    @Override
    public void invoke() {
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId previous = so.getCurrentThreadId();
        so.setCurrentThreadId(this.thread.getId());
        DebugRegisters registers = this.manager.getRegisters();
        LinkedHashMap<Integer, DebugValue> values = new LinkedHashMap<Integer, DebugValue>();
        for (DbgRegister r : this.regVals.keySet()) {
            try {
                BigInteger val = this.regVals.get(r);
                DebugRegisters.DebugRegisterDescription desc = registers.getDescription(r.getNumber());
                byte[] bytes = new byte[desc.type.byteLength];
                byte[] newBytes = val.toByteArray();
                int i = newBytes.length - 1;
                for (int j = bytes.length - 1; i >= 0 && j >= 0; --i, --j) {
                    bytes[j] = newBytes[i];
                }
                DebugValue dv = desc.type.decodeBytes(bytes);
                values.put(r.getNumber(), dv);
            }
            catch (COMException e) {
                this.manager.getControl().errln("No register: " + r.getName());
            }
        }
        registers.setValues(DebugRegisters.DebugRegisterSource.DEBUG_REGSRC_DEBUGGEE, values);
        so.setCurrentThreadId(previous);
    }
}

