/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugBreakpoint;
import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugExceptionRecord64;
import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.dbgeng.util.DebugEventCallbacksAdapter;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.evt.DbgBreakpointEvent;
import agent.dbgeng.manager.evt.DbgExceptionEvent;
import agent.dbgeng.manager.evt.DbgModuleLoadedEvent;
import agent.dbgeng.manager.evt.DbgModuleUnloadedEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.evt.DbgProcessExitedEvent;
import agent.dbgeng.manager.evt.DbgStateChangedEvent;
import agent.dbgeng.manager.evt.DbgSystemErrorEvent;
import agent.dbgeng.manager.evt.DbgThreadCreatedEvent;
import agent.dbgeng.manager.evt.DbgThreadExitedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.comm.util.BitmaskSet;
import ghidra.util.Msg;
import java.nio.file.Paths;

public class DbgDebugEventCallbacksAdapter
extends DebugEventCallbacksAdapter {
    private DbgManagerImpl manager;

    public DbgDebugEventCallbacksAdapter(DbgManagerImpl manager) {
        this.manager = manager;
    }

    protected DebugClient.DebugStatus checkInterrupt(DebugClient.DebugStatus normal) {
        if (this.manager.getControl().getInterrupt()) {
            return DebugClient.DebugStatus.BREAK;
        }
        return normal;
    }

    @Override
    public DebugClient.DebugStatus breakpoint(DebugBreakpoint bp) {
        Msg.info((Object)this, (Object)("***Breakpoint: " + bp.getId()));
        return this.checkInterrupt(this.manager.processEvent(new DbgBreakpointEvent(bp)));
    }

    @Override
    public DebugClient.DebugStatus exception(DebugExceptionRecord64 exception, boolean firstChance) {
        Msg.info((Object)this, (Object)("***Exception: " + exception + ", first=" + firstChance));
        return this.checkInterrupt(this.manager.processEvent(new DbgExceptionEvent(exception)));
    }

    @Override
    public DebugClient.DebugStatus createThread(DebugThreadInfo threadInfo) {
        Msg.info((Object)this, (Object)("***Thread created: " + Long.toHexString(threadInfo.handle)));
        return this.checkInterrupt(this.manager.processEvent(new DbgThreadCreatedEvent(threadInfo)));
    }

    @Override
    public DebugClient.DebugStatus exitThread(int exitCode) {
        Msg.info((Object)this, (Object)("***Thread exited: " + exitCode));
        return this.checkInterrupt(this.manager.processEvent(new DbgThreadExitedEvent(exitCode)));
    }

    @Override
    public DebugClient.DebugStatus createProcess(DebugProcessInfo processInfo) {
        Msg.info((Object)this, (Object)("***Process created: " + Long.toHexString(processInfo.handle)));
        Msg.info((Object)this, (Object)(" **Thread created: " + Long.toHexString(processInfo.initialThreadInfo.handle)));
        return this.checkInterrupt(this.manager.processEvent(new DbgProcessCreatedEvent(processInfo)));
    }

    @Override
    public DebugClient.DebugStatus exitProcess(int exitCode) {
        Msg.info((Object)this, (Object)("***Process exited: " + exitCode));
        Msg.info((Object)this, (Object)" **Thread exited");
        return this.checkInterrupt(this.manager.processEvent(new DbgProcessExitedEvent(exitCode)));
    }

    @Override
    public DebugClient.DebugStatus loadModule(DebugModuleInfo moduleInfo) {
        Msg.info((Object)this, (Object)("***Module Loaded: " + moduleInfo));
        return this.checkInterrupt(this.manager.processEvent(new DbgModuleLoadedEvent(moduleInfo)));
    }

    @Override
    public DebugClient.DebugStatus unloadModule(String imageBaseName, long baseOffset) {
        Msg.info((Object)this, (Object)("***Module Unloaded: " + imageBaseName + ", " + Long.toHexString(baseOffset)));
        DebugModuleInfo info = new DebugModuleInfo(0L, baseOffset, 0, this.basename(imageBaseName), imageBaseName, 0, 0);
        return this.checkInterrupt(this.manager.processEvent(new DbgModuleUnloadedEvent(info)));
    }

    private String basename(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    @Override
    public DebugClient.DebugStatus changeEngineState(BitmaskSet<DebugClient.ChangeEngineState> flags, long argument) {
        DbgStateChangedEvent event = new DbgStateChangedEvent(flags);
        event.setArgument(argument);
        if (flags.contains((Object)DebugClient.ChangeEngineState.EXECUTION_STATUS)) {
            if (DebugClient.DebugStatus.isInsideWait(argument)) {
                return DebugClient.DebugStatus.NO_CHANGE;
            }
            DebugClient.DebugStatus status = DebugClient.DebugStatus.fromArgument(argument);
            Msg.info((Object)this, (Object)("***ExecutionStatus: " + status));
            if (status.equals((Object)DebugClient.DebugStatus.NO_DEBUGGEE)) {
                long processCount = this.manager.getProcessCount();
                event.setState(processCount > 0L ? DbgState.SESSION_EXIT : DbgState.EXIT);
            }
            return this.checkInterrupt(this.manager.processEvent(event));
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.BREAKPOINTS)) {
            Msg.info((Object)this, (Object)("***BreakpointChanged: " + flags + ", " + argument + " on " + Thread.currentThread()));
            return this.checkInterrupt(this.manager.processEvent(event));
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.CURRENT_THREAD)) {
            Msg.info((Object)this, (Object)("***CurrentThread: " + argument));
            return this.checkInterrupt(this.manager.processEvent(event));
        }
        if (flags.contains((Object)DebugClient.ChangeEngineState.SYSTEMS)) {
            Msg.info((Object)this, (Object)("***Systems: " + argument));
            event.setState(DbgState.RUNNING);
            return this.checkInterrupt(this.manager.processEvent(event));
        }
        return this.checkInterrupt(DebugClient.DebugStatus.NO_CHANGE);
    }

    @Override
    public DebugClient.DebugStatus systemError(int error, int level) {
        return this.checkInterrupt(this.manager.processEvent(new DbgSystemErrorEvent(error, level)));
    }
}

