/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jungrapht.visualization.control.DefaultModalGraphMouse;
import org.jungrapht.visualization.control.LensGraphMouse;
import org.jungrapht.visualization.control.LensKillingGraphMousePlugin;
import org.jungrapht.visualization.control.LensMagnificationGraphMousePlugin;
import org.jungrapht.visualization.control.LensSelectingGraphMousePlugin;
import org.jungrapht.visualization.control.LensTranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.Modifiers;
import org.jungrapht.visualization.control.TranslatingGraphMousePlugin;
import org.jungrapht.visualization.control.modal.Modal;

public class ModalLensGraphMouse<V, E>
extends DefaultModalGraphMouse<V, E>
implements ModalGraphMouse,
LensGraphMouse {
    protected LensMagnificationGraphMousePlugin magnificationPlugin;
    protected LensSelectingGraphMousePlugin lensSelectingGraphMousePlugin;
    protected LensKillingGraphMousePlugin lensKillingGraphMousePlugin;
    protected LensTranslatingGraphMousePlugin lensTranslatingGraphMousePlugin;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    public ModalLensGraphMouse() {
        this(new Builder());
    }

    ModalLensGraphMouse(Builder<V, E, ?, ?> builder) {
        super(builder.mode, builder.in, builder.out, builder.vertexSelectionOnly, builder.singleSelectionMask, builder.toggleSingleSelectionMask, builder.regionSelectionMask, builder.toggleRegionSelectionMask, builder.regionSelectionCompleteMask, builder.toggleRegionSelectionCompleteMask, builder.translatingMask, builder.scalingMask, builder.xAxisScalingMask, builder.yAxisScalingMask);
        this.magnificationPlugin = builder.magnificationPlugin;
        this.lensTranslatingGraphMousePlugin = new LensTranslatingGraphMousePlugin(builder.lensTranslatingMask);
        this.lensKillingGraphMousePlugin = new LensKillingGraphMousePlugin();
        this.translatingPlugin = ((TranslatingGraphMousePlugin.Builder)TranslatingGraphMousePlugin.builder().translatingMask(this.translatingMask)).build();
    }

    @Override
    public void setKillSwitch(Runnable killSwitch) {
        this.lensKillingGraphMousePlugin.setKillSwitch(killSwitch);
    }

    @Override
    public void loadPlugins() {
        super.loadPlugins();
        this.setMode(this.mode);
    }

    @Override
    protected void setPickingMode() {
        this.clear();
        this.add(this.lensKillingGraphMousePlugin);
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.clear();
        this.add(this.lensKillingGraphMousePlugin);
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
        this.add(this.lensTranslatingGraphMousePlugin);
        this.add(this.translatingPlugin);
        this.add(this.selectingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(Modal.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(Modal.Mode.PICKING);
            }
        }
    }

    public static class Builder<V, E, T extends ModalLensGraphMouse<V, E>, B extends Builder<V, E, T, B>>
    extends DefaultModalGraphMouse.Builder<V, E, T, B> {
        protected LensMagnificationGraphMousePlugin magnificationPlugin;
        protected int lensTranslatingMask = Modifiers.masks.get(System.getProperty("jungrapht.lensTranslatingMask", "MB1"));

        public B magnificationPlugin(LensMagnificationGraphMousePlugin magnificationPlugin) {
            this.magnificationPlugin = magnificationPlugin;
            return (B)((Builder)this.self());
        }

        public B lensTranslatingMask(int lensTranslatingMask) {
            this.lensTranslatingMask = lensTranslatingMask;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new ModalLensGraphMouse(this);
        }
    }
}

