/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.dwarf4.LEB128;
import ghidra.file.formats.android.dex.format.EncodedValue;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationElement
implements StructConverter {
    private int nameIndex;
    private int nameIndexLength;
    private EncodedValue value;

    public AnnotationElement(BinaryReader reader) throws IOException {
        LEB128 leb128 = LEB128.readUnsignedValue((BinaryReader)reader);
        this.nameIndex = leb128.asUInt32();
        this.nameIndexLength = leb128.getLength();
        this.value = new EncodedValue(reader);
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public EncodedValue getValue() {
        return this.value;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType encodeValueDataType = this.value.toDataType();
        String name = "annotation_element_" + this.nameIndexLength + "_" + encodeValueDataType.getName();
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.nameIndexLength, BYTE.getLength()), "nameIndex", null);
        structure.add(encodeValueDataType, "value", null);
        structure.setCategoryPath(new CategoryPath("/dex/annotation_element"));
        return structure;
    }
}

