/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Thread
implements StructConverter {
    public static final String NAME = "MINIDUMP_THREAD";
    private int threadId;
    private int suspendCount;
    private int priorityClass;
    private int platformId;
    private int priority;
    private long teb;
    private long stackStartOfMemoryRange;
    private int stackDataSize;
    private int stackRVA;
    private int contextDataSize;
    private int contextRVA;
    private DumpFileReader reader;
    private long index;

    public Thread(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setThreadId(this.reader.readNextInt());
        this.setSuspendCount(this.reader.readNextInt());
        this.setPriorityClass(this.reader.readNextInt());
        this.setPriority(this.reader.readNextInt());
        this.setTeb(this.reader.readNextLong());
        this.setStackStartOfMemoryRange(this.reader.readNextLong());
        this.setStackDataSize(this.reader.readNextInt());
        this.setStackRVA(this.reader.readNextInt());
        this.setContextDataSize(this.reader.readNextInt());
        this.setContextRVA(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "ThreadId", null);
        struct.add(DWORD, 4, "SuspendCount", null);
        struct.add(DWORD, 4, "PriorityClass", null);
        struct.add(DWORD, 4, "Priority", null);
        struct.add(QWORD, 8, "Teb", null);
        StructureDataType s0 = new StructureDataType("Stack", 0);
        s0.add(QWORD, 8, "StartOfMemoryRange", null);
        s0.add(DWORD, 4, "DataSize", null);
        s0.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        StructureDataType s1 = new StructureDataType("Context", 0);
        s1.add(DWORD, 4, "DataSize", null);
        s1.add((DataType)Pointer32DataType.dataType, 4, "RVA", null);
        struct.add((DataType)s0, s0.getLength(), s0.getDisplayName(), null);
        struct.add((DataType)s1, s1.getLength(), s1.getDisplayName(), null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getSuspendCount() {
        return this.suspendCount;
    }

    public void setSuspendCount(int suspendCount) {
        this.suspendCount = suspendCount;
    }

    public int getPriorityClass() {
        return this.priorityClass;
    }

    public void setPriorityClass(int priorityClass) {
        this.priorityClass = priorityClass;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformId) {
        this.platformId = platformId;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public long getTeb() {
        return this.teb;
    }

    public void setTeb(long teb) {
        this.teb = teb;
    }

    public long getStackStartOfMemoryRange() {
        return this.stackStartOfMemoryRange;
    }

    public void setStackStartOfMemoryRange(long stackStartOfMemoryRange) {
        this.stackStartOfMemoryRange = stackStartOfMemoryRange;
    }

    public int getStackDataSize() {
        return this.stackDataSize;
    }

    public void setStackDataSize(int stackDataSize) {
        this.stackDataSize = stackDataSize;
    }

    public int getStackRVA() {
        return this.stackRVA;
    }

    public void setStackRVA(int stackRVA) {
        this.stackRVA = stackRVA;
    }

    public int getContextDataSize() {
        return this.contextDataSize;
    }

    public void setContextDataSize(int contextDataSize) {
        this.contextDataSize = contextDataSize;
    }

    public int getContextRVA() {
        return this.contextRVA;
    }

    public void setContextRVA(int contextRVA) {
        this.contextRVA = contextRVA;
    }
}

