/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.file.jad.JadProcessController;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;

class JarDecompilerTask
extends Task {
    private File file;
    private String desc;

    JarDecompilerTask(File file, String desc) {
        super("Decompiling...", true, true, false);
        this.file = file;
        this.desc = desc;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage(this.file.getAbsolutePath());
        monitor.setIndeterminate(true);
        try {
            JadProcessWrapper wrapper = new JadProcessWrapper(this.file);
            JadProcessController controller = new JadProcessController(wrapper, this.desc);
            controller.decompile(45, monitor);
        }
        catch (Exception e) {
            Msg.info((Object)((Object)this), (Object)"Exception in JarDecompileTask", (Throwable)e);
        }
    }
}

