/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.ComponentProvider;
import ghidra.app.plugin.core.byteviewer.ProgramByteViewerComponentProvider;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.util.ByteCopier;
import ghidra.app.util.ClipboardType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ByteViewerClipboardProvider
extends ByteCopier
implements ClipboardContentProviderService {
    private static final List<ClipboardType> COPY_TYPES = ByteViewerClipboardProvider.createCopyTypesList();
    private boolean copyEnabled;
    private boolean pasteEnabled;
    private Set<ChangeListener> listeners = new CopyOnWriteArraySet<ChangeListener>();
    private final ProgramByteViewerComponentProvider provider;

    private static List<ClipboardType> createCopyTypesList() {
        LinkedList<ClipboardType> copyTypesList = new LinkedList<ClipboardType>();
        copyTypesList.add(BYTE_STRING_TYPE);
        copyTypesList.add(BYTE_STRING_NO_SPACE_TYPE);
        copyTypesList.add(PYTHON_BYTE_STRING_TYPE);
        copyTypesList.add(PYTHON_LIST_TYPE);
        copyTypesList.add(CPP_BYTE_ARRAY_TYPE);
        return copyTypesList;
    }

    public ByteViewerClipboardProvider(ProgramByteViewerComponentProvider provider, PluginTool tool) {
        this.provider = provider;
        this.tool = tool;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyStateChanged() {
        ChangeEvent event = new ChangeEvent((Object)this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public boolean paste(Transferable pasteData) {
        try {
            return this.pasteBytes(pasteData);
        }
        catch (Exception e) {
            this.tool.setStatusInfo("Paste failed: " + e.getMessage(), true);
            return false;
        }
    }

    public List<ClipboardType> getCurrentCopyTypes() {
        if (this.copyEnabled) {
            return COPY_TYPES;
        }
        return EMPTY_LIST;
    }

    public Transferable copy(TaskMonitor monitor) {
        String byteString = this.copyBytesAsString((AddressSetView)this.currentSelection, true, monitor);
        String textSelection = this.getTextSelection();
        return new ByteCopier.ByteStringTransferable(byteString, textSelection);
    }

    protected String getTextSelection() {
        return this.provider.getCurrentTextSelection();
    }

    public Transferable copySpecial(ClipboardType copyType, TaskMonitor monitor) {
        return this.copyBytes(copyType, monitor);
    }

    private void updateEnablement() {
        this.copyEnabled = this.currentSelection != null && !this.currentSelection.isEmpty();
        this.notifyStateChanged();
    }

    void setLocation(ProgramLocation location) {
        this.currentLocation = location;
    }

    void setSelection(ProgramSelection selection) {
        this.currentSelection = selection;
        this.updateEnablement();
    }

    void setProgram(Program p) {
        this.currentProgram = p;
        this.currentLocation = null;
        this.currentSelection = null;
    }

    public boolean isValidContext(ActionContext context) {
        return context.getComponentProvider() == this.provider;
    }

    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    public boolean enableCopy() {
        return true;
    }

    public boolean enableCopySpecial() {
        return true;
    }

    public boolean canCopy() {
        return this.copyEnabled;
    }

    public boolean canCopySpecial() {
        return this.copyEnabled;
    }

    public boolean enablePaste() {
        return true;
    }

    boolean isPasteEnabled() {
        return this.pasteEnabled;
    }

    void setPasteEnabled(boolean pasteEnabled) {
        this.pasteEnabled = pasteEnabled;
        this.notifyStateChanged();
    }

    public boolean canPaste(DataFlavor[] availableFlavors) {
        if (!this.pasteEnabled) {
            return false;
        }
        if (availableFlavors != null) {
            for (DataFlavor flavor : availableFlavors) {
                if (!flavor.equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    public void lostOwnership(Transferable transferable) {
    }
}

