/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.buffers.DataBuffer;
import java.io.IOException;
import java.util.Arrays;

public class BinaryField
extends Field {
    public static final BinaryField INSTANCE = new BinaryField(null, true);
    protected byte[] data;
    private Integer hashcode;

    public BinaryField() {
    }

    public BinaryField(byte[] data) {
        this(data, false);
    }

    BinaryField(byte[] data, boolean immutable) {
        super(immutable);
        this.data = data;
    }

    @Override
    public boolean isNull() {
        return this.data == null;
    }

    @Override
    void setNull() {
        this.checkImmutable();
        this.data = null;
    }

    @Override
    void checkImmutable() {
        super.checkImmutable();
        this.hashcode = null;
    }

    @Override
    public byte[] getBinaryData() {
        return this.data;
    }

    @Override
    public void setBinaryData(byte[] data) {
        this.checkImmutable();
        this.data = data;
    }

    @Override
    int length() {
        return this.data == null ? 4 : this.data.length + 4;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        if (this.data == null) {
            return buf.putInt(offset, -1);
        }
        offset = buf.putInt(offset, this.data.length);
        return buf.put(offset, this.data);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.checkImmutable();
        int len = buf.getInt(offset);
        offset += 4;
        if (len < 0) {
            this.data = null;
        } else {
            this.data = buf.get(offset, len);
            offset += len;
        }
        return offset;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        int len = buf.getInt(offset);
        return (len < 0 ? 0 : len) + 4;
    }

    @Override
    public boolean isVariableLength() {
        return true;
    }

    @Override
    byte getFieldType() {
        return 5;
    }

    @Override
    void truncate(int length) {
        this.checkImmutable();
        int maxLen = length - 4;
        if (this.data != null && this.data.length > maxLen) {
            byte[] newData = new byte[maxLen];
            System.arraycopy(this.data, 0, newData, 0, maxLen);
            this.data = newData;
        }
    }

    @Override
    public int compareTo(Field o) {
        BinaryField f = (BinaryField)o;
        if (this.data == null) {
            if (f.data == null) {
                return 0;
            }
            return -1;
        }
        if (f.data == null) {
            return 1;
        }
        int len1 = this.data.length;
        int len2 = f.data.length;
        int offset1 = 0;
        int offset2 = 0;
        int n = Math.min(len1, len2);
        while (n-- != 0) {
            int b2;
            int b1;
            if ((b1 = this.data[offset1++] & 0xFF) == (b2 = f.data[offset2++] & 0xFF)) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        int len = buffer.getInt(offset);
        if (this.data == null) {
            if (len < 0) {
                return 0;
            }
            return -1;
        }
        if (len < 0) {
            return 1;
        }
        return -buffer.unsignedCompareTo(this.data, offset + 4, len);
    }

    @Override
    public BinaryField copyField() {
        if (this.isNull()) {
            return new BinaryField();
        }
        return new BinaryField((byte[])this.getBinaryData().clone());
    }

    @Override
    public BinaryField newField() {
        return new BinaryField();
    }

    @Override
    BinaryField getMinValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    BinaryField getMaxValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BinaryField f = (BinaryField)obj;
        return Arrays.equals(f.data, this.data);
    }

    @Override
    public int hashCode() {
        if (this.hashcode == null) {
            int h = 0;
            if (this.data != null) {
                for (byte b : this.data) {
                    h = 31 * h + (b & 0xFF);
                }
            }
            this.hashcode = h;
        }
        return this.hashcode;
    }

    public String toString() {
        byte[] d;
        String classname = this.getClass().getSimpleName();
        String nullState = "";
        if (this.isNull()) {
            nullState = "(NULL)";
        }
        if ((d = this.getBinaryData()) == null) {
            return classname + nullState + ": null";
        }
        return classname + nullState + ": [" + d.length + "] = 0x" + BinaryField.getValueAsString(d);
    }

    @Override
    public String getValueAsString() {
        byte[] d = this.getBinaryData();
        if (d == null) {
            return "null";
        }
        return "{" + BinaryField.getValueAsString(d) + "}";
    }

    public static String getValueAsString(byte[] data) {
        int i;
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < 24 && i < data.length; ++i) {
            String b = Integer.toHexString(data[i] & 0xFF);
            if (b.length() == 1) {
                buf.append('0');
            }
            buf.append(b);
            buf.append(' ');
        }
        if (i < data.length) {
            buf.append("...");
        }
        return buf.toString();
    }
}

