/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.PrimitiveField;
import db.buffers.DataBuffer;
import java.io.IOException;

public final class BooleanField
extends PrimitiveField {
    public static final BooleanField MIN_VALUE = new BooleanField(false, true);
    public static final BooleanField MAX_VALUE = new BooleanField(true, true);
    public static final BooleanField INSTANCE = MIN_VALUE;
    private byte value;

    public BooleanField() {
    }

    public BooleanField(boolean b) {
        this(b, false);
    }

    @Override
    void setNull() {
        super.setNull();
        this.value = 0;
    }

    BooleanField(boolean b, boolean immutable) {
        super(immutable);
        this.value = b ? (byte)1 : 0;
    }

    @Override
    public boolean getBooleanValue() {
        return this.value != 0;
    }

    @Override
    public void setBooleanValue(boolean b) {
        this.updatingPrimitiveValue();
        this.value = b ? (byte)1 : 0;
    }

    @Override
    int length() {
        return 1;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putByte(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.updatingPrimitiveValue();
        this.value = buf.getByte(offset);
        return offset + 1;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 1;
    }

    @Override
    byte getFieldType() {
        return 6;
    }

    @Override
    public String getValueAsString() {
        return Boolean.toString(this.getBooleanValue());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BooleanField)) {
            return false;
        }
        return ((BooleanField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        BooleanField f = (BooleanField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        byte otherValue = buffer.getByte(offset);
        if (this.value == otherValue) {
            return 0;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 1;
    }

    @Override
    public BooleanField copyField() {
        if (this.isNull()) {
            BooleanField copy = new BooleanField();
            copy.setNull();
            return copy;
        }
        return new BooleanField(this.getLongValue() != 0L);
    }

    @Override
    public BooleanField newField() {
        return new BooleanField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{this.value};
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes == null) {
            this.setNull();
            return;
        }
        if (bytes.length != 1) {
            throw new IllegalFieldAccessException();
        }
        this.updatingPrimitiveValue();
        this.value = bytes[0];
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    BooleanField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    BooleanField getMaxValue() {
        return MAX_VALUE;
    }
}

