/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.C11Lines;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13SectionIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalReferenceIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.GlobalReferenceOffsetIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.ModuleInformation;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStream;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Objects;

public class Module {
    private AbstractPdb pdb;
    private ModuleInformation moduleInformation;
    private int streamNumber;
    private MsfStream stream = null;
    private int offsetSymbols;
    private int offsetLines;
    private int offsetC13Lines;
    private int offsetGlobalRefs;
    private int sizeSymbols;
    private int sizeLines;
    private int sizeC13Lines;
    private int sizeGlobalRefs;
    private boolean doDumpGlobalRefererenceInfo = false;

    public Module(AbstractPdb pdb, ModuleInformation moduleInformation) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        Objects.requireNonNull(moduleInformation, "moduleInformation cannot be null");
        this.pdb = pdb;
        this.moduleInformation = moduleInformation;
        this.precalculateStreamLocations();
    }

    public ModuleInformation getModuleInformation() {
        return this.moduleInformation;
    }

    private void precalculateStreamLocations() {
        this.streamNumber = this.moduleInformation.getStreamNumberDebugInformation();
        if (this.streamNumber == 65535) {
            return;
        }
        this.stream = this.pdb.getMsf().getStream(this.streamNumber);
        if (this.stream == null) {
            return;
        }
        int length = this.stream.getLength();
        this.sizeSymbols = this.moduleInformation.getSizeLocalSymbolsDebugInformation();
        this.sizeLines = this.moduleInformation.getSizeLineNumberDebugInformation();
        this.sizeC13Lines = this.moduleInformation.getSizeC13StyleLineNumberInformation();
        this.offsetSymbols = 0;
        this.offsetLines = this.sizeSymbols;
        this.offsetC13Lines = this.offsetLines + this.sizeLines;
        this.offsetGlobalRefs = this.offsetC13Lines + this.sizeC13Lines;
        this.sizeGlobalRefs = length - this.offsetGlobalRefs;
    }

    public C11Lines getLineInformation() throws CancelledException, PdbException {
        if (this.sizeLines == 0) {
            return null;
        }
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber, this.offsetLines, this.sizeLines);
            C11Lines c11Lines = C11Lines.parse(this.pdb, reader);
            return c11Lines;
        }
        catch (IOException e) {
            return null;
        }
    }

    public MsSymbolIterator getSymbolIterator() throws CancelledException, PdbException {
        PdbByteReader symbolsReader = this.getSymbolsReader();
        this.parseSignature(symbolsReader);
        MsSymbolIterator iterator = new MsSymbolIterator(this.pdb, symbolsReader);
        return iterator;
    }

    private void parseSignature(PdbByteReader symbolsReader) throws PdbException {
        if (symbolsReader == PdbByteReader.DUMMY) {
            return;
        }
        boolean getSig = true;
        int cvSignature = 0;
        if (getSig) {
            cvSignature = symbolsReader.parseInt();
        }
        switch (cvSignature) {
            case 1: 
            case 2: {
                getSig = false;
                break;
            }
            case 4: {
                break;
            }
            default: {
                if (cvSignature >= 65536) break;
                throw new PdbException("PDB Error: Invalid module CV signature in stream " + this.streamNumber);
            }
        }
    }

    public C13SectionIterator<C13Section> getC13SectionIterator() throws CancelledException, PdbException {
        C13SectionIterator<C13Section> iterator = this.getC13SectionFilteredIterator(C13Section.class);
        return iterator;
    }

    public <T extends C13Section> C13SectionIterator<T> getC13SectionFilteredIterator(Class<T> clazz) throws CancelledException, PdbException {
        PdbByteReader c13SectionReader = this.getC13LinesReader();
        C13SectionIterator<T> iterator = new C13SectionIterator<T>(c13SectionReader, clazz, true, this.pdb.getMonitor());
        return iterator;
    }

    public GlobalReferenceOffsetIterator getGlobalReferenceOffsetIterator() throws CancelledException, PdbException {
        PdbByteReader globalRefsReader = this.getGlobalRefsReader();
        GlobalReferenceOffsetIterator iterator = new GlobalReferenceOffsetIterator(globalRefsReader);
        return iterator;
    }

    public GlobalReferenceIterator getGlobalReferenceIterator() throws CancelledException, PdbException {
        PdbByteReader globalRefsReader = this.getGlobalRefsReader();
        GlobalReferenceIterator iterator = new GlobalReferenceIterator(this.pdb, globalRefsReader);
        return iterator;
    }

    private PdbByteReader getSymbolsReader() throws CancelledException {
        return this.getReader(this.offsetSymbols, this.sizeSymbols, "Symbols");
    }

    private PdbByteReader getLinesReader() throws CancelledException {
        return this.getReader(this.offsetLines, this.sizeLines, "Lines");
    }

    private PdbByteReader getC13LinesReader() throws CancelledException {
        return this.getReader(this.offsetC13Lines, this.sizeC13Lines, "C13Lines");
    }

    private PdbByteReader getGlobalRefsReader() throws CancelledException {
        return this.getReader(this.offsetGlobalRefs, this.sizeGlobalRefs, "GlobalRefs");
    }

    private PdbByteReader getReader(int offset, int size, String sectionName) throws CancelledException {
        if (this.streamNumber == 65535) {
            return PdbByteReader.DUMMY;
        }
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(this.streamNumber);
            reader.skip(offset);
            try {
                if (size == -1) {
                    size = reader.parseInt();
                }
                if (size == 0) {
                    return PdbByteReader.DUMMY;
                }
                return reader.getSubPdbByteReader(size);
            }
            catch (PdbException e) {
                PdbLog.message("Exception retrieving PdbByteReader for stream " + this.streamNumber + " sectionName: " + e.getMessage());
                return PdbByteReader.DUMMY;
            }
        }
        catch (IOException e) {
            PdbLog.message("Exception sub-reader from reader for stream " + this.streamNumber + " sectionName: " + e.getMessage());
            return PdbByteReader.DUMMY;
        }
    }

    void dump(Writer writer) throws CancelledException, PdbException, IOException {
        writer.write("Module------------------------------------------------------\n");
        this.dumpSymbols(writer);
        this.dumpC11Lines(writer);
        this.dumpC13Sections(writer);
        if (this.doDumpGlobalRefererenceInfo) {
            this.dumpGlobalReferenceOffsets(writer);
            this.dumpGlobalReferences(writer);
        }
        writer.write("End Module--------------------------------------------------\n");
    }

    private void dumpSymbols(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("Symbols-----------------------------------------------------\n");
        MsSymbolIterator symbolIterator = this.getSymbolIterator();
        while (symbolIterator.hasNext()) {
            this.pdb.checkCanceled();
            AbstractMsSymbol symbol = symbolIterator.next();
            writer.append(symbol.toString());
            writer.append("\n");
        }
        writer.write("End Symbols-------------------------------------------------\n");
    }

    private void dumpC11Lines(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("C11Lines----------------------------------------------------\n");
        C11Lines c11lines = this.getLineInformation();
        if (c11lines != null) {
            writer.write(c11lines.dump());
        }
        writer.write("End C11Lines------------------------------------------------\n");
    }

    private void dumpC13Sections(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("C13Sections-------------------------------------------------\n");
        C13SectionIterator<C13Section> c13Iterator = this.getC13SectionFilteredIterator(C13Section.class);
        while (c13Iterator.hasNext()) {
            this.pdb.checkCanceled();
            Object c13Section = c13Iterator.next();
            ((C13Section)c13Section).dump(writer);
        }
        writer.write("End C13Sections---------------------------------------------\n");
    }

    private void dumpGlobalReferenceOffsets(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("GlobalReferenceSymbolOffsets--------------------------------\n");
        ArrayList<Long> tmp = new ArrayList<Long>();
        GlobalReferenceOffsetIterator globalRefsOffsetIterator = this.getGlobalReferenceOffsetIterator();
        while (globalRefsOffsetIterator.hasNext()) {
            this.pdb.checkCanceled();
            Long val = globalRefsOffsetIterator.next();
            writer.append(String.format("0x%08x\n", val));
            tmp.add(val);
        }
        int cnt = 0;
        GlobalReferenceOffsetIterator globalReferenceOffsetIterator = this.getGlobalReferenceOffsetIterator();
        while (globalReferenceOffsetIterator.hasNext()) {
            long val2;
            long val = globalReferenceOffsetIterator.next();
            if (val == (val2 = ((Long)tmp.get(cnt++)).longValue())) continue;
            int a = 1;
            ++a;
        }
        writer.write("End GlobalReferenceSymbolOffsets----------------------------\n");
    }

    private void dumpGlobalReferences(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("GlobalReferenceSymbols--------------------------------------\n");
        GlobalReferenceIterator globalReferenceIterator = this.getGlobalReferenceIterator();
        while (globalReferenceIterator.hasNext()) {
            this.pdb.checkCanceled();
            MsSymbolIterator symIter = globalReferenceIterator.next();
            if (symIter.hasNext()) {
                AbstractMsSymbol sym = symIter.next();
                writer.append(String.format("%s\n", sym.toString()));
                continue;
            }
            writer.append("No sym in MsSymIterator returned by GlobalReferensIterator\n");
        }
        writer.write("End GlobalReferenceSymbols----------------------------------\n");
    }
}

