/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.DebugHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.math.BigInteger;

public class RvaVaDebugHeader
extends DebugHeader {
    private long relativeVirtualAddressDataBase;
    private BigInteger virtualAddressImageBase;
    private long unsignedIntReserved1;
    private long unsignedIntReserved2;

    public long getRelativeVirtualAddressDataBase() {
        return this.relativeVirtualAddressDataBase;
    }

    public BigInteger getVirtualAddressImageBase() {
        return this.virtualAddressImageBase;
    }

    public long getReserved1() {
        return this.unsignedIntReserved1;
    }

    public long getReserved2() {
        return this.unsignedIntReserved2;
    }

    @Override
    public void deserialize(PdbByteReader reader) throws PdbException {
        super.deserialize(reader);
        this.relativeVirtualAddressDataBase = reader.parseUnsignedIntVal();
        this.virtualAddressImageBase = reader.parseUnsignedLongVal();
        this.unsignedIntReserved1 = reader.parseUnsignedIntVal();
        this.unsignedIntReserved2 = reader.parseUnsignedIntVal();
    }

    @Override
    String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("RvaVaDebugHeader--------------------------------------------\n");
        this.dumpInternal(builder);
        builder.append("End RvaVaDebugHeader----------------------------------------\n");
        return builder.toString();
    }

    @Override
    protected void dumpInternal(StringBuilder builder) {
        super.dumpInternal(builder);
        builder.append(String.format("relativeVirtualAddressDataBase: 0X%08X\n", this.relativeVirtualAddressDataBase));
        builder.append(String.format("virtualAddressImageBase: 0X%016X\n", this.virtualAddressImageBase));
        builder.append(String.format("unsignedIntReserved1: 0X%08X\n", this.unsignedIntReserved1));
        builder.append(String.format("unsignedIntReserved2: 0X%08X\n", this.unsignedIntReserved2));
    }
}

