/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.PdbAnalyzerCommon;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import pdb.LoadPdbTask;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SameDirSymbolStore;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;
import pdb.symbolserver.SymbolServerInstanceCreatorContext;
import pdb.symbolserver.SymbolServerInstanceCreatorRegistry;
import pdb.symbolserver.SymbolServerService;
import pdb.symbolserver.SymbolStore;
import pdb.symbolserver.ui.ConfigPdbDialog;
import pdb.symbolserver.ui.LoadPdbDialog;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Import External PDB Files", description="This plugin manages the import of PDB files to add debug information to a program.")
public class PdbPlugin
extends Plugin {
    private static final String PDB_SYMBOL_SERVER_OPTIONS = "PdbSymbolServer";
    private static final String SYMBOL_STORAGE_DIR_OPTION = "PdbSymbolServer.Symbol_Storage_Directory";
    private static final String SYMBOL_SEARCH_PATH_OPTION = "PdbSymbolServer.Symbol_Search_Path";
    public static final String PDB_PLUGIN_HELP_TOPIC = "Pdb";

    public PdbPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        ((ActionBuilder)new ActionBuilder("Load PDB File", this.getName()).supportsDefaultToolContext(true)).withContext(ProgramActionContext.class).validContextWhen(pac -> pac.getProgram() != null && PdbAnalyzerCommon.canAnalyzeProgram(pac.getProgram())).menuPath(new String[]{"&File", "Load PDB File..."}).menuGroup("Import PDB", "3").helpLocation(new HelpLocation(PDB_PLUGIN_HELP_TOPIC, "Load PDB File")).onAction(pac -> this.loadPDB((ProgramActionContext)pac)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Symbol Server Config", this.getName()).menuPath(new String[]{"&Edit", "Symbol Server Config"})).menuGroup("AOptions")).helpLocation(new HelpLocation(PDB_PLUGIN_HELP_TOPIC, "Symbol Server Config"))).onAction(ac -> this.configPDB())).buildAndInstall((Tool)this.tool);
    }

    private void configPDB() {
        ConfigPdbDialog.showSymbolServerConfig();
    }

    private void loadPDB(ProgramActionContext pac) {
        int response;
        Program program = pac.getProgram();
        AutoAnalysisManager currentAutoAnalysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        if (currentAutoAnalysisManager.isAnalyzing()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to load PDB file while analysis is running.");
            return;
        }
        boolean analyzed = program.getOptions("Program Information").getBoolean("Analyzed", false);
        if (analyzed && (response = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Load PDB Warning", (String)"Loading PDB after running analysis may produce poor results.\nPDBs should generally be loaded prior to analysis or\nautomatically during auto-analysis.", (String)"Continue")) != 1) {
            return;
        }
        File pdbFile = null;
        try {
            LoadPdbDialog.LoadPdbResults loadPdbResults = LoadPdbDialog.choosePdbForProgram(program);
            if (loadPdbResults == null) {
                this.tool.setStatusInfo("Loading PDB was cancelled.");
                return;
            }
            pdbFile = loadPdbResults.pdbFile;
            this.tool.setStatusInfo("");
            DataTypeManagerService dataTypeManagerService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
            if (dataTypeManagerService == null) {
                Msg.showWarn(((Object)((Object)this)).getClass(), null, (String)"Load PDB", (Object)"Unable to locate DataTypeService in the current tool.");
                return;
            }
            LoadPdbTask loadPdbTask = new LoadPdbTask(program, pdbFile, loadPdbResults.useMsDiaParser, loadPdbResults.control, dataTypeManagerService);
            TaskBuilder.withTask((Task)loadPdbTask).setStatusTextAlignment(10).setLaunchDelay(0);
            new TaskLauncher((Task)loadPdbTask, null, 0);
            if (loadPdbTask.getResultException() != null) {
                throw loadPdbTask.getResultException();
            }
            if (loadPdbTask.getResultMessages() != null) {
                MultiLineMessageDialog dialog = new MultiLineMessageDialog("Load PDB File", "There were warnings/errors loading PDB file: " + pdbFile, loadPdbTask.getResultMessages(), 2, false);
                DockingWindowManager.showDialog(null, (DialogComponentProvider)dialog);
            }
        }
        catch (Exception e) {
            String message = null;
            message = e instanceof InvocationTargetException && e.getCause() != null ? Objects.requireNonNullElse(e.getCause().getMessage(), e.getCause().toString()) : Objects.requireNonNullElse(e.getMessage(), e.toString());
            Msg.showError((Object)((Object)this), null, (String)"Error Loading PDB", (Object)("Error processing PDB file: " + pdbFile + "\n" + message), (Throwable)e);
        }
    }

    public static File findPdb(Program program, Set<FindOption> findOptions, TaskMonitor monitor) {
        try {
            SymbolFileInfo symbolFileInfo = SymbolFileInfo.fromProgramInfo(program);
            if (symbolFileInfo == null) {
                return null;
            }
            findOptions = findOptions.isEmpty() ? EnumSet.noneOf(FindOption.class) : EnumSet.copyOf(findOptions);
            findOptions.add(FindOption.ONLY_FIRST_RESULT);
            SymbolServerInstanceCreatorContext temporarySymbolServerInstanceCreatorContext = SymbolServerInstanceCreatorRegistry.getInstance().getContext(program);
            SymbolServerService temporarySymbolServerService = PdbPlugin.getSymbolServerService(temporarySymbolServerInstanceCreatorContext);
            List<SymbolFileLocation> results = temporarySymbolServerService.find(symbolFileInfo, findOptions, monitor);
            if (!results.isEmpty()) {
                return temporarySymbolServerService.getSymbolFile(results.get(0), monitor);
            }
        }
        catch (CancelledException symbolFileInfo) {
        }
        catch (IOException e) {
            Msg.error(PdbPlugin.class, (Object)"Error getting symbol file", (Throwable)e);
        }
        return null;
    }

    public static SymbolServerService getSymbolServerService(SymbolServerInstanceCreatorContext symbolServerInstanceCreatorContext) {
        SymbolServer temporarySymbolServer = symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().newSymbolServer(Preferences.getProperty((String)SYMBOL_STORAGE_DIR_OPTION, (String)"", (boolean)true), symbolServerInstanceCreatorContext);
        SymbolStore symbolStore = temporarySymbolServer instanceof SymbolStore ? (SymbolStore)temporarySymbolServer : new SameDirSymbolStore(symbolServerInstanceCreatorContext.getRootDir());
        List<SymbolServer> symbolServers = symbolServerInstanceCreatorContext.getSymbolServerInstanceCreatorRegistry().createSymbolServersFromPathList(PdbPlugin.getSymbolSearchPaths(), symbolServerInstanceCreatorContext);
        return new SymbolServerService(symbolStore, symbolServers);
    }

    public static void saveSymbolServerServiceConfig(SymbolServerService symbolServerService) {
        if (symbolServerService != null) {
            Preferences.setProperty((String)SYMBOL_STORAGE_DIR_OPTION, (String)symbolServerService.getSymbolStore().getName());
            String path = symbolServerService.getSymbolServers().stream().map(SymbolServer::getName).collect(Collectors.joining(";"));
            Preferences.setProperty((String)SYMBOL_SEARCH_PATH_OPTION, (String)path);
        } else {
            Preferences.setProperty((String)SYMBOL_STORAGE_DIR_OPTION, null);
            Preferences.setProperty((String)SYMBOL_SEARCH_PATH_OPTION, null);
        }
    }

    private static List<String> getSymbolSearchPaths() {
        String searchPathStr = Preferences.getProperty((String)SYMBOL_SEARCH_PATH_OPTION, (String)"", (boolean)true);
        String[] pathParts = searchPathStr.split(";");
        ArrayList<String> result = new ArrayList<String>();
        for (String part : pathParts) {
            if ((part = part.trim()).isEmpty()) continue;
            result.add(part);
        }
        return result;
    }
}

