/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti4BackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti4Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.PEUtil;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.bytesearch.GenericByteSequencePattern;
import ghidra.util.bytesearch.GenericMatchAction;
import ghidra.util.bytesearch.Match;
import ghidra.util.bytesearch.MemoryBytePatternSearcher;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RttiAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Windows x86 PE RTTI Analyzer";
    private static final String DESCRIPTION = "Finds and creates RTTI metadata structures and associated vf tables.";
    private static final String CLASS_PREFIX_CHARS = ".?A";
    private DataValidationOptions validationOptions;
    private DataApplyOptions applyOptions;

    public RttiAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.REFERENCE_ANALYSIS.before());
        this.setDefaultEnablement(true);
        this.validationOptions = new DataValidationOptions();
        this.applyOptions = new DataApplyOptions();
    }

    public boolean canAnalyze(Program program) {
        return PEUtil.isVisualStudioOrClangPe(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address commonVfTableAddress = RttiUtil.findTypeInfoVftableAddress(program, monitor);
        if (commonVfTableAddress == null) {
            return true;
        }
        RttiUtil.createTypeInfoVftableSymbol(program, commonVfTableAddress);
        Set<Address> possibleTypeAddresses = this.locatePotentialRTTI0Entries(program, set, monitor);
        if (possibleTypeAddresses == null) {
            return true;
        }
        this.processRtti0(possibleTypeAddresses, program, monitor);
        return true;
    }

    private Set<Address> locatePotentialRTTI0Entries(Program program, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        Address commonVfTableAddress = RttiUtil.findTypeInfoVftableAddress(program, monitor);
        if (commonVfTableAddress == null) {
            return null;
        }
        int alignment = program.getDefaultPointerSize();
        List dataBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)program.getMemory(), (String)".data", (TaskMonitor)TaskMonitor.DUMMY);
        Set possibleTypeAddresses = ProgramMemoryUtil.findDirectReferences((Program)program, (List)dataBlocks, (int)alignment, (Address)commonVfTableAddress, (TaskMonitor)monitor);
        return possibleTypeAddresses;
    }

    private void processRtti0(Collection<Address> possibleRtti0Addresses, Program program, TaskMonitor monitor) throws CancelledException {
        monitor.setMaximum((long)possibleRtti0Addresses.size());
        monitor.setMessage("Creating RTTI Data...");
        ArrayList<Address> rtti0Locations = new ArrayList<Address>();
        int count = 0;
        for (Address rtti0Address : possibleRtti0Addresses) {
            monitor.checkCanceled();
            monitor.setProgress((long)count++);
            TypeDescriptorModel typeModel = new TypeDescriptorModel(program, rtti0Address, this.validationOptions);
            try {
                String typeName = typeModel.getTypeName();
                if (typeName == null) continue;
                if (!typeName.startsWith(CLASS_PREFIX_CHARS)) {
                }
            }
            catch (InvalidDataTypeException e) {}
            continue;
            CreateTypeDescriptorBackgroundCmd typeDescCmd = new CreateTypeDescriptorBackgroundCmd(rtti0Address, this.validationOptions, this.applyOptions);
            typeDescCmd.applyTo((DomainObject)program, monitor);
            rtti0Locations.add(rtti0Address);
        }
        this.processRtti4sForRtti0(program, rtti0Locations, monitor);
    }

    private void processRtti4sForRtti0(Program program, List<Address> rtti0Locations, TaskMonitor monitor) throws CancelledException {
        List dataBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)program.getMemory(), (String)".rdata", (TaskMonitor)monitor);
        dataBlocks.addAll(ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)program.getMemory(), (String)".data", (TaskMonitor)monitor));
        dataBlocks.addAll(ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)program.getMemory(), (String)".text", (TaskMonitor)monitor));
        List<Address> rtti4Addresses = RttiAnalyzer.getRtti4Addresses(program, dataBlocks, rtti0Locations, this.validationOptions, monitor);
        if (rtti4Addresses.size() > 0) {
            CreateRtti4BackgroundCmd cmd = new CreateRtti4BackgroundCmd(rtti4Addresses, (List<MemoryBlock>)dataBlocks, this.validationOptions, this.applyOptions);
            cmd.applyTo((DomainObject)program, monitor);
        }
    }

    private static List<Address> getRtti4Addresses(Program program, List<MemoryBlock> rtti4Blocks, List<Address> rtti0Locations, DataValidationOptions validationOptions, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        List<Address> addresses = RttiAnalyzer.getRefsToRtti0(program, rtti4Blocks, rtti0Locations, validationOptions, monitor);
        return addresses;
    }

    private static List<Address> getRefsToRtti0(Program program, List<MemoryBlock> dataBlocks, List<Address> rtti0Locations, DataValidationOptions validationOptions, TaskMonitor monitor) throws CancelledException {
        ArrayList<Address> addresses = new ArrayList<Address>();
        int rtti0PointerOffset = Rtti4Model.getRtti0PointerComponentOffset();
        MemoryBytePatternSearcher searcher = new MemoryBytePatternSearcher("RTTI0 references");
        for (Address rtti0Address : rtti0Locations) {
            byte[] bytes;
            if (MSDataTypeUtils.is64Bit((Program)program)) {
                bytes = ProgramMemoryUtil.getImageBaseOffsets32Bytes((Program)program, (int)4, (Address)rtti0Address);
                RttiAnalyzer.addByteSearchPattern(searcher, validationOptions, addresses, rtti0PointerOffset, rtti0Address, bytes);
                continue;
            }
            bytes = ProgramMemoryUtil.getDirectAddressBytes((Program)program, (Address)rtti0Address);
            RttiAnalyzer.addByteSearchPattern(searcher, validationOptions, addresses, rtti0PointerOffset, rtti0Address, bytes);
        }
        AddressSet searchSet = new AddressSet();
        for (MemoryBlock block : dataBlocks) {
            searchSet.add(block.getStart(), block.getEnd());
        }
        searcher.search(program, (AddressSetView)searchSet, monitor);
        return addresses;
    }

    private static void addByteSearchPattern(MemoryBytePatternSearcher searcher, final DataValidationOptions validationOptions, final List<Address> addresses, final int rtti0PointerOffset, Address rtti0Address, byte[] bytes) {
        if (bytes == null) {
            return;
        }
        GenericMatchAction<Address> action = new GenericMatchAction<Address>(rtti0Address){

            public void apply(Program prog, Address addr, Match match) {
                Address possibleRtti4Address;
                try {
                    possibleRtti4Address = addr.subtractNoWrap((long)rtti0PointerOffset);
                }
                catch (AddressOverflowException e) {
                    return;
                }
                Rtti4Model rtti4Model = new Rtti4Model(prog, possibleRtti4Address, validationOptions);
                try {
                    rtti4Model.validate();
                }
                catch (InvalidDataTypeException e) {
                    return;
                }
                boolean refersToRtti0 = rtti4Model.refersToRtti0((Address)this.getMatchValue());
                if (!refersToRtti0) {
                    return;
                }
                addresses.add(possibleRtti4Address);
            }
        };
        GenericByteSequencePattern genericByteMatchPattern = new GenericByteSequencePattern(bytes, (GenericMatchAction)action);
        searcher.addPattern((Pattern)genericByteMatchPattern);
    }
}

