/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import docking.widgets.label.GDLabel;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;

public class StatusLabel
extends GDLabel
implements FilterStatusListener {
    private final JFormattedTextField textField;

    public StatusLabel(final JFormattedTextField textField, final Object defaultValue) {
        this.textField = textField;
        textField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                StatusLabel.this.resetBounds();
            }
        });
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textField.setValue(defaultValue);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private void resetBounds() {
        Container myParent = this.getParent();
        Container textFieldParent = this.textField.getParent();
        Rectangle textBounds = this.textField.getBounds();
        Point textFieldLocation = textBounds.getLocation();
        Point convertedLocation = SwingUtilities.convertPoint(textFieldParent, textFieldLocation, myParent);
        int alignment = this.textField.getHorizontalAlignment();
        if (alignment == 4 || alignment == 11) {
            Dimension size = this.getPreferredSize();
            int x = convertedLocation.x;
            int y = convertedLocation.y;
            this.setBounds(x, y, size.width, size.height);
        } else if (alignment == 2 || alignment == 10) {
            Dimension size = this.getPreferredSize();
            int x = convertedLocation.x + textBounds.width - size.width;
            int y = convertedLocation.y;
            this.setBounds(x, y, size.width, size.height);
        }
    }

    @Override
    public void filterStatusChanged(Filter.FilterEditingStatus status) {
        this.resetBounds();
        this.setIcon(status.getIcon());
        this.setToolTipText(status.getDescription() + " (click to reset)");
    }
}

